/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.diff.internal.extension.factories;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.diagram.DiagramCompareFactory;
import org.eclipse.emf.compare.diagram.DiagramDiff;
import org.eclipse.emf.compare.diagram.NodeChange;
import org.eclipse.emf.compare.diagram.diff.DiagramComparisonConfiguration;
import org.eclipse.emf.compare.diagram.diff.internal.extension.AbstractDiffExtensionFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeChangeFactory
extends AbstractDiffExtensionFactory {
    private final DiagramComparisonConfiguration configuration;

    public NodeChangeFactory(DiagramComparisonConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Class<? extends Diff> getExtensionKind() {
        return NodeChange.class;
    }

    @Override
    public Diff create(Diff input) {
        NodeChange ret = DiagramCompareFactory.eINSTANCE.createNodeChange();
        DifferenceKind extensionKind = this.getRelatedExtensionKind(input);
        ret.setKind(extensionKind);
        if (extensionKind == DifferenceKind.DELETE) {
            ret.getRefinedBy().add((Object)input);
        } else if (extensionKind == DifferenceKind.ADD) {
            ret.getRefinedBy().add((Object)input);
            ret.getRefinedBy().addAll(this.getAllContainedDifferences((ReferenceChange)input));
        } else if (extensionKind == DifferenceKind.MOVE) {
            ret.getRefinedBy().addAll((Collection)input.getMatch().getDifferences());
        }
        if (input instanceof ReferenceChange) {
            ret.setView(((ReferenceChange)input).getValue());
        } else if (input instanceof AttributeChange) {
            Comparison comparison = input.getMatch().getComparison();
            EObject container = MatchUtil.getContainer((Comparison)comparison, (Diff)input);
            while (container != null && !(container instanceof View)) {
                container = container.eContainer();
            }
            ret.setView(container);
        }
        ret.setSource(input.getSource());
        ret.setSemanticDiff(this.getSemanticDiff(input));
        return ret;
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
        EList candidates;
        DiagramDiff diff = (DiagramDiff)extension;
        Diff semanticDiff = diff.getSemanticDiff();
        if (semanticDiff == null) {
            return;
        }
        for (Diff semanticRequired : semanticDiff.getRequires()) {
            candidates = comparison.getDifferences((EObject)semanticRequired);
            for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates, DiagramDiff.class)) {
                if (diagramDiff.getSemanticDiff() != semanticRequired) continue;
                diff.getRequires().add((Object)diagramDiff);
            }
        }
        for (Diff semanticRequiredBy : semanticDiff.getRequiredBy()) {
            candidates = comparison.getDifferences((EObject)semanticRequiredBy);
            for (DiagramDiff diagramDiff : Iterables.filter((Iterable)candidates, DiagramDiff.class)) {
                if (diagramDiff.getSemanticDiff() != semanticRequiredBy) continue;
                diff.getRequiredBy().add((Object)diagramDiff);
            }
        }
    }

    @Override
    public Match getParentMatch(Diff input) {
        return input.getMatch().getComparison().getMatch((EObject)this.getViewContainer(input));
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind() == DifferenceKind.ADD && input.getValue() instanceof Node && ReferenceUtil.safeEGet((EObject)input.getValue(), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null;
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind() == DifferenceKind.DELETE && input.getValue() instanceof Node && ReferenceUtil.safeEGet((EObject)input.getValue(), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) != null;
    }

    @Override
    protected boolean isRelatedToAnExtensionMove(AttributeChange input) {
        return input.getAttribute().eContainer().equals(NotationPackage.eINSTANCE.getLocation()) && Collections2.filter((Collection)input.getRefines(), NodeChangeFactory.isMoveNodeExtension()).isEmpty() && this.isOverThreshold(input);
    }

    private boolean isOverThreshold(AttributeChange diff) {
        Comparison comparison = diff.getMatch().getComparison();
        EObject left = MatchUtil.getContainer((Comparison)comparison, (Diff)diff);
        EObject right = MatchUtil.getOriginContainer((Comparison)comparison, (Diff)diff);
        if (left instanceof Bounds && right instanceof Bounds) {
            int threshold;
            int deltaY;
            int leftX = ((Bounds)left).getX();
            int leftY = ((Bounds)left).getY();
            int rightX = ((Bounds)right).getX();
            int rightY = ((Bounds)right).getY();
            int deltaX = Math.abs(leftX - rightX);
            return deltaX + (deltaY = Math.abs(leftY - rightY)) > (threshold = this.configuration.getMoveThreshold());
        }
        return false;
    }

    private Diff getSemanticDiff(Diff input) {
        List<Diff> diffs;
        View view;
        Object element;
        if (input instanceof ReferenceChange && ((ReferenceChange)input).getValue() instanceof View && (element = ReferenceUtil.safeEGet((EObject)(view = (View)((ReferenceChange)input).getValue()), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT)) instanceof EObject && (diffs = this.findCrossReferences(input.getMatch().getComparison(), (EObject)element, new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment();
            }
        })).size() > 0) {
            return diffs.get(0);
        }
        return null;
    }

    private static Predicate<? super Diff> isMoveNodeExtension() {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                return input instanceof NodeChange && input.getKind() == DifferenceKind.MOVE;
            }
        };
    }
}

