/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMerger
implements IMerger {
    private int ranking;
    private IMerger.Registry registry;

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public IMerger.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(IMerger.Registry registry) {
        if (this.registry != null && registry != null) {
            throw new IllegalStateException("The registry has to be set only once.");
        }
        this.registry = registry;
    }

    protected void mergeRequiredBy(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequiredBy()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    protected void mergeRequires(Diff diff, boolean rightToLeft, Monitor monitor) {
        for (Diff dependency : diff.getRequires()) {
            this.mergeDiff(dependency, rightToLeft, monitor);
        }
    }

    protected void mergeDiff(Diff diff, boolean rightToLeft, Monitor monitor) {
        if (rightToLeft) {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyRightToLeft(diff, monitor);
        } else {
            IMerger delegate = this.getRegistry().getHighestRankingMerger(diff);
            delegate.copyLeftToRight(diff, monitor);
        }
    }

    protected EObject createCopy(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected <E> void addAt(List<E> list, E value, int insertionIndex) {
        if (list instanceof InternalEList) {
            if (insertionIndex < 0 || insertionIndex > list.size()) {
                ((InternalEList)list).addUnique(value);
            } else {
                ((InternalEList)list).addUnique(insertionIndex, value);
            }
        } else if (insertionIndex < 0 || insertionIndex > list.size()) {
            list.add(value);
        } else {
            list.add(insertionIndex, value);
        }
    }
}

