/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.provider.ConflictItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictItemProviderSpec
extends ConflictItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    public ConflictItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public Collection<?> getChildren(Object object) {
        Conflict conflict = (Conflict)object;
        EList differences = conflict.getDifferences();
        return differences;
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        Conflict conflict = (Conflict)object;
        int size = conflict.getDifferences().size() - 1;
        return new ComposedStyledString(String.valueOf(conflict.getKind().getName()) + " conflict with " + size + " other difference" + (size > 1 ? "s" : ""));
    }

    @Override
    public String getDescription(Object object) {
        Conflict conflict = (Conflict)object;
        int size = conflict.getDifferences().size() - 1;
        String ret = String.valueOf(conflict.getKind().getName()) + " conflict with " + size + " other difference";
        if (size > 1) {
            ret = String.valueOf(ret) + "s";
        }
        return ret;
    }
}

