/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.resource;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.resource.IResourceMatchingStrategy;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameSimilarityMatchingStrategy
implements IResourceMatchingStrategy {
    @Override
    public List<MatchResource> matchResources(Iterable<? extends Resource> left, Iterable<? extends Resource> right, Iterable<? extends Resource> origin) {
        ArrayList mappings = Lists.newArrayList();
        Set<List<? extends Resource>> productLR = NameSimilarityMatchingStrategy.cartesianProductOf(left, right);
        Set<List<? extends Resource>> productLO = NameSimilarityMatchingStrategy.cartesianProductOf(left, origin);
        ArrayList similaritiesLR = Lists.newArrayList();
        ArrayList similaritiesLO = Lists.newArrayList();
        for (List<? extends Resource> couple : productLR) {
            similaritiesLR.add(new ResourceSimilarity(couple.get(0), couple.get(1)));
        }
        for (List<? extends Resource> couple : productLO) {
            similaritiesLO.add(new ResourceSimilarity(couple.get(0), couple.get(1)));
        }
        Collections.sort(similaritiesLR);
        Collections.sort(similaritiesLO);
        double currentSimilarity = 1.0;
        Iterator similaritiesLRIterator = similaritiesLR.iterator();
        while (similaritiesLRIterator.hasNext() && currentSimilarity >= 0.8) {
            ResourceSimilarity sortedCoupleLR = (ResourceSimilarity)similaritiesLRIterator.next();
            Resource leftRes = sortedCoupleLR.getFirst();
            Resource rightRes = sortedCoupleLR.getSecond();
            Resource originRes = null;
            Iterator loIterator = similaritiesLO.iterator();
            while (loIterator.hasNext() && originRes == null) {
                ResourceSimilarity sortedCoupleLO = (ResourceSimilarity)loIterator.next();
                if (sortedCoupleLO.getFirst() != leftRes) continue;
                originRes = sortedCoupleLO.getSecond();
            }
            mappings.add(NameSimilarityMatchingStrategy.createMatchResource(leftRes, rightRes, originRes));
        }
        return mappings;
    }

    private static <T> Set<List<T>> cartesianProductOf(Iterable<? extends T> iterable1, Iterable<? extends T> iterable2) {
        LinkedHashSet set1 = Sets.newLinkedHashSet(iterable1);
        LinkedHashSet set2 = Sets.newLinkedHashSet(iterable2);
        ImmutableList input = ImmutableList.of((Object)set1, (Object)set2);
        return Sets.cartesianProduct((List)input);
    }

    protected static MatchResource createMatchResource(Resource left, Resource right, Resource origin) {
        MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
        match.setLeft(left);
        match.setRight(right);
        match.setOrigin(origin);
        if (left != null && left.getURI() != null) {
            match.setLeftURI(left.getURI().toString());
        }
        if (right != null && right.getURI() != null) {
            match.setRightURI(right.getURI().toString());
        }
        if (origin != null && origin.getURI() != null) {
            match.setOriginURI(origin.getURI().toString());
        }
        return match;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResourceSimilarity
    implements Comparable<ResourceSimilarity> {
        private Resource first;
        private Resource second;

        public ResourceSimilarity(Resource first, Resource second) {
            this.first = first;
            this.second = second;
        }

        public Resource getFirst() {
            return this.first;
        }

        public Resource getSecond() {
            return this.second;
        }

        public double getSimilarity() {
            String firstName = this.first.getURI().lastSegment();
            String secondName = this.second.getURI().lastSegment();
            return DiffUtil.diceCoefficient(firstName, secondName);
        }

        @Override
        public int compareTo(ResourceSimilarity other) {
            return Double.compare(this.getSimilarity(), other.getSimilarity());
        }

        public boolean equals(Object obj) {
            boolean equal = obj == this ? true : (obj instanceof ResourceSimilarity ? this.getFirst().getURI().equals(((ResourceSimilarity)obj).getFirst().getURI()) && this.getSecond().getURI().equals(((ResourceSimilarity)obj).getSecond().getURI()) : false);
            return equal;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getFirst(), this.getSecond()});
        }
    }
}

