/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchEngineFactoryRegistryImpl
implements IMatchEngine.Factory.Registry {
    private final Map<String, IMatchEngine.Factory> map = new ConcurrentHashMap<String, IMatchEngine.Factory>();

    public static IMatchEngine.Factory.Registry createStandaloneInstance() {
        MatchEngineFactoryRegistryImpl registry = new MatchEngineFactoryRegistryImpl();
        MatchEngineFactoryImpl matchEngineFactory = new MatchEngineFactoryImpl(UseIdentifiers.WHEN_AVAILABLE);
        matchEngineFactory.setRanking(10);
        registry.add(matchEngineFactory);
        return registry;
    }

    @Override
    public IMatchEngine.Factory getHighestRankingMatchEngineFactory(IComparisonScope scope) {
        Iterator<IMatchEngine.Factory> matchEngineFactories = this.getMatchEngineFactories(scope).iterator();
        IMatchEngine.Factory ret = null;
        if (matchEngineFactories.hasNext()) {
            IMatchEngine.Factory highestRanking = matchEngineFactories.next();
            while (matchEngineFactories.hasNext()) {
                IMatchEngine.Factory engineFactory = matchEngineFactories.next();
                if (engineFactory.getRanking() <= highestRanking.getRanking()) continue;
                highestRanking = engineFactory;
            }
            ret = highestRanking;
        }
        return ret;
    }

    @Override
    public List<IMatchEngine.Factory> getMatchEngineFactories(IComparisonScope scope) {
        Iterable matchEngineFactories = Iterables.filter(this.map.values(), MatchEngineFactoryRegistryImpl.isMatchEngineFactoryActivable(scope));
        ArrayList ret = Lists.newArrayList();
        for (IMatchEngine.Factory matchEngineFactory : matchEngineFactories) {
            ret.add(matchEngineFactory);
        }
        return ret;
    }

    private static Predicate<IMatchEngine.Factory> isMatchEngineFactoryActivable(final IComparisonScope scope) {
        return new Predicate<IMatchEngine.Factory>(){

            public boolean apply(IMatchEngine.Factory factory) {
                return factory.isMatchEngineFactoryFor(scope);
            }
        };
    }

    @Override
    public IMatchEngine.Factory add(IMatchEngine.Factory filter) {
        Preconditions.checkNotNull((Object)filter);
        return this.map.put(filter.getClass().getName(), filter);
    }

    @Override
    public IMatchEngine.Factory remove(String className) {
        return this.map.remove(className);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

