/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.internal.utils.SyncResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.internal.logical.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.SubscriberStorageAccessor;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.ide.utils.StorageURIConverter;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.team.core.subscribers.Subscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class EMFSynchronizationModel {
    private final StorageTraversal leftTraversal;
    private final StorageTraversal rightTraversal;
    private final StorageTraversal originTraversal;
    private final boolean leftEditable;
    private final boolean rightEditable;

    private EMFSynchronizationModel(StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal, boolean leftEditable, boolean rightEditable) {
        this.leftTraversal = leftTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : leftTraversal;
        this.rightTraversal = rightTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : rightTraversal;
        this.originTraversal = originTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : originTraversal;
        this.leftEditable = leftEditable;
        this.rightEditable = rightEditable;
    }

    public static EMFSynchronizationModel createSynchronizationModel(Subscriber subscriber, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) {
        EMFSynchronizationModel syncModel;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create EMF Synchronization Model", (int)3);
        if (subscriber == null) {
            syncModel = EMFSynchronizationModel.loadSingle(left, right, origin, (IProgressMonitor)progress.newChild(3));
        } else {
            SubscriberStorageAccessor storageAccessor = new SubscriberStorageAccessor(subscriber);
            StorageTraversal leftTraversal = EMFSynchronizationModel.resolveTraversal(storageAccessor, left, IStorageProviderAccessor.DiffSide.SOURCE, (IProgressMonitor)progress.newChild(1));
            StorageTraversal rightTraversal = EMFSynchronizationModel.resolveTraversal(storageAccessor, right, IStorageProviderAccessor.DiffSide.REMOTE, (IProgressMonitor)progress.newChild(1));
            StorageTraversal originTraversal = null;
            if (origin != null) {
                originTraversal = EMFSynchronizationModel.resolveTraversal(storageAccessor, origin, IStorageProviderAccessor.DiffSide.ORIGIN, (IProgressMonitor)progress.newChild(1));
            }
            progress.setWorkRemaining(0);
            syncModel = new EMFSynchronizationModel(leftTraversal, rightTraversal, originTraversal, !left.isReadOnly(), !right.isReadOnly());
        }
        return syncModel;
    }

    private static EMFSynchronizationModel loadSingle(IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StorageTraversal leftTraversal = new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(left)));
        StorageTraversal rightTraversal = new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(right)));
        StorageTraversal originTraversal = origin != null ? new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(origin))) : new StorageTraversal((Set)Sets.newLinkedHashSet());
        subMonitor.worked(100);
        return new EMFSynchronizationModel(leftTraversal, rightTraversal, originTraversal, !left.isReadOnly(), !right.isReadOnly());
    }

    private static EMFSynchronizationModel loadLocal(IResource left, IResource right, IResource origin, IProgressMonitor monitor) {
        StorageTraversal originTraversal;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (origin != null) {
            originTraversal = EMFSynchronizationModel.resolveTraversal(origin, (IProgressMonitor)subMonitor.newChild(1));
        } else {
            subMonitor.setWorkRemaining(2);
            originTraversal = new StorageTraversal((Set)Sets.newLinkedHashSet());
        }
        StorageTraversal leftTraversal = EMFSynchronizationModel.resolveTraversal(left, (IProgressMonitor)subMonitor.newChild(1));
        StorageTraversal rightTraversal = EMFSynchronizationModel.resolveTraversal(right, (IProgressMonitor)subMonitor.newChild(1));
        boolean leftEditable = !left.getResourceAttributes().isReadOnly();
        boolean rightEditable = !right.getResourceAttributes().isReadOnly();
        return new EMFSynchronizationModel(leftTraversal, rightTraversal, originTraversal, leftEditable, rightEditable);
    }

    public static EMFSynchronizationModel createSynchronizationModel(Subscriber subscriber, ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create EMF Synchronization Model", (int)100);
        if (subscriber == null) {
            IResource leftResource = EMFSynchronizationModel.findResource(left);
            IResource rightResource = EMFSynchronizationModel.findResource(right);
            if (leftResource != null && rightResource != null) {
                return EMFSynchronizationModel.loadLocal(leftResource, rightResource, EMFSynchronizationModel.findResource(origin), (IProgressMonitor)progress.newChild(100));
            }
        }
        StreamAccessorStorage leftStorage = StreamAccessorStorage.fromTypedElement(left);
        StreamAccessorStorage rightStorage = StreamAccessorStorage.fromTypedElement(right);
        StreamAccessorStorage originStorage = origin != null ? StreamAccessorStorage.fromTypedElement(origin) : null;
        return EMFSynchronizationModel.createSynchronizationModel(subscriber, leftStorage, rightStorage, originStorage, (IProgressMonitor)progress.newChild(100));
    }

    private static IResource findResource(ITypedElement element) {
        if (element == null) {
            return null;
        }
        IResource resource = EMFSynchronizationModel.adaptAs(element, IResource.class);
        if (resource == null && element instanceof IResourceProvider) {
            resource = ((IResourceProvider)element).getResource();
        }
        return resource;
    }

    private static <T> T adaptAs(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        Object result = null;
        if (clazz.isInstance(object)) {
            result = object;
        } else if (object instanceof IAdaptable) {
            result = ((IAdaptable)object).getAdapter(clazz);
        }
        if (result == null) {
            result = Platform.getAdapterManager().getAdapter(object, clazz);
        }
        return (T)result;
    }

    public IComparisonScope createMinimizedScope(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create minimized scope", (int)100);
        this.minimize((IProgressMonitor)subMonitor.newChild(10));
        return this.createScope((IProgressMonitor)subMonitor.newChild(90));
    }

    public IComparisonScope createScope(IProgressMonitor monitor) {
        NotLoadingResourceSet originResourceSet;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create Scope", (int)3);
        if (this.originTraversal == null || this.originTraversal.getStorages().isEmpty()) {
            originResourceSet = null;
            progress.setWorkRemaining(2);
        } else {
            originResourceSet = NotLoadingResourceSet.create((StorageTraversal)this.originTraversal, (IProgressMonitor)progress.newChild(1));
        }
        NotLoadingResourceSet leftResourceSet = NotLoadingResourceSet.create((StorageTraversal)this.leftTraversal, (IProgressMonitor)progress.newChild(1));
        NotLoadingResourceSet rightResourceSet = NotLoadingResourceSet.create((StorageTraversal)this.rightTraversal, (IProgressMonitor)progress.newChild(1));
        LinkedHashSet urisInScope = Sets.newLinkedHashSet();
        for (IStorage left : this.leftTraversal.getStorages()) {
            urisInScope.add(ResourceUtil.createURIFor((IStorage)left));
        }
        for (IStorage right : this.rightTraversal.getStorages()) {
            urisInScope.add(ResourceUtil.createURIFor((IStorage)right));
        }
        if (this.originTraversal != null) {
            for (IStorage origin : this.originTraversal.getStorages()) {
                urisInScope.add(ResourceUtil.createURIFor((IStorage)origin));
            }
        }
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
        scope.setResourceSetContentFilter(EMFSynchronizationModel.isInScope(urisInScope));
        return scope;
    }

    public void minimize(IProgressMonitor monitor) {
        SubMonitor progess = SubMonitor.convert((IProgressMonitor)monitor, (String)"Minimize synchronization model", (int)100);
        boolean threeWay = !this.originTraversal.getStorages().isEmpty();
        LinkedHashSet leftCopy = Sets.newLinkedHashSet((Iterable)this.leftTraversal.getStorages());
        LinkedHashSet rightCopy = Sets.newLinkedHashSet((Iterable)this.rightTraversal.getStorages());
        LinkedHashSet originCopy = Sets.newLinkedHashSet((Iterable)this.originTraversal.getStorages());
        SubMonitor subMonitor = progess.newChild(98).setWorkRemaining(leftCopy.size());
        for (IStorage left : leftCopy) {
            IStorage right = this.removeLikeNamedStorageFrom(left, rightCopy);
            if (right != null && threeWay) {
                IStorage origin = this.removeLikeNamedStorageFrom(left, originCopy);
                if (origin != null && ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right, (IStorage)origin)) {
                    this.leftTraversal.getStorages().remove(left);
                    this.rightTraversal.getStorages().remove(right);
                    this.originTraversal.getStorages().remove(origin);
                }
            } else if (right != null && ResourceUtil.binaryIdentical((IStorage)left, (IStorage)right)) {
                this.leftTraversal.getStorages().remove(left);
                this.rightTraversal.getStorages().remove(right);
            } else if (right == null && left.isReadOnly()) {
                this.leftTraversal.getStorages().remove(left);
            }
            subMonitor.worked(1);
        }
        subMonitor = progess.newChild(1).setWorkRemaining(rightCopy.size());
        for (IStorage right : rightCopy) {
            if (right.isReadOnly()) {
                this.rightTraversal.getStorages().remove(right);
            }
            subMonitor.worked(1);
        }
        subMonitor = progess.newChild(1).setWorkRemaining(rightCopy.size());
        for (IStorage origin : originCopy) {
            if (origin.isReadOnly()) {
                this.originTraversal.getStorages().remove(origin);
            }
            subMonitor.worked(1);
        }
    }

    private IStorage removeLikeNamedStorageFrom(IStorage reference, Set<IStorage> candidates) {
        String referenceName = reference.getName();
        Iterator<IStorage> candidatesIterator = candidates.iterator();
        while (candidatesIterator.hasNext()) {
            IStorage candidate = candidatesIterator.next();
            String candidateName = candidate.getName();
            if (!referenceName.equals(candidateName)) continue;
            candidatesIterator.remove();
            return candidate;
        }
        return null;
    }

    public boolean isLeftEditable() {
        return this.leftEditable;
    }

    public boolean isRightEditable() {
        return this.rightEditable;
    }

    static StorageTraversal resolveTraversal(IResource start, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!(start instanceof IFile)) {
            subMonitor.setWorkRemaining(0);
            return new StorageTraversal((Set)Sets.newLinkedHashSet());
        }
        SyncResourceSet resourceSet = new SyncResourceSet();
        StorageURIConverter converter = new StorageURIConverter(resourceSet.getURIConverter());
        resourceSet.setURIConverter((URIConverter)converter);
        if (resourceSet.resolveAll((IStorage)((IFile)start), (IProgressMonitor)subMonitor.newChild(95))) {
            LinkedHashSet storages = Sets.newLinkedHashSet((Iterable)Sets.union(Collections.singleton((IFile)start), (Set)converter.getLoadedRevisions()));
            subMonitor.worked(5);
            return new StorageTraversal((Set)storages);
        }
        subMonitor.setWorkRemaining(5);
        subMonitor.worked(5);
        return new StorageTraversal(Collections.singleton((IFile)start));
    }

    private static StorageTraversal resolveTraversal(IStorageProviderAccessor storageAccessor, IStorage start, IStorageProviderAccessor.DiffSide side, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        StorageTraversal traversal = new StorageTraversal((Set)Sets.newLinkedHashSet());
        if (start == null) {
            return traversal;
        }
        SyncResourceSet resourceSet = new SyncResourceSet();
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), storageAccessor, side);
        resourceSet.setURIConverter((URIConverter)converter);
        if (resourceSet.resolveAll(start, (IProgressMonitor)progress.newChild(95))) {
            LinkedHashSet storages = Sets.newLinkedHashSet();
            storages.add(start);
            IPath startPath = start.getFullPath();
            for (IStorage loaded : converter.getLoadedRevisions()) {
                if (startPath.equals((Object)loaded.getFullPath())) continue;
                storages.add(loaded);
            }
            traversal = new StorageTraversal((Set)storages);
        } else {
            progress.setWorkRemaining(5);
        }
        progress.worked(5);
        return traversal;
    }

    private static Predicate<Resource> isInScope(final Set<URI> uris) {
        return new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return input != null && uris.contains(input.getURI());
            }
        };
    }
}

