/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceGroupRegistryImpl
implements IDifferenceGroupProvider.Descriptor.Registry {
    private final Map<String, IDifferenceGroupProvider.Descriptor> map = new ConcurrentHashMap<String, IDifferenceGroupProvider.Descriptor>();

    public List<IDifferenceGroupProvider> getGroupProviders(IComparisonScope scope, Comparison comparison) {
        ArrayList providers = Lists.newArrayList();
        for (IDifferenceGroupProvider.Descriptor desc : this.map.values()) {
            IDifferenceGroupProvider groupProvider = desc.createGroupProvider();
            if (!DifferenceGroupRegistryImpl.isGroupProviderActivable(groupProvider, scope, comparison)) continue;
            providers.add(groupProvider);
        }
        int indexOfDefault = Iterables.indexOf((Iterable)providers, (Predicate)Predicates.instanceOf(DefaultGroupProvider.class));
        if (indexOfDefault >= 0) {
            IDifferenceGroupProvider defaultGroupProvider = (IDifferenceGroupProvider)providers.remove(indexOfDefault);
            providers.add(0, defaultGroupProvider);
        }
        return ImmutableList.copyOf((Collection)providers);
    }

    @Override
    public IDifferenceGroupProvider getDefaultGroupProvider(IComparisonScope scope, Comparison comparison) {
        IDifferenceGroupProvider selectedGroupProvider = null;
        for (IDifferenceGroupProvider dgp : this.getGroupProviders(scope, comparison)) {
            if (!dgp.defaultSelected() || selectedGroupProvider != null && dgp instanceof DefaultGroupProvider) continue;
            selectedGroupProvider = dgp;
        }
        return selectedGroupProvider;
    }

    static final boolean isGroupProviderActivable(IDifferenceGroupProvider dgp, IComparisonScope scope, Comparison comparison) {
        return dgp.isEnabled(scope, comparison);
    }

    @Override
    public IDifferenceGroupProvider.Descriptor add(IDifferenceGroupProvider.Descriptor providerDescriptor, String className) {
        Preconditions.checkNotNull((Object)providerDescriptor);
        return this.map.put(className, providerDescriptor);
    }

    @Override
    public IDifferenceGroupProvider.Descriptor remove(String className) {
        return this.map.remove(className);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

