/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeRunnableImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeAction
extends BaseSelectionListenerAction {
    private static final Function<? super Adapter, ? extends Notifier> ADAPTER__TARGET = new Function<Adapter, Notifier>(){

        public Notifier apply(Adapter adapter) {
            return adapter.getTarget();
        }
    };
    private final IMerger.Registry mergerRegistry;
    private final boolean leftToRight;
    private final IMergeRunnable mergeRunnable;
    private ICompareEditingDomain editingDomain;
    private boolean cascadingDifferencesFilterEnabled;
    private final List<Diff> selectedDifferences;
    private final INavigatable navigatable;

    public MergeAction(ICompareEditingDomain editingDomain, IMerger.Registry mergerRegistry, MergeMode mode, boolean isLeftEditable, boolean isRightEditable, INavigatable navigatable) {
        super("");
        this.navigatable = navigatable;
        Preconditions.checkNotNull((Object)mode);
        Preconditions.checkState((isLeftEditable || isRightEditable ? 1 : 0) != 0);
        if (isLeftEditable && isRightEditable) {
            Preconditions.checkState((mode == MergeMode.LEFT_TO_RIGHT || mode == MergeMode.RIGHT_TO_LEFT ? 1 : 0) != 0);
        }
        if (isLeftEditable != isRightEditable) {
            Preconditions.checkState((mode == MergeMode.ACCEPT || mode == MergeMode.REJECT ? 1 : 0) != 0);
        }
        this.editingDomain = editingDomain;
        this.mergerRegistry = mergerRegistry;
        this.leftToRight = mode.isLeftToRight(isLeftEditable, isRightEditable);
        this.mergeRunnable = this.createMergeRunnable(mode, isLeftEditable, isRightEditable);
        this.selectedDifferences = Lists.newArrayList();
        this.initToolTipAndImage(mode);
    }

    protected IMergeRunnable createMergeRunnable(MergeMode mode, boolean isLeftEditable, boolean isRightEditable) {
        return new MergeRunnableImpl(isLeftEditable, isRightEditable, mode);
    }

    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_to_right.gif"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_to_left.gif"));
                break;
            }
            case ACCEPT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.change.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept_change.gif"));
                break;
            }
            case REJECT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.change.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject_change.gif"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void run() {
        List<Diff> differences = this.getDifferencesToMerge();
        ICompareCopyCommand mergeCommand = this.editingDomain.createCopyCommand(differences, this.leftToRight, this.mergerRegistry, this.mergeRunnable);
        this.editingDomain.getCommandStack().execute((Command)mergeCommand);
        if (this.navigatable != null) {
            this.navigatable.selectChange(1);
        }
    }

    protected List<Diff> getDifferencesToMerge() {
        ArrayList differencesToMerge = Lists.newArrayList(this.selectedDifferences);
        if (this.cascadingDifferencesFilterEnabled) {
            Iterable cascadingDifferences = Iterables.concat((Iterable)Iterables.transform(this.selectedDifferences, (Function)ComparisonUtil.getSubDiffs((boolean)this.leftToRight)));
            Iterables.addAll((Collection)differencesToMerge, (Iterable)cascadingDifferences);
        }
        return differencesToMerge;
    }

    public final void setCascadingDifferencesFilterEnabled(boolean enable) {
        this.cascadingDifferencesFilterEnabled = enable;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Iterables.addAll(this.selectedDifferences, this.getSelectedDifferences(selection));
        return selection.toList().size() == this.selectedDifferences.size();
    }

    protected void clearCache() {
        this.selectedDifferences.clear();
    }

    private Iterable<Diff> getSelectedDifferences(IStructuredSelection selection) {
        List selectedObjects = selection.toList();
        Iterable selectedAdapters = Iterables.filter((Iterable)selectedObjects, Adapter.class);
        Iterable selectedNotifiers = Iterables.transform((Iterable)selectedAdapters, ADAPTER__TARGET);
        Iterable selectedTreeNode = Iterables.filter((Iterable)selectedNotifiers, TreeNode.class);
        Iterable selectedEObjects = Iterables.transform((Iterable)selectedTreeNode, (Function)IDifferenceGroup.TREE_NODE_DATA);
        return Iterables.filter((Iterable)selectedEObjects, Diff.class);
    }

    public final void setEditingDomain(ICompareEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.clearCache();
        this.setEnabled(editingDomain != null && this.updateSelection(this.getStructuredSelection()));
    }

    protected final boolean isLeftToRight() {
        return this.leftToRight;
    }
}

