/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.preferences;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverDescriptor;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.registry.ModelResolverRegistry;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ModelResolutionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_LABEL_VALUE = EMFCompareIDEUIMessages.getString("ModelResolutionPreferencePage.selectedresolver.default.value.label");
    private static final String DEFAULT_DESCRIPTION_VALUE = EMFCompareIDEUIMessages.getString("ModelResolutionPreferencePage.selectedresolver.default.value.description");
    private final ModelResolverRegistry modelResolverRegistry = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry();
    private Button disableModelResolutionButton;
    private ArrayList<Control> activableElements;
    private Combo resolverCombo;
    private ModelResolverDescriptor[] comboValues;
    private Label descriptionLabel;

    protected Control createContents(Composite parent) {
        this.activableElements = Lists.newArrayList();
        Composite mainContainer = new Composite(parent, 0);
        mainContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        mainContainer.setLayout((Layout)new GridLayout(1, false));
        this.createEnablementCheckBox(mainContainer);
        Composite resolutionStrategyComposite = this.createModelResolverComposite(mainContainer);
        this.createCombo(resolutionStrategyComposite);
        this.createDescription(resolutionStrategyComposite);
        this.updateWidgetEnablement();
        return mainContainer;
    }

    private Composite createModelResolverComposite(Composite mainContainer) {
        Composite resolutionStrategyComposite = new Composite(mainContainer, 2048);
        GridLayout groupLayout = new GridLayout(2, false);
        resolutionStrategyComposite.setLayout((Layout)groupLayout);
        resolutionStrategyComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label introductionLabel = new Label(resolutionStrategyComposite, 0);
        GridData introLabelData = new GridData(1, 0x1000000, false, false);
        introLabelData.horizontalSpan = 2;
        introductionLabel.setLayoutData((Object)introLabelData);
        introductionLabel.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencePage.introduction.label"));
        this.activableElements.add((Control)introductionLabel);
        return resolutionStrategyComposite;
    }

    private void updateWidgetEnablement() {
        boolean resolutionEnabled = !this.disableModelResolutionButton.getSelection();
        this.disableModelResolutionButton.setSelection(!resolutionEnabled);
        for (Control controlToDisable : this.activableElements) {
            if (controlToDisable.isDisposed()) continue;
            controlToDisable.setEnabled(resolutionEnabled);
        }
    }

    private void updateDescription(String selectedDescription) {
        if (this.descriptionLabel != null && !this.descriptionLabel.isDisposed()) {
            this.descriptionLabel.setText(selectedDescription);
        }
    }

    private void createDescription(Composite resolutionStrategyComposite) {
        Group descriptionGroup = new Group(resolutionStrategyComposite, 0);
        descriptionGroup.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencePage.description.label"));
        GridData groupLayoutData = new GridData(4, 128, true, false);
        descriptionGroup.setLayoutData((Object)groupLayoutData);
        GridLayout descriptionGroupLayout = new GridLayout(1, false);
        this.activableElements.add((Control)descriptionGroup);
        descriptionGroup.setLayout((Layout)descriptionGroupLayout);
        this.descriptionLabel = new Label((Composite)descriptionGroup, 64);
        GridData descriptionLayoutData = new GridData(4, 128, true, true);
        descriptionLayoutData.minimumHeight = 50;
        descriptionLayoutData.minimumWidth = 500;
        this.descriptionLabel.setLayoutData((Object)descriptionLayoutData);
        this.activableElements.add((Control)this.descriptionLabel);
    }

    private void createEnablementCheckBox(Composite resolutionStrategyComposite) {
        this.disableModelResolutionButton = new Button(resolutionStrategyComposite, 32);
        this.disableModelResolutionButton.setText(EMFCompareIDEUIMessages.getString("ModelResolutionPreferencePage.disable.resolution.checkbox"));
        this.disableModelResolutionButton.setSelection(!this.modelResolverRegistry.isEnabled());
        GridData checkBoxGridData = new GridData(4, 128, true, false);
        this.disableModelResolutionButton.setLayoutData((Object)checkBoxGridData);
        this.disableModelResolutionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelResolutionPreferencePage.this.updateWidgetEnablement();
            }
        });
    }

    private void createCombo(Composite resolutionStrategyComposite) {
        List<ModelResolverDescriptor> resolvers = this.modelResolverRegistry.getRegisteredDescriptors();
        Collections.sort(resolvers, new Comparator<ModelResolverDescriptor>(){

            @Override
            public int compare(ModelResolverDescriptor o1, ModelResolverDescriptor o2) {
                return o2.getRanking() - o1.getRanking();
            }
        });
        String[] comboLabels = new String[resolvers.size() + 1];
        this.comboValues = new ModelResolverDescriptor[resolvers.size() + 1];
        comboLabels[0] = DEFAULT_LABEL_VALUE;
        this.comboValues[0] = null;
        ModelResolverDescriptor selected = this.modelResolverRegistry.getSelectedResolver();
        int initialValueIndex = 0;
        int index = 1;
        while (index <= resolvers.size()) {
            ModelResolverDescriptor descriptor = resolvers.get(index);
            comboLabels[index] = descriptor.getLabel();
            this.comboValues[index] = descriptor;
            if (selected == descriptor) {
                initialValueIndex = index;
            }
            ++index;
        }
        this.resolverCombo = new Combo(resolutionStrategyComposite, 12);
        this.resolverCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.resolverCombo.setItems(comboLabels);
        this.resolverCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelResolverDescriptor selection = ModelResolutionPreferencePage.this.comboValues[ModelResolutionPreferencePage.this.resolverCombo.getSelectionIndex()];
                if (selection == null) {
                    ModelResolutionPreferencePage.this.updateDescription(DEFAULT_DESCRIPTION_VALUE);
                } else {
                    ModelResolutionPreferencePage.this.updateDescription(selection.getDescription());
                }
            }
        });
        this.resolverCombo.select(initialValueIndex);
        ModelResolverDescriptor initialValue = this.comboValues[initialValueIndex];
        if (initialValue == null) {
            this.updateDescription(DEFAULT_DESCRIPTION_VALUE);
        } else {
            this.updateDescription(initialValue.getDescription());
        }
        this.activableElements.add((Control)this.resolverCombo);
    }

    public boolean performOk() {
        boolean resolutionEnabled = !this.disableModelResolutionButton.getSelection();
        this.modelResolverRegistry.toggleEnablement(resolutionEnabled);
        if (resolutionEnabled) {
            ModelResolverDescriptor resolver = this.comboValues[this.resolverCombo.getSelectionIndex()];
            if (resolver == null) {
                this.modelResolverRegistry.setSelectedResolver(null);
            } else {
                this.modelResolverRegistry.setSelectedResolver(resolver.getClassName());
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.resolverCombo.select(0);
        this.disableModelResolutionButton.setSelection(false);
        this.updateDescription(DEFAULT_DESCRIPTION_VALUE);
        this.updateWidgetEnablement();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

