/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.internal.EMFCompareIDEMessages;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class NotLoadingResourceSet
extends ResourceSetImpl {
    public static NotLoadingResourceSet create(StorageTraversal traversals, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.subTask(EMFCompareIDEMessages.getString("NotLoadingResourceSet.monitor.resolve"));
        NotLoadingResourceSet resourceSet = new NotLoadingResourceSet();
        resourceSet.setURIResourceMap(new HashMap(traversals.getStorages().size() << 1));
        SubMonitor subMonitor = progress.newChild(60).setWorkRemaining(traversals.getStorages().size());
        for (IStorage iStorage : traversals.getStorages()) {
            resourceSet.loadResource(iStorage, resourceSet.getLoadOptions());
            subMonitor.worked(1);
        }
        subMonitor = progress.newChild(40).setWorkRemaining(resourceSet.getResources().size());
        ArrayList arrayList = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource res : arrayList) {
            resourceSet.resolve(res);
            subMonitor.worked(1);
        }
        return resourceSet;
    }

    protected void handleDemandLoadException(Resource resource, IOException exception) {
        try {
            super.handleDemandLoadException(resource, exception);
        }
        catch (RuntimeException runtimeException) {}
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        ILoadOnDemandPolicy.Registry registry = EMFCompareRCPPlugin.getDefault().getLoadOnDemandPolicyRegistry();
        if (registry.hasAnyAuthorizingPolicy(uri)) {
            return super.getResource(uri, true);
        }
        return super.getResource(uri, false);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Resource loadResource(IStorage storage, Map<?, ?> options) {
        InputStream stream = null;
        Resource resource = null;
        try {
            resource = this.createResource(ResourceUtil.createURIFor(storage));
            stream = storage.getContents();
            resource.load(stream, options);
        }
        catch (IOException iOException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException2) {}
            return resource;
        }
        catch (CoreException coreException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        catch (WrappedException wrappedException) {
            if (stream == null) return resource;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        if (stream == null) return resource;
        try {
            stream.close();
            return resource;
        }
        catch (IOException iOException) {}
        return resource;
    }

    private void resolve(Resource resource) {
        List roots = ((InternalEList)resource.getContents()).basicList();
        for (EObject eObject : roots) {
            this.resolveCrossReferences(eObject);
            this.resolveChildren(eObject);
        }
        resource.getContents().addAll((Collection)roots);
    }

    private void resolveChildren(EObject eObject) {
        EList list = eObject.eContents();
        ListIterator childContent = ((InternalEList)list).basicListIterator();
        while (childContent.hasNext()) {
            EObject child = (EObject)childContent.next();
            if (child.eIsProxy()) {
                URI proxyURI = ((InternalEObject)child).eProxyURI();
                Resource targetRes = this.getResource(proxyURI.trimFragment(), false);
                if (targetRes != null) {
                    list.get(childContent.previousIndex());
                }
                this.resolveCrossReferences(child);
                continue;
            }
            this.resolveCrossReferences(child);
            this.resolveChildren(child);
        }
    }

    private void resolveCrossReferences(EObject eObject) {
        EList list = eObject.eCrossReferences();
        ListIterator objectChildren = ((InternalEList)list).basicListIterator();
        while (objectChildren.hasNext()) {
            URI proxyURI;
            Resource targetRes;
            EObject eObj = (EObject)objectChildren.next();
            if (!eObj.eIsProxy() || (targetRes = this.getResource((proxyURI = ((InternalEObject)eObj).eProxyURI()).trimFragment(), false)) == null) continue;
            list.get(objectChildren.previousIndex());
        }
    }
}

