/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EmptyComparisonScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.SubscriberStorageAccessor;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComparisonScopeBuilder {
    private final IModelResolver resolver;
    private final IModelMinimizer minimizer;
    private final IStorageProviderAccessor storageAccessor;

    public ComparisonScopeBuilder(IModelResolver resolver, IModelMinimizer minimizer) {
        this(resolver, minimizer, null);
    }

    public ComparisonScopeBuilder(IModelResolver resolver, IModelMinimizer minimizer, IStorageProviderAccessor storageAccessor) {
        this.resolver = (IModelResolver)Preconditions.checkNotNull((Object)resolver);
        this.minimizer = (IModelMinimizer)Preconditions.checkNotNull((Object)minimizer);
        this.storageAccessor = storageAccessor;
    }

    public IComparisonScope build(ITypedElement left, ITypedElement right, IProgressMonitor monitor) {
        return this.build(left, right, null, monitor);
    }

    public IComparisonScope build(ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.subTask(EMFCompareIDEUIMessages.getString("EMFSynchronizationModel.resolving"));
        try {
            SynchronizationModel syncModel = this.storageAccessor != null ? this.createSynchronizationModel(this.storageAccessor, left, right, origin, (IProgressMonitor)subMonitor.newChild(60)) : this.createSynchronizationModel(left, right, origin, (IProgressMonitor)subMonitor.newChild(60));
            if (syncModel.getDiagnostic().getSeverity() >= 4) {
                EmptyComparisonScope emptyComparisonScope = new EmptyComparisonScope();
                emptyComparisonScope.setDiagnostic(syncModel.getDiagnostic());
                return emptyComparisonScope;
            }
            return this.createMinimizedScope(syncModel, (IProgressMonitor)subMonitor.newChild(40));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            EmptyComparisonScope scope = new EmptyComparisonScope();
            scope.setDiagnostic(BasicDiagnostic.toDiagnostic((Throwable)e));
            return scope;
        }
    }

    public static IComparisonScope create(ICompareContainer container, ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        Object leftStorage;
        SubscriberStorageAccessor storageAccessor = null;
        Subscriber subscriber = ComparisonScopeBuilder.getSubscriber(container);
        if (subscriber != null) {
            storageAccessor = new SubscriberStorageAccessor(subscriber);
        }
        if ((leftStorage = PlatformElementUtil.findFile(left)) == null) {
            leftStorage = StreamAccessorStorage.fromTypedElement(left);
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)leftStorage);
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, new IdenticalResourceMinimizer(), storageAccessor);
        return scopeBuilder.build(left, right, origin, monitor);
    }

    private static Subscriber getSubscriber(ICompareContainer container) {
        if (container instanceof ModelCompareEditorInput) {
            ModelCompareEditorInput modelInput = (ModelCompareEditorInput)container;
            ISynchronizeParticipant participant = null;
            try {
                final Field field = ModelCompareEditorInput.class.getDeclaredField("participant");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                participant = (ISynchronizeParticipant)field.get(modelInput);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (participant instanceof ModelSynchronizeParticipant && ((ModelSynchronizeParticipant)participant).getContext() instanceof SubscriberMergeContext) {
                return ((SubscriberMergeContext)((ModelSynchronizeParticipant)participant).getContext()).getSubscriber();
            }
        }
        return null;
    }

    private SynchronizationModel createSynchronizationModel(IStorageProviderAccessor accessor, ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) throws InterruptedException {
        IFile localFile = PlatformElementUtil.findFile(left);
        String path = null;
        if (localFile != null) {
            path = localFile.getFullPath().toString();
        }
        StreamAccessorStorage leftStorage = StreamAccessorStorage.fromTypedElement(path, left);
        StreamAccessorStorage rightStorage = StreamAccessorStorage.fromTypedElement(path, right);
        StreamAccessorStorage originStorage = origin != null ? StreamAccessorStorage.fromTypedElement(path, origin) : null;
        return this.resolver.resolveModels(accessor, leftStorage, rightStorage, originStorage, monitor);
    }

    private SynchronizationModel createSynchronizationModel(ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) throws InterruptedException {
        IFile leftFile = PlatformElementUtil.findFile(left);
        IFile rightFile = PlatformElementUtil.findFile(right);
        if (leftFile != null && rightFile != null) {
            return this.resolver.resolveLocalModels((IResource)leftFile, (IResource)rightFile, (IResource)PlatformElementUtil.findFile(origin), monitor);
        }
        StreamAccessorStorage leftStorage = StreamAccessorStorage.fromTypedElement(left);
        StreamAccessorStorage rightStorage = StreamAccessorStorage.fromTypedElement(right);
        StreamAccessorStorage originStorage = origin != null ? StreamAccessorStorage.fromTypedElement(origin) : null;
        return this.loadSingleResource(leftStorage, rightStorage, originStorage);
    }

    private SynchronizationModel loadSingleResource(IStorage left, IStorage right, IStorage origin) {
        StorageTraversal leftTraversal = new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(left)));
        StorageTraversal rightTraversal = new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(right)));
        StorageTraversal originTraversal = origin != null ? new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(origin))) : new StorageTraversal((Set)Sets.newLinkedHashSet());
        return new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    private IComparisonScope createMinimizedScope(SynchronizationModel syncModel, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.minimizer.minimize(syncModel, (IProgressMonitor)subMonitor.newChild(10));
        return this.createScope(syncModel, (IProgressMonitor)subMonitor.newChild(90));
    }

    private IComparisonScope createScope(SynchronizationModel syncModel, IProgressMonitor monitor) {
        NotLoadingResourceSet originResourceSet;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        progress.subTask(EMFCompareIDEUIMessages.getString("EMFSynchronizationModel.creatingScope"));
        StorageTraversal leftTraversal = syncModel.getLeftTraversal();
        StorageTraversal rightTraversal = syncModel.getRightTraversal();
        StorageTraversal originTraversal = syncModel.getOriginTraversal();
        if (originTraversal == null || originTraversal.getStorages().isEmpty()) {
            originResourceSet = null;
            progress.setWorkRemaining(2);
        } else {
            originResourceSet = NotLoadingResourceSet.create((StorageTraversal)originTraversal, (IProgressMonitor)progress.newChild(1));
        }
        NotLoadingResourceSet leftResourceSet = NotLoadingResourceSet.create((StorageTraversal)leftTraversal, (IProgressMonitor)progress.newChild(1));
        NotLoadingResourceSet rightResourceSet = NotLoadingResourceSet.create((StorageTraversal)rightTraversal, (IProgressMonitor)progress.newChild(1));
        LinkedHashSet urisInScope = Sets.newLinkedHashSet();
        for (IStorage left : leftTraversal.getStorages()) {
            urisInScope.add(ResourceUtil.createURIFor((IStorage)left));
        }
        for (IStorage right : rightTraversal.getStorages()) {
            urisInScope.add(ResourceUtil.createURIFor((IStorage)right));
        }
        if (originTraversal != null) {
            for (IStorage origin : originTraversal.getStorages()) {
                urisInScope.add(ResourceUtil.createURIFor((IStorage)origin));
            }
        }
        BasicDiagnostic originDiagnostic = originResourceSet != null ? this.getResourceSetDiagnostic((ResourceSet)originResourceSet, null, true) : null;
        BasicDiagnostic leftDiagnostic = this.getResourceSetDiagnostic((ResourceSet)leftResourceSet, DifferenceSource.LEFT, true);
        BasicDiagnostic rightDiagnostic = this.getResourceSetDiagnostic((ResourceSet)rightResourceSet, DifferenceSource.RIGHT, true);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
        scope.setResourceSetContentFilter(ComparisonScopeBuilder.isInScope(urisInScope));
        BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
        scope.setDiagnostic((Diagnostic)diagnostic);
        if (originDiagnostic != null && originDiagnostic.getSeverity() >= 2) {
            diagnostic.add((Diagnostic)originDiagnostic);
        }
        if (leftDiagnostic.getSeverity() >= 2) {
            diagnostic.add((Diagnostic)leftDiagnostic);
        }
        if (rightDiagnostic.getSeverity() >= 2) {
            diagnostic.add((Diagnostic)rightDiagnostic);
        }
        return scope;
    }

    private BasicDiagnostic getResourceSetDiagnostic(ResourceSet resourceSet, DifferenceSource side, boolean includeWarning) {
        String sideStr = side == DifferenceSource.LEFT ? EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.left") : (side == DifferenceSource.RIGHT ? EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.right") : EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.ancesotr"));
        BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.resourceSetDiagnostic", sideStr), new Object[0]);
        for (Resource resource : resourceSet.getResources()) {
            Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)includeWarning);
            if (resourceDiagnostic.getSeverity() < 2) continue;
            diagnostic.merge(resourceDiagnostic);
        }
        return diagnostic;
    }

    private static Predicate<Resource> isInScope(final Set<URI> uris) {
        return new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return input != null && uris.contains(input.getURI());
            }
        };
    }
}

