/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.provider.decorator;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.provider.ExtendedItemProviderDecorator;
import org.eclipse.emf.compare.uml2.internal.provider.UMLCompareEditPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Image;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StereotypedElementItemProviderDecorator
extends ExtendedItemProviderDecorator
implements IEditingDomainItemProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider,
IItemFontProvider {
    public StereotypedElementItemProviderDecorator(ComposeableAdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        Element elem;
        EList appliedStereotypes;
        if (object instanceof Element && !(appliedStereotypes = (elem = (Element)object).getAppliedStereotypes()).isEmpty()) {
            return this.getStereotypedElementLabel((Element)object, (EList<Stereotype>)appliedStereotypes);
        }
        return super.getText(object);
    }

    private String getStereotypedElementLabel(Element element, EList<Stereotype> appliedStereotypes) {
        StringBuilder labelBuilder = new StringBuilder();
        String stereotypes = Joiner.on((char)',').join(Iterables.transform(appliedStereotypes, (Function)new Function<Stereotype, String>(){

            public String apply(Stereotype input) {
                return input.getName();
            }
        }));
        labelBuilder.append('<').append(stereotypes).append("> ");
        if (element instanceof NamedElement) {
            NamedElement namedElement = (NamedElement)element;
            labelBuilder.append(namedElement.getName());
        }
        return labelBuilder.toString();
    }

    public Object getImage(Object object) {
        if (object instanceof Element && !((Element)object).getAppliedStereotypes().isEmpty()) {
            return new ComposedImage(this.getStereotypeIcons((Element)object, super.getImage(object)));
        }
        return super.getImage(object);
    }

    protected List<Object> getStereotypeIcons(Element element, Object baseElementIcon) {
        List<Object> images = null;
        Iterator stereotypeIterator = element.getAppliedStereotypes().iterator();
        while (stereotypeIterator.hasNext() && images == null) {
            Stereotype appliedStereotype = (Stereotype)stereotypeIterator.next();
            if (!appliedStereotype.getIcons().isEmpty()) {
                images = this.getStereotypeIconsFromProfile(appliedStereotype);
                continue;
            }
            Object img = this.getStereotypeIconFromItemProvider(appliedStereotype, element);
            if (img == null) continue;
            images = Collections.singletonList(img);
        }
        if (images == null) {
            images = Collections.singletonList(baseElementIcon);
        }
        return images;
    }

    private Object getStereotypeIconFromItemProvider(Stereotype appliedStereotype, Element element) {
        EObject steretotypeApplication = element.getStereotypeApplication(appliedStereotype);
        return this.getStereotypeIconFromItemProvider(steretotypeApplication);
    }

    private List<Object> getStereotypeIconsFromProfile(Stereotype appliedStereotype) {
        ArrayList<Object> images = new ArrayList<Object>();
        for (Image icon : appliedStereotype.getIcons()) {
            Object img;
            String location = icon.getLocation();
            if (UML2Util.isEmpty((String)location) || (img = this.getIconFromLocation(icon.eResource(), location)) == null) continue;
            images.add(img);
        }
        if (images.isEmpty()) {
            images = null;
        }
        return images;
    }

    private Object getIconFromLocation(Resource eResource, String location) {
        ResourceSet resourceSet;
        URL img = null;
        if (eResource != null && (resourceSet = eResource.getResourceSet()) != null) {
            URIConverter uriConverter = resourceSet.getURIConverter();
            URI normalizedURI = uriConverter.normalize(eResource.getURI());
            URI uri = URI.createURI((String)location).resolve(normalizedURI);
            try {
                URL url = new URL(uriConverter.normalize(uri).toString());
                url.openStream().close();
                img = url;
            }
            catch (MalformedURLException e) {
                UMLCompareEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.uml2.edit", UMLCompareEditPlugin.INSTANCE.getString("Unable_To_Retreive_Icon_Error_Message", new Object[]{location}), (Throwable)e));
            }
            catch (IOException e) {
                UMLCompareEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.uml2.edit", UMLCompareEditPlugin.INSTANCE.getString("Unable_To_Retreive_Icon_Error_Message", new Object[]{location}), (Throwable)e));
            }
        }
        return img;
    }

    public Object getStereotypeIconFromItemProvider(Object object) {
        IChangeNotifier cNotifier;
        ComposeableAdapterFactory rootAdapterFactory = ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)rootAdapterFactory.adapt(object, IItemLabelProvider.class);
        if (itemLabelProvider instanceof IItemProviderDecorator && (cNotifier = ((IItemProviderDecorator)itemLabelProvider).getDecoratedItemProvider()) instanceof IItemLabelProvider) {
            itemLabelProvider = (IItemLabelProvider)cNotifier;
        }
        if (itemLabelProvider == null || itemLabelProvider instanceof ReflectiveItemProvider) {
            return null;
        }
        return itemLabelProvider.getImage(object);
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

