/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.DifferenceFilterChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.GroupItemProviderAdapter;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMergeViewerFilter
extends ViewerFilter {
    public static final Predicate<? super EObject> DEFAULT_PREDICATE = Predicates.alwaysFalse();
    private final Set<Predicate<? super EObject>> predicates;
    private final Set<IDifferenceFilter> selectedDifferenceFilters;
    private final Set<IDifferenceFilter> unselectedDifferenceFilters;
    private final EventBus eventBus;
    private final Predicate<? super EObject> viewerPredicate = new Predicate<EObject>(){

        public boolean apply(EObject eObject) {
            EObject data;
            EList eContents;
            boolean ret = StructureMergeViewerFilter.this.aggregatedPredicate.apply((Object)eObject) ? (!(eContents = eObject.eContents()).isEmpty() && eObject instanceof TreeNode ? ((data = ((TreeNode)eObject).getData()) instanceof Match || data instanceof Conflict || data instanceof MatchResource ? Iterables.any((Iterable)eContents, (Predicate)StructureMergeViewerFilter.this.viewerPredicate) : true) : true) : false;
            return ret;
        }
    };
    private Predicate<? super EObject> aggregatedPredicate;

    public StructureMergeViewerFilter(EventBus eventBus) {
        this.eventBus = eventBus;
        this.predicates = Sets.newLinkedHashSet();
        this.selectedDifferenceFilters = Sets.newLinkedHashSet();
        this.unselectedDifferenceFilters = Sets.newLinkedHashSet();
        this.aggregatedPredicate = DEFAULT_PREDICATE;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean result;
        if (this.predicates.isEmpty()) {
            return true;
        }
        if (element instanceof GroupItemProviderAdapter) {
            Collection<?> children = ((GroupItemProviderAdapter)((Object)element)).getChildren(element);
            result = Iterables.any((Iterable)Iterables.filter(children, EObject.class), this.viewerPredicate);
        } else if (element instanceof PendingUpdateAdapter) {
            result = true;
        } else if (element instanceof Adapter) {
            Notifier notifier = ((Adapter)element).getTarget();
            if (notifier instanceof EObject) {
                EObject eObject = (EObject)notifier;
                result = this.viewerPredicate.apply((Object)eObject);
            } else {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public void addFilter(IDifferenceFilter filter) {
        boolean changed = this.predicates.remove(filter.getPredicateWhenUnselected());
        changed |= this.predicates.add(filter.getPredicateWhenSelected());
        changed |= this.selectedDifferenceFilters.add(filter);
        if (changed |= this.unselectedDifferenceFilters.remove(filter)) {
            this.aggregatedPredicate = this.computeAggregatedPredicate();
            this.eventBus.post((Object)new DifferenceFilterChange(this.aggregatedPredicate, this.selectedDifferenceFilters, this.unselectedDifferenceFilters));
        }
    }

    private Predicate<? super EObject> computeAggregatedPredicate() {
        return Predicates.not((Predicate)Predicates.or(this.predicates));
    }

    public void removeFilter(IDifferenceFilter filter) {
        boolean changed = this.predicates.add(filter.getPredicateWhenUnselected());
        changed |= this.predicates.remove(filter.getPredicateWhenSelected());
        changed |= this.unselectedDifferenceFilters.add(filter);
        if (changed |= this.selectedDifferenceFilters.remove(filter)) {
            this.aggregatedPredicate = this.computeAggregatedPredicate();
            this.eventBus.post((Object)new DifferenceFilterChange(this.aggregatedPredicate, this.selectedDifferenceFilters, this.unselectedDifferenceFilters));
        }
    }

    public void init(Collection<IDifferenceFilter> selectedFilters, Collection<IDifferenceFilter> unselectedFilters) {
        boolean changed = false;
        if (!this.predicates.isEmpty()) {
            this.predicates.clear();
            changed = true;
        }
        for (IDifferenceFilter filter : selectedFilters) {
            changed |= this.predicates.add(filter.getPredicateWhenSelected());
            changed |= this.selectedDifferenceFilters.add(filter);
        }
        for (IDifferenceFilter filter : unselectedFilters) {
            changed |= this.predicates.add(filter.getPredicateWhenUnselected());
            changed |= this.unselectedDifferenceFilters.add(filter);
        }
        if (changed) {
            this.aggregatedPredicate = this.computeAggregatedPredicate();
            this.eventBus.post((Object)new DifferenceFilterChange(this.aggregatedPredicate, this.selectedDifferenceFilters, this.unselectedDifferenceFilters));
        }
    }

    public Set<IDifferenceFilter> getSelectedDifferenceFilters() {
        return this.selectedDifferenceFilters;
    }

    public Set<IDifferenceFilter> getUnSelectedDifferenceFilters() {
        return ImmutableSet.copyOf(this.unselectedDifferenceFilters);
    }

    public Predicate<? super EObject> getAggregatedPredicate() {
        return this.aggregatedPredicate;
    }
}

