/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Preconditions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.RemoteMappingStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;

public class RemoteMappingContextStorageAccessor
implements IStorageProviderAccessor {
    private final RemoteResourceMappingContext context;

    public RemoteMappingContextStorageAccessor(RemoteResourceMappingContext context) {
        this.context = (RemoteResourceMappingContext)Preconditions.checkNotNull((Object)context);
    }

    public IStorageProvider getStorageProvider(IResource resource, IStorageProviderAccessor.DiffSide side) throws CoreException {
        if (resource instanceof IFile) {
            return new RemoteMappingStorageProvider(this.context, side, (IFile)resource);
        }
        return null;
    }

    public boolean isInSync(IResource resource) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        return this.context.hasLocalChange(resource, (IProgressMonitor)monitor) || this.context.hasRemoteChange(resource, (IProgressMonitor)monitor);
    }
}

