/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.internal.merge.IMergeData;
import org.eclipse.emf.compare.internal.merge.MergeDataImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeRunnableImpl
implements IMergeRunnable {
    private final boolean isLeftEditable;
    private final boolean isRightEditable;
    private final MergeMode mergeMode;

    public MergeRunnableImpl(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode) {
        this.isLeftEditable = isLeftEditable;
        this.isRightEditable = isRightEditable;
        this.mergeMode = mergeMode;
    }

    public void merge(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Preconditions.checkState((this.mergeMode.isLeftToRight(this.isLeftEditable, this.isRightEditable) == leftToRight ? 1 : 0) != 0);
        if (this.mergeMode == MergeMode.LEFT_TO_RIGHT || this.mergeMode == MergeMode.RIGHT_TO_LEFT) {
            this.mergeAll(differences, leftToRight, mergerRegistry);
        } else if (this.mergeMode == MergeMode.ACCEPT || this.mergeMode == MergeMode.REJECT) {
            ArrayList diffToMarkAsMerged = Lists.newArrayList();
            ArrayList diffToCopyFromLeftToRight = Lists.newArrayList();
            ArrayList diffToCopyFromRightToLeft = Lists.newArrayList();
            for (Diff diff : differences) {
                MergeOperation mergeAction = this.mergeMode.getMergeAction(diff, this.isLeftEditable, this.isRightEditable);
                if (mergeAction == MergeOperation.MARK_AS_MERGE) {
                    diffToMarkAsMerged.add(diff);
                    continue;
                }
                if (this.isLeftEditable && leftToRight) {
                    diffToCopyFromRightToLeft.add(diff);
                    continue;
                }
                diffToCopyFromLeftToRight.add(diff);
            }
            this.mergeAll(diffToCopyFromLeftToRight, leftToRight, mergerRegistry);
            this.mergeAll(diffToCopyFromRightToLeft, !leftToRight, mergerRegistry);
            this.markAllAsMerged(diffToMarkAsMerged, this.mergeMode, mergerRegistry);
        } else {
            throw new IllegalStateException();
        }
    }

    private void markAllAsMerged(Collection<Diff> diffToMarkAsMerged, MergeMode mode, IMerger.Registry mergerRegistry) {
        for (Diff diff : diffToMarkAsMerged) {
            boolean isLeftToRight = mode.isLeftToRight(diff, this.isLeftEditable, this.isRightEditable);
            this.markAsMerged(diff, mode, isLeftToRight, mergerRegistry);
        }
    }

    private void markAsMerged(Diff diff, MergeMode mode, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Set rejections;
        Set implied;
        if (diff.getState() == DifferenceState.MERGED) {
            return;
        }
        IMerger diffMerger = mergerRegistry.getHighestRankingMerger(diff);
        if (diffMerger instanceof IMerger2) {
            implied = ((IMerger2)diffMerger).getResultingMerges(diff, leftToRight, Collections.emptySet());
            rejections = ((IMerger2)diffMerger).getResultingRejections(diff, leftToRight, Collections.emptySet());
        } else {
            implied = Collections.singleton(diff);
            rejections = Collections.emptySet();
        }
        for (Diff req : implied) {
            req.setState(DifferenceState.MERGED);
            this.addOrUpdateMergeData(req, mode);
        }
        for (Diff rejected : rejections) {
            rejected.setState(DifferenceState.MERGED);
            if (this.mergeMode == MergeMode.LEFT_TO_RIGHT || this.mergeMode == MergeMode.RIGHT_TO_LEFT) {
                this.addOrUpdateMergeData(rejected, mode);
                continue;
            }
            this.addOrUpdateMergeData(rejected, mode.inverse());
        }
    }

    private void addOrUpdateMergeData(Collection<Diff> differences, MergeMode mode) {
        for (Diff difference : differences) {
            this.addOrUpdateMergeData(difference, mode);
        }
    }

    private void addOrUpdateMergeData(Diff diff, MergeMode mode) {
        IMergeData mergeData = (IMergeData)EcoreUtil.getExistingAdapter((Notifier)diff, IMergeData.class);
        if (mergeData != null) {
            mergeData.setMergeMode(mode);
            mergeData.setLeftEditable(this.isLeftEditable);
            mergeData.setRightEditable(this.isRightEditable);
        } else {
            mergeData = new MergeDataImpl(mode, this.isLeftEditable, this.isRightEditable);
            diff.eAdapters().add((Object)mergeData);
        }
    }

    private void mergeAll(Collection<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        BatchMerger merger = new BatchMerger(mergerRegistry);
        if (leftToRight) {
            merger.copyAllLeftToRight(differences, (Monitor)new BasicMonitor());
        } else {
            merger.copyAllRightToLeft(differences, (Monitor)new BasicMonitor());
        }
        for (Diff diff : differences) {
            IMerger diffMerger = mergerRegistry.getHighestRankingMerger(diff);
            if (diffMerger instanceof IMerger2) {
                this.addOrUpdateMergeData(((IMerger2)diffMerger).getResultingMerges(diff, leftToRight, Collections.emptySet()), this.mergeMode);
                if (this.mergeMode == MergeMode.LEFT_TO_RIGHT || this.mergeMode == MergeMode.RIGHT_TO_LEFT) {
                    this.addOrUpdateMergeData(((IMerger2)diffMerger).getResultingRejections(diff, leftToRight, Collections.emptySet()), this.mergeMode);
                    continue;
                }
                this.addOrUpdateMergeData(((IMerger2)diffMerger).getResultingRejections(diff, leftToRight, Collections.emptySet()), this.mergeMode.inverse());
                continue;
            }
            this.addOrUpdateMergeData(Collections.singleton(diff), this.mergeMode);
        }
    }
}

