/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChangeMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        return target instanceof ReferenceChange;
    }

    @Override
    protected void reject(Diff diff, boolean rightToLeft) {
        ReferenceChange referenceChange = (ReferenceChange)diff;
        DifferenceSource source = referenceChange.getSource();
        switch (referenceChange.getKind()) {
            case ADD: {
                this.removeFromTarget(referenceChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.addInTarget(referenceChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(referenceChange, rightToLeft);
                break;
            }
            case CHANGE: {
                EObject container = null;
                container = source == DifferenceSource.LEFT ? referenceChange.getMatch().getLeft() : referenceChange.getMatch().getRight();
                if (container != null) {
                    EObject leftValue = (EObject)ReferenceUtil.safeEGet(container, (EStructuralFeature)referenceChange.getReference());
                    if (leftValue == null) {
                        this.addInTarget(referenceChange, rightToLeft);
                        break;
                    }
                    this.resetInTarget(referenceChange, rightToLeft);
                    break;
                }
                this.addInTarget(referenceChange, rightToLeft);
                break;
            }
        }
    }

    @Override
    protected void accept(Diff diff, boolean rightToLeft) {
        ReferenceChange referenceChange = (ReferenceChange)diff;
        DifferenceSource source = diff.getSource();
        switch (diff.getKind()) {
            case ADD: {
                this.addInTarget(referenceChange, rightToLeft);
                break;
            }
            case DELETE: {
                this.removeFromTarget(referenceChange, rightToLeft);
                break;
            }
            case MOVE: {
                this.moveElement(referenceChange, rightToLeft);
                break;
            }
            case CHANGE: {
                EObject container = null;
                container = source == DifferenceSource.LEFT ? referenceChange.getMatch().getLeft() : referenceChange.getMatch().getRight();
                if (container != null) {
                    EObject leftValue = (EObject)ReferenceUtil.safeEGet(container, (EStructuralFeature)referenceChange.getReference());
                    if (leftValue == null) {
                        this.removeFromTarget(referenceChange, rightToLeft);
                        break;
                    }
                    this.addInTarget(referenceChange, rightToLeft);
                    break;
                }
                this.removeFromTarget(referenceChange, rightToLeft);
                break;
            }
        }
    }

    protected void moveElement(ReferenceChange diff, boolean rightToLeft) {
        EObject expectedValue;
        EObject expectedContainer;
        Comparison comparison = diff.getMatch().getComparison();
        Match valueMatch = comparison.getMatch(diff.getValue());
        EReference reference = diff.getReference();
        if (reference.isContainment()) {
            Match targetContainerMatch = rightToLeft && valueMatch.getRight() != null ? comparison.getMatch(valueMatch.getRight().eContainer()) : (!rightToLeft && valueMatch.getLeft() != null ? comparison.getMatch(valueMatch.getLeft().eContainer()) : comparison.getMatch(valueMatch.getOrigin().eContainer()));
            expectedContainer = rightToLeft ? targetContainerMatch.getLeft() : targetContainerMatch.getRight();
        } else {
            expectedContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        }
        if (expectedContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (reference.isMany()) {
                List targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)reference);
                expectedValue = this.findMatchIn(comparison, targetList, diff.getValue());
            } else {
                expectedValue = (EObject)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)reference);
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        if (expectedValue == null) {
            this.addInTarget(diff, rightToLeft);
        } else {
            this.doMove(diff, comparison, expectedContainer, expectedValue, rightToLeft);
        }
    }

    protected void doMove(ReferenceChange diff, Comparison comparison, EObject expectedContainer, EObject expectedValue, boolean rightToLeft) {
        EReference reference = this.getMoveTargetReference(comparison, diff, rightToLeft);
        if (reference.isMany()) {
            List targetList;
            int currentIndex;
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            if (insertionIndex > (currentIndex = (targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)reference)).indexOf(expectedValue)) && currentIndex >= 0) {
                --insertionIndex;
            }
            if (currentIndex == -1) {
                if (!reference.isContainment()) {
                    targetList.remove(expectedValue);
                }
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    targetList.add(expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            } else if (targetList instanceof EList) {
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    ((EList)targetList).move(targetList.size() - 1, (Object)expectedValue);
                } else {
                    ((EList)targetList).move(insertionIndex, (Object)expectedValue);
                }
            } else {
                targetList.remove(expectedValue);
                if (insertionIndex < 0 || insertionIndex > targetList.size()) {
                    targetList.add(expectedValue);
                } else {
                    targetList.add(insertionIndex, expectedValue);
                }
            }
        } else {
            ReferenceUtil.safeESet(expectedContainer, (EStructuralFeature)reference, expectedValue);
        }
    }

    private EReference getMoveTargetReference(Comparison comparison, ReferenceChange diff, boolean rightToLeft) {
        EReference reference;
        DifferenceSource source = diff.getSource();
        Match valueMatch = comparison.getMatch(diff.getValue());
        if (!diff.getReference().isContainment() || valueMatch == null) {
            reference = diff.getReference();
        } else if (rightToLeft && source == DifferenceSource.LEFT) {
            EStructuralFeature feature;
            EObject sourceValue = valueMatch.getRight();
            if (sourceValue == null) {
                sourceValue = valueMatch.getOrigin();
            }
            reference = (feature = sourceValue.eContainingFeature()) instanceof EReference ? (EReference)feature : diff.getReference();
        } else if (!rightToLeft && source == DifferenceSource.RIGHT) {
            EStructuralFeature feature;
            EObject sourceValue = valueMatch.getLeft();
            if (sourceValue == null) {
                sourceValue = valueMatch.getOrigin();
            }
            reference = (feature = sourceValue.eContainingFeature()) instanceof EReference ? (EReference)feature : diff.getReference();
        } else {
            reference = diff.getReference();
        }
        return reference;
    }

    protected void addInTarget(ReferenceChange diff, boolean rightToLeft) {
        EObject expectedValue;
        Match match = diff.getMatch();
        EObject expectedContainer = rightToLeft ? match.getLeft() : match.getRight();
        if (expectedContainer == null) {
            return;
        }
        Comparison comparison = match.getComparison();
        EReference reference = diff.getReference();
        Match valueMatch = comparison.getMatch(diff.getValue());
        if (valueMatch == null) {
            expectedValue = diff.getValue().eIsProxy() ? EcoreUtil.copy((EObject)diff.getValue()) : diff.getValue();
        } else if (rightToLeft) {
            if (reference.isContainment()) {
                expectedValue = this.createCopy(diff.getValue());
                valueMatch.setLeft(expectedValue);
            } else {
                expectedValue = valueMatch.getLeft();
            }
        } else if (reference.isContainment()) {
            expectedValue = this.createCopy(diff.getValue());
            valueMatch.setRight(expectedValue);
        } else {
            expectedValue = valueMatch.getRight();
        }
        if (reference.isMany()) {
            int insertionIndex = this.findInsertionIndex(comparison, diff, rightToLeft);
            List targetList = (List)ReferenceUtil.safeEGet(expectedContainer, (EStructuralFeature)reference);
            this.addAt(targetList, expectedValue, insertionIndex);
        } else {
            ReferenceUtil.safeESet(expectedContainer, (EStructuralFeature)reference, expectedValue);
        }
        if (reference.isContainment()) {
            Resource initialResource = diff.getValue().eResource();
            Resource targetResource = expectedValue.eResource();
            if (initialResource instanceof XMIResource && targetResource instanceof XMIResource) {
                ((XMIResource)targetResource).setID(expectedValue, ((XMIResource)initialResource).getID(diff.getValue()));
            }
        }
        this.checkImpliedDiffsOrdering(diff, rightToLeft);
    }

    protected void removeFromTarget(ReferenceChange diff, boolean rightToLeft) {
        EObject expectedValue;
        List targetList;
        Match match = diff.getMatch();
        EReference reference = diff.getReference();
        EObject currentContainer = rightToLeft ? match.getLeft() : match.getRight();
        Comparison comparison = match.getComparison();
        Match valueMatch = comparison.getMatch(diff.getValue());
        if (currentContainer == null) {
            return;
        }
        if (valueMatch == null) {
            if (reference.isMany()) {
                targetList = (List)ReferenceUtil.safeEGet(currentContainer, (EStructuralFeature)reference);
                expectedValue = this.findMatchIn(comparison, targetList, diff.getValue());
            } else {
                expectedValue = null;
            }
        } else {
            expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        }
        if (reference.isContainment() && expectedValue != null) {
            EcoreUtil.remove((EObject)expectedValue);
            if (rightToLeft && valueMatch != null) {
                valueMatch.setLeft(null);
            } else if (valueMatch != null) {
                valueMatch.setRight(null);
            }
        } else if (reference.isMany()) {
            targetList = (List)ReferenceUtil.safeEGet(currentContainer, (EStructuralFeature)reference);
            targetList.remove(expectedValue);
        } else {
            currentContainer.eUnset((EStructuralFeature)reference);
        }
    }

    protected void resetInTarget(ReferenceChange diff, boolean rightToLeft) {
        Match match = diff.getMatch();
        EReference reference = diff.getReference();
        EObject targetContainer = rightToLeft ? match.getLeft() : match.getRight();
        EObject originContainer = match.getComparison().isThreeWay() ? match.getOrigin() : (rightToLeft ? match.getRight() : match.getLeft());
        if (originContainer == null || !ReferenceUtil.safeEIsSet(targetContainer, (EStructuralFeature)reference) || !ReferenceUtil.safeEIsSet(originContainer, (EStructuralFeature)reference)) {
            targetContainer.eUnset((EStructuralFeature)reference);
        } else {
            EObject originalValue = (EObject)ReferenceUtil.safeEGet(originContainer, (EStructuralFeature)reference);
            Match valueMatch = match.getComparison().getMatch(originalValue);
            EObject expectedValue = valueMatch == null ? originalValue : (rightToLeft ? valueMatch.getLeft() : valueMatch.getRight());
            ReferenceUtil.safeESet(targetContainer, (EStructuralFeature)reference, expectedValue);
        }
    }

    protected void checkImpliedDiffsOrdering(ReferenceChange diff, boolean rightToLeft) {
        EReference reference = diff.getReference();
        EList<Diff> mergedImplications = rightToLeft ? (diff.getSource() == DifferenceSource.LEFT ? diff.getImpliedBy() : diff.getImplies()) : (diff.getSource() == DifferenceSource.LEFT ? diff.getImplies() : diff.getImpliedBy());
        Iterator impliedDiffs = mergedImplications.iterator();
        if (reference.isMany() && diff.getEquivalence() != null) {
            impliedDiffs = Iterators.concat(impliedDiffs, (Iterator)diff.getEquivalence().getDifferences().iterator());
        }
        UnmodifiableIterator impliedReferenceChanges = Iterators.filter(impliedDiffs, ReferenceChange.class);
        while (impliedReferenceChanges.hasNext()) {
            ReferenceChange implied = (ReferenceChange)impliedReferenceChanges.next();
            if (implied == diff || implied.getState() != DifferenceState.MERGED || !implied.getReference().isMany() || !this.isAdd(implied, rightToLeft)) continue;
            this.internalCheckOrdering(implied, rightToLeft);
        }
    }

    private void internalCheckOrdering(ReferenceChange diff, boolean rightToLeft) {
        EObject newValue;
        EObject targetContainer;
        EObject sourceContainer;
        EReference feature = diff.getReference();
        EObject value = diff.getValue();
        Match match = diff.getMatch();
        Comparison comparison = match.getComparison();
        Match valueMatch = comparison.getMatch(value);
        if (rightToLeft) {
            sourceContainer = match.getRight();
            targetContainer = match.getLeft();
            newValue = valueMatch.getLeft();
        } else {
            sourceContainer = match.getLeft();
            targetContainer = match.getRight();
            newValue = valueMatch.getRight();
        }
        List<Object> sourceList = ReferenceUtil.getAsList(sourceContainer, (EStructuralFeature)feature);
        List<Object> targetList = ReferenceUtil.getAsList(targetContainer, (EStructuralFeature)feature);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(comparison, sourceList, targetList);
        if (lcs.contains(valueMatch.getLeft()) || lcs.contains(valueMatch.getRight())) {
            return;
        }
        int insertionIndex = DiffUtil.findInsertionIndex(comparison, sourceList, targetList, value);
        if (insertionIndex >= 0) {
            List changedList = (List)ReferenceUtil.safeEGet(targetContainer, (EStructuralFeature)feature);
            if (changedList instanceof EList) {
                if (insertionIndex > changedList.size()) {
                    ((EList)changedList).move(changedList.size() - 1, (Object)newValue);
                } else {
                    ((EList)changedList).move(insertionIndex, (Object)newValue);
                }
            } else {
                changedList.remove(newValue);
                if (insertionIndex > changedList.size()) {
                    changedList.add(newValue);
                } else {
                    changedList.add(insertionIndex, newValue);
                }
            }
        }
    }

    protected EObject findMatchIn(Comparison comparison, List<EObject> list, EObject element) {
        IEqualityHelper helper = comparison.getEqualityHelper();
        for (EObject next : list) {
            if (!helper.matchingValues(next, element)) continue;
            return next;
        }
        return null;
    }

    protected int findInsertionIndex(Comparison comparison, Diff diff, boolean rightToLeft) {
        return DiffUtil.findInsertionIndex(comparison, diff, rightToLeft);
    }
}

