/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider2;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareStructureMergeViewerContentProvider
extends AdapterFactoryContentProvider
implements IJobChangeListener {
    private final DeferredTreeContentManager contenManagerAdapter;
    private boolean isFetchingGroup;
    private final ReentrantLock lock;
    private final List<FetchListener> listeners;
    private List<CallbackHolder> callbacks;
    private Object[] pending;

    public EMFCompareStructureMergeViewerContentProvider(AdapterFactory adapterFactory, AbstractTreeViewer viewer) {
        super(adapterFactory);
        this.contenManagerAdapter = new DeferredTreeContentManager(viewer);
        this.contenManagerAdapter.addUpdateCompleteListener((IJobChangeListener)this);
        this.lock = new ReentrantLock();
        this.listeners = new CopyOnWriteArrayList<FetchListener>();
        this.callbacks = new CopyOnWriteArrayList<CallbackHolder>();
    }

    public Object getParent(Object element) {
        Optional cia;
        Object parentNode;
        Object ret = element instanceof CompareInputAdapter ? ((parentNode = super.getParent((Object)((Adapter)element).getTarget())) instanceof TreeNode ? ((cia = Iterators.tryFind((Iterator)((TreeNode)parentNode).eAdapters().iterator(), (Predicate)Predicates.instanceOf(CompareInputAdapter.class))).isPresent() ? cia.get() : parentNode) : parentNode) : (element instanceof ICompareInput ? null : super.getParent(element));
        return ret;
    }

    public void runWhenReady(CallbackType type, Runnable runnable) {
        this.lock.lock();
        try {
            if (this.isFetchingGroup) {
                this.callbacks.add(new CallbackHolder(runnable, type));
            } else {
                this.run(runnable, type);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void run(Runnable callback, CallbackType type) {
        switch (type) {
            case IN_UI_SYNC: {
                SWTUtil.safeSyncExec((Runnable)callback);
                break;
            }
            case IN_UI_ASYNC: {
                SWTUtil.safeAsyncExec((Runnable)callback);
                break;
            }
            default: {
                callback.run();
            }
        }
    }

    public boolean addFetchingListener(FetchListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeFetchingListener(FetchListener listener) {
        return this.listeners.remove(listener);
    }

    public final boolean hasChildren(Object element) {
        boolean ret = element instanceof CompareInputAdapter ? super.hasChildren((Object)((Adapter)element).getTarget()) : (element instanceof ICompareInput ? false : super.hasChildren(element));
        return ret;
    }

    public final Object[] getChildren(Object element) {
        Object[] compareInputChildren;
        Object[] children = element instanceof CompareInputAdapter ? this.getCompareInputAdapterChildren((CompareInputAdapter)((Object)element)) : (element instanceof ICompareInput ? new Object[]{} : super.getChildren(element));
        if (!Iterables.all(Arrays.asList(children), (Predicate)Predicates.instanceOf(PendingUpdateAdapter.class))) {
            Iterable<?> compareInputs = EMFCompareStructureMergeViewerContentProvider.adapt(children, this.getAdapterFactory(), ICompareInput.class);
            compareInputChildren = Iterables.toArray(compareInputs, Object.class);
        } else {
            compareInputChildren = children;
        }
        return compareInputChildren;
    }

    private Object[] getCompareInputAdapterChildren(CompareInputAdapter compareInputAdapter) {
        TreeNode treeNode;
        Notifier target = compareInputAdapter.getTarget();
        if (target instanceof TreeNode && (treeNode = (TreeNode)target).getData() instanceof Comparison) {
            IDifferenceGroupProvider2 groupProvider2 = this.getGroupProvider2(treeNode);
            this.lock.lock();
            try {
                if (groupProvider2 != null && !groupProvider2.groupsAreBuilt()) {
                    Object[] objectArray = this.deferReturnChildren(compareInputAdapter);
                    return objectArray;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return super.getChildren((Object)compareInputAdapter.getTarget());
    }

    private Object[] deferReturnChildren(CompareInputAdapter compareInputAdapter) {
        if (!this.isFetchingGroup) {
            this.isFetchingGroup = true;
            for (FetchListener callback : this.listeners) {
                callback.startFetching();
            }
            compareInputAdapter.setDeferredAdapter(new EMFCompareStructureMergeViewerContentProviderDeferredAdapter(this));
            this.pending = this.contenManagerAdapter.getChildren((Object)compareInputAdapter);
        }
        return this.pending;
    }

    private IDifferenceGroupProvider2 getGroupProvider2(TreeNode treeNode) {
        IDifferenceGroupProvider2 result = null;
        Optional searchResult = Iterables.tryFind((Iterable)treeNode.eAdapters(), (Predicate)Predicates.instanceOf(IDifferenceGroupProvider2.class));
        if (searchResult.isPresent()) {
            return (IDifferenceGroupProvider2)searchResult.get();
        }
        return result;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public void dispose() {
        super.dispose();
        this.contenManagerAdapter.removeUpdateCompleteListener((IJobChangeListener)this);
        this.listeners.clear();
    }

    private static Iterable<?> adapt(Iterable<?> iterable, final AdapterFactory adapterFactory, final Class<?> type) {
        Function<Object, Object> adaptFunction = new Function<Object, Object>(){

            public Object apply(Object input) {
                Object ret = adapterFactory.adapt(input, (Object)type);
                if (ret == null) {
                    return input;
                }
                return ret;
            }
        };
        return Iterables.transform(iterable, (Function)adaptFunction);
    }

    private static Iterable<?> adapt(Object[] iterable, AdapterFactory adapterFactory, Class<?> type) {
        return EMFCompareStructureMergeViewerContentProvider.adapt(Arrays.asList(iterable), adapterFactory, type);
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        if (event.getResult().isOK()) {
            this.lock.lock();
            try {
                if (this.isFetchingGroup) {
                    this.isFetchingGroup = false;
                    this.pending = null;
                    for (FetchListener listener : this.listeners) {
                        listener.doneFetching();
                        if (!this.isFetchingGroup) continue;
                        return;
                    }
                    Iterator<CallbackHolder> callbacksIterator = this.callbacks.iterator();
                    while (callbacksIterator.hasNext()) {
                        CallbackHolder callbackHolder = callbacksIterator.next();
                        this.run(callbackHolder.getCallback(), callbackHolder.getType());
                        if (!this.isFetchingGroup) continue;
                        ArrayList remainingCallBack = Lists.newArrayList(callbacksIterator);
                        this.callbacks = new CopyOnWriteArrayList<CallbackHolder>(remainingCallBack);
                        return;
                    }
                    this.callbacks.clear();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private static class CallbackHolder {
        private final Runnable callback;
        private final CallbackType callbackType;

        public CallbackHolder(Runnable callback, CallbackType callbackType) {
            this.callback = callback;
            this.callbackType = callbackType;
        }

        private Runnable getCallback() {
            return this.callback;
        }

        private CallbackType getType() {
            return this.callbackType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CallbackType {
        IN_UI_SYNC,
        IN_UI_ASYNC,
        IN_CURRENT_THREAD;

    }

    private static class EMFCompareStructureMergeViewerContentProviderDeferredAdapter
    implements IDeferredWorkbenchAdapter {
        private final EMFCompareStructureMergeViewerContentProvider contentProvider;

        public EMFCompareStructureMergeViewerContentProviderDeferredAdapter(EMFCompareStructureMergeViewerContentProvider contentProvider) {
            this.contentProvider = contentProvider;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewerContentProvider.deferredWorkbenchAdapter.label");
        }

        public Object getParent(Object o) {
            return null;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (!monitor.isCanceled() && object instanceof CompareInputAdapter) {
                Notifier target = ((Adapter)object).getTarget();
                Object[] children = this.contentProvider.getChildren(target);
                collector.add(children, monitor);
            }
        }

        public boolean isContainer() {
            return true;
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }
    }

    static class FetchListener {
        FetchListener() {
        }

        public void startFetching() {
        }

        public void doneFetching() {
        }
    }
}

