/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.Subscribe;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.EMFCompareTextMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.ActionFactory;

public class EMFCompareTextMergeViewer
extends TextMergeViewer
implements CommandStackListener {
    private static final String BUNDLE_NAME = EMFCompareTextMergeViewer.class.getName();
    private DynamicObject fDynamicObject;
    private UndoAction fUndoAction;
    private RedoAction fRedoAction;

    public EMFCompareTextMergeViewer(Composite parent, EMFCompareConfiguration configuration) {
        super(parent, (CompareConfiguration)configuration);
        this.setContentProvider((IContentProvider)new EMFCompareTextMergeViewerContentProvider(configuration));
        this.editingDomainChange(null, configuration.getEditingDomain());
        configuration.getEventBus().register((Object)this);
    }

    @Subscribe
    public void editingDomainChange(ICompareEditingDomainChange event) {
        ICompareEditingDomain oldValue = event.getOldValue();
        ICompareEditingDomain newValue = event.getNewValue();
        this.editingDomainChange(oldValue, newValue);
    }

    public void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (oldValue != null) {
            oldValue.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        }
        if (newValue != oldValue) {
            if (newValue != null) {
                ICompareCommandStack commandStack = newValue.getCommandStack();
                commandStack.addCommandStackListener((CommandStackListener)this);
                this.setLeftDirty(commandStack.isLeftSaveNeeded());
                this.setRightDirty(commandStack.isRightSaveNeeded());
            }
            if (this.fUndoAction != null) {
                this.fUndoAction.setEditingDomain(newValue);
            }
            if (this.fRedoAction != null) {
                this.fRedoAction.setEditingDomain(newValue);
            }
        }
    }

    public void commandStackChanged(EventObject event) {
        if (this.fUndoAction != null) {
            this.fUndoAction.update();
        }
        if (this.fRedoAction != null) {
            this.fRedoAction.update();
        }
        if (this.getCompareConfiguration().getEditingDomain() != null) {
            ICompareCommandStack commandStack = this.getCompareConfiguration().getEditingDomain().getCommandStack();
            this.setLeftDirty(commandStack.isLeftSaveNeeded());
            this.setRightDirty(commandStack.isRightSaveNeeded());
        }
        IMergeViewerContentProvider contentProvider = (IMergeViewerContentProvider)this.getContentProvider();
        final String leftValueFromModel = this.getString((IStreamContentAccessor)contentProvider.getLeftContent(this.getInput()));
        final String rightValueFromModel = this.getString((IStreamContentAccessor)contentProvider.getRightContent(this.getInput()));
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            public void run() {
                String leftValueFromWidget = EMFCompareTextMergeViewer.this.getContents(true, Charsets.UTF_8.name());
                String rightValueFromWidget = EMFCompareTextMergeViewer.this.getContents(false, Charsets.UTF_8.name());
                IEqualityHelper equalityHelper = EMFCompareTextMergeViewer.this.getCompareConfiguration().getComparison().getEqualityHelper();
                if (!equalityHelper.matchingAttributeValues((Object)leftValueFromModel, (Object)leftValueFromWidget) || !equalityHelper.matchingAttributeValues((Object)rightValueFromModel, (Object)rightValueFromWidget)) {
                    EMFCompareTextMergeViewer.this.refresh();
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    private String getString(IStreamContentAccessor contentAccessor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected EMFCompareConfiguration getCompareConfiguration() {
        return (EMFCompareConfiguration)super.getCompareConfiguration();
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected String getContents(boolean isLeft, String charsetName) {
        try {
            return new String(this.getContents(isLeft), charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void updateModel(AttributeChange diff, EAttribute eAttribute, IEqualityHelper equalityHelper, EObject eObject, boolean isLeft) {
        String oldValue = this.getStringValue(eObject, eAttribute);
        GetContentRunnable runnable = new GetContentRunnable(isLeft);
        Display.getDefault().syncExec((Runnable)runnable);
        String newValue = (String)runnable.getResult();
        boolean oldAndNewEquals = equalityHelper.matchingAttributeValues((Object)newValue, (Object)oldValue);
        if (eObject != null && !oldAndNewEquals && this.getCompareConfiguration().isEditable(isLeft)) {
            this.getCompareConfiguration().getEditingDomain().getCommandStack().execute((Command)new UpdateModelAndRejectDiffCommand(this.getCompareConfiguration().getEditingDomain().getChangeRecorder(), eObject, (EStructuralFeature)eAttribute, newValue, (Diff)diff, isLeft));
        }
    }

    private String getStringValue(EObject eObject, EAttribute eAttribute) {
        EDataType eAttributeType = eAttribute.getEAttributeType();
        Object value = eObject == null ? null : ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eAttribute);
        return EcoreUtil.convertToString((EDataType)eAttributeType, (Object)value);
    }

    public DynamicObject getDynamicObject() {
        if (this.fDynamicObject == null) {
            this.fDynamicObject = new DynamicObject((Object)this);
        }
        return this.fDynamicObject;
    }

    protected final MergeSourceViewer getAncestorSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fAncestor");
    }

    protected final MergeSourceViewer getLeftSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fLeft");
    }

    protected final MergeSourceViewer getRightSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fRight");
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.getDynamicObject().get("fHandlerService");
    }

    protected final void setHandlerService(CompareHandlerService service) {
        this.getDynamicObject().set("fHandlerService", service);
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
        this.attachListeners(this.getAncestorSourceViewer(), IMergeViewer.MergeViewerSide.ANCESTOR);
        this.attachListeners(this.getLeftSourceViewer(), IMergeViewer.MergeViewerSide.LEFT);
        this.attachListeners(this.getRightSourceViewer(), IMergeViewer.MergeViewerSide.RIGHT);
    }

    protected void attachListeners(MergeSourceViewer viewer, final IMergeViewer.MergeViewerSide side) {
        if (viewer != null && (side == IMergeViewer.MergeViewerSide.LEFT || side == IMergeViewer.MergeViewerSide.RIGHT)) {
            StyledText textWidget = viewer.getSourceViewer().getTextWidget();
            textWidget.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), null);
                }

                public void focusGained(FocusEvent e) {
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)EMFCompareTextMergeViewer.this.fUndoAction);
                    EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)EMFCompareTextMergeViewer.this.fRedoAction);
                }
            });
            viewer.getSourceViewer().addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    Object oldInput = EMFCompareTextMergeViewer.this.getInput();
                    if (event.getDocumentEvent() != null && oldInput instanceof CompareInputAdapter) {
                        AttributeChange diff = (AttributeChange)((CompareInputAdapter)((Object)oldInput)).getComparisonObject();
                        EAttribute eAttribute = diff.getAttribute();
                        Match match = diff.getMatch();
                        IEqualityHelper equalityHelper = match.getComparison().getEqualityHelper();
                        EMFCompareTextMergeViewer.this.updateModel(diff, eAttribute, equalityHelper, EMFCompareTextMergeViewer.this.getMatchedEObject(match, side), side == IMergeViewer.MergeViewerSide.LEFT);
                    }
                }
            });
        }
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        this.fRedoAction = new RedoAction(this.getCompareConfiguration().getEditingDomain());
        this.fUndoAction = new UndoAction(this.getCompareConfiguration().getEditingDomain());
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.fUndoAction);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.fRedoAction);
    }

    protected void endOfContentReached(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected void navigate(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(BUNDLE_NAME);
    }

    protected void handleDispose(DisposeEvent event) {
        this.getCompareConfiguration().getEventBus().unregister((Object)this);
        this.editingDomainChange(this.getCompareConfiguration().getEditingDomain(), null);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
        this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), null);
        this.fRedoAction = null;
        this.fUndoAction = null;
        super.handleDispose(event);
    }

    protected EObject getMatchedEObject(Match match, IMergeViewer.MergeViewerSide side) {
        if (match == null) {
            return null;
        }
        switch (side) {
            case LEFT: {
                return match.getLeft();
            }
            case RIGHT: {
                return match.getRight();
            }
            case ANCESTOR: {
                return match.getOrigin();
            }
        }
        throw new IllegalStateException();
    }

    private final class GetContentRunnable
    implements Runnable {
        private final boolean isLeft;
        private String result;

        private GetContentRunnable(boolean isLeft) {
            this.isLeft = isLeft;
        }

        public void run() {
            this.result = EMFCompareTextMergeViewer.this.getContents(this.isLeft, Charsets.UTF_8.name());
        }

        public Object getResult() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateModelAndRejectDiffCommand
    extends ChangeCommand
    implements ICompareCopyCommand {
        private boolean isLeft;
        private Diff difference;
        private Object value;
        private EStructuralFeature feature;
        private EObject owner;

        public UpdateModelAndRejectDiffCommand(ChangeRecorder changeRecorder, EObject owner, EStructuralFeature feature, Object value, Diff difference, boolean isLeft) {
            super(changeRecorder, (Collection)ImmutableSet.builder().add((Object)owner).addAll(UpdateModelAndRejectDiffCommand.getAffectedDiff(difference)).build());
            this.owner = owner;
            this.feature = feature;
            this.value = value;
            this.difference = difference;
            this.isLeft = isLeft;
        }

        public void doExecute() {
            this.owner.eSet(this.feature, this.value);
            for (Diff affectedDiff : UpdateModelAndRejectDiffCommand.getAffectedDiff(this.difference)) {
                affectedDiff.setState(DifferenceState.DISCARDED);
            }
        }

        private static Set<Diff> getAffectedDiff(Diff diff) {
            EList conflicts = diff.getMatch().getComparison().getConflicts();
            for (Conflict conflict : conflicts) {
                EList conflictualDifferences = conflict.getDifferences();
                if (!conflictualDifferences.contains((Object)diff)) continue;
                return ImmutableSet.copyOf((Collection)conflictualDifferences);
            }
            return ImmutableSet.of((Object)diff);
        }

        public boolean isLeftToRight() {
            return !this.isLeft;
        }
    }
}

