/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.compare.internal.utils.PruningIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Graph<E> {
    private final Map<E, Node<E>> nodes = new LinkedHashMap<E, Node<E>>();
    private final Set<Node<E>> roots = new LinkedHashSet<Node<E>>();
    private final ReentrantLock lock = new ReentrantLock();
    private transient int modcount;

    public boolean contains(E element) {
        this.lock.lock();
        try {
            boolean bl = this.nodes.containsKey(element);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.nodes.clear();
            this.roots.clear();
            ++this.modcount;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean add(E element) {
        this.lock.lock();
        try {
            Node<E> node = this.nodes.get(element);
            if (node == null) {
                node = new Node<E>(element);
                this.nodes.put(element, node);
                this.roots.add(node);
                ++this.modcount;
                return true;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(E element) {
        this.lock.lock();
        try {
            Node<E> node = this.nodes.remove(element);
            if (node != null) {
                node.breakConnections();
                this.roots.remove(node);
                ++this.modcount;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeAll(Collection<E> elements) {
        this.lock.lock();
        try {
            for (E e : elements) {
                this.remove(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addChildren(E element, Set<E> newChildren) {
        this.lock.lock();
        try {
            Node<E> node = this.nodes.get(element);
            if (node == null) {
                node = new Node<E>(element);
                this.nodes.put(element, node);
                this.roots.add(node);
                ++this.modcount;
            }
            for (E newChild : newChildren) {
                Node<E> childNode = this.nodes.get(newChild);
                if (childNode == null) {
                    childNode = new Node<E>(newChild);
                    this.nodes.put(newChild, childNode);
                } else {
                    this.roots.remove(childNode);
                }
                ++this.modcount;
                node.connectChild(childNode);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasChild(E parent, E potentialChild) {
        this.lock.lock();
        try {
            Node<E> node = this.nodes.get(potentialChild);
            if (node != null) {
                boolean bl = Iterables.any(node.getAllParents(), this.is(parent));
                return bl;
            }
            return false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Predicate<? super Node<E>> is(final E element) {
        return new Predicate<Node<E>>(){

            public boolean apply(Node<E> input) {
                return input != null && input.getElement() == element;
            }
        };
    }

    public Set<E> getDirectParents(E element) {
        LinkedHashSet<E> parents = new LinkedHashSet<E>();
        this.lock.lock();
        try {
            Node<E> node = this.nodes.get(element);
            if (node != null) {
                for (Node<E> parent : node.getParents()) {
                    parents.add(parent.getElement());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return parents;
    }

    public Set<E> getTreeFrom(E root) {
        return this.getTreeFrom(root, Collections.emptySet());
    }

    public Set<E> getTreeFrom(E root, Set<E> endPoints) {
        this.lock.lock();
        try {
            Node<E> node = this.nodes.get(root);
            if (node != null) {
                Set<Object> boundaries = endPoints;
                if (boundaries == null) {
                    boundaries = Collections.emptySet();
                }
                Set<E> set = new SubgraphBuilder<E>(node, boundaries).buildTree();
                return set;
            }
        }
        finally {
            this.lock.unlock();
        }
        return Collections.emptySet();
    }

    public Set<E> getSubgraphContaining(E element) {
        return this.getSubgraphContaining(element, Collections.emptySet());
    }

    public Set<E> getSubgraphContaining(E element, Set<E> endPoints) {
        this.lock.lock();
        try {
            Node<E> node = this.nodes.get(element);
            if (node != null) {
                Set<Object> boundaries = endPoints;
                if (boundaries == null) {
                    boundaries = Collections.emptySet();
                }
                Set<E> set = new SubgraphBuilder<E>(node, boundaries).buildSubgraph();
                return set;
            }
            Set set = Collections.emptySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public PruningIterator<E> breadthFirstIterator() {
        return new BreadthFirstIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BreadthFirstIterator
    implements PruningIterator<E> {
        private Iterator<Node<E>> currentIterator;
        private Set<Node<E>> nextIterable;
        private Set<Node<E>> consumedNodes;
        private Node<E> lastReturned;
        private Node<E> next;
        private int expectedModCount;

        public BreadthFirstIterator() {
            this.currentIterator = Graph.this.roots.iterator();
            this.nextIterable = new LinkedHashSet();
            this.consumedNodes = new LinkedHashSet();
            this.expectedModCount = Graph.this.modcount;
            this.prepareNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null || this.currentIterator.hasNext() || !this.consumedNodes.containsAll(this.nextIterable);
        }

        @Override
        public E next() {
            if (Graph.this.modcount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object result = this.next.getElement();
            this.consumedNodes.add(this.next);
            this.lastReturned = this.next;
            this.prepareNext();
            return result;
        }

        @Override
        public void prune() {
            if (this.lastReturned == null) {
                return;
            }
            Set children = this.lastReturned.getChildren();
            this.lastReturned = null;
            while (!children.isEmpty()) {
                this.consumedNodes.addAll(children);
                Set copy = children;
                children = new LinkedHashSet();
                for (Node node : copy) {
                    children.addAll(node.getChildren());
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void prepareNext() {
            if (!this.currentIterator.hasNext()) {
                this.prepareNextIterator();
            }
            if (this.currentIterator.hasNext()) {
                this.next = this.currentIterator.next();
                this.nextIterable.addAll(this.next.getChildren());
            } else {
                this.next = null;
            }
        }

        private void prepareNextIterator() {
            LinkedHashSet difference = new LinkedHashSet();
            for (Node node : this.nextIterable) {
                if (this.consumedNodes.contains(node)) continue;
                difference.add(node);
            }
            this.currentIterator = Iterators.filter(difference.iterator(), (Predicate)new Predicate<Node<E>>(){

                public boolean apply(Node<E> input) {
                    return BreadthFirstIterator.this.consumedNodes.containsAll(input.getParents());
                }
            });
            this.nextIterable.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<K> {
        private final K element;
        private final Set<Node<K>> children;
        private final Set<Node<K>> parents;

        public Node(K element) {
            this.element = element;
            this.parents = new LinkedHashSet<Node<K>>();
            this.children = new LinkedHashSet<Node<K>>();
        }

        public Set<Node<K>> getChildren() {
            return Collections.unmodifiableSet(this.children);
        }

        public Set<Node<K>> getParents() {
            return Collections.unmodifiableSet(this.parents);
        }

        public Iterable<Node<K>> getAllParents() {
            return new ParentsIterable(this);
        }

        public void connectChild(Node<K> child) {
            this.children.add(child);
            child.parents.add(this);
        }

        public void breakConnections() {
            for (Node<K> parent : this.parents) {
                parent.children.remove(this);
            }
            for (Node<K> child : this.children) {
                child.parents.remove(this);
            }
            this.parents.clear();
            this.children.clear();
        }

        public K getElement() {
            return this.element;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentsIterable<O>
    implements Iterable<Node<O>> {
        private final Node<O> start;

        public ParentsIterable(Node<O> start) {
            this.start = start;
        }

        @Override
        public Iterator<Node<O>> iterator() {
            return new ParentsIterator<O>(this.start);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentsIterator<P>
    extends AbstractTreeIterator<Node<P>> {
        private static final long serialVersionUID = -4476850344598138970L;

        public ParentsIterator(Node<P> start) {
            super(start, false);
        }

        protected Iterator<? extends Node<P>> getChildren(Object obj) {
            return ((Node)obj).getParents().iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubgraphBuilder<L> {
        protected final Set<L> set;
        protected final Set<L> endPoints;
        private final Node<L> start;

        public SubgraphBuilder(Node<L> start, Set<L> endPoints) {
            this.start = start;
            this.set = new LinkedHashSet<L>();
            this.set.add(start.getElement());
            this.endPoints = (Set)Preconditions.checkNotNull(endPoints);
        }

        public Set<L> buildSubgraph() {
            return ImmutableSet.copyOf((Iterator)new NodeIterator(this.start));
        }

        public Set<L> buildTree() {
            NodeIterator iterator = new NodeIterator(this, this.start){

                @Override
                protected Iterator<Node<L>> createConnectedNodesIterator(Node<L> node) {
                    return node.getChildren().iterator();
                }
            };
            return ImmutableSet.copyOf((Iterator)iterator);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class NodeIterator
        implements Iterator<L> {
            private final Iterator<Node<L>> nodesIterator;
            private Iterator<L> nextNodeIterator;
            private L next;

            public NodeIterator(Node<L> node) {
                this.next = node.getElement();
                this.nodesIterator = this.createConnectedNodesIterator(node);
                this.prepareNextIterator();
            }

            protected Iterator<Node<L>> createConnectedNodesIterator(Node<L> node) {
                return Iterators.concat(node.getParents().iterator(), node.getChildren().iterator());
            }

            @Override
            public boolean hasNext() {
                return this.next != null || this.nextNodeIterator.hasNext() || this.nodesIterator.hasNext();
            }

            @Override
            public L next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.prepareNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void prepareNext() {
                if (!this.nextNodeIterator.hasNext()) {
                    this.prepareNextIterator();
                }
                this.next = this.nextNodeIterator.hasNext() ? this.nextNodeIterator.next() : null;
            }

            private void prepareNextIterator() {
                if (this.nodesIterator.hasNext()) {
                    Node nextNode = this.nodesIterator.next();
                    while (SubgraphBuilder.this.set.contains(nextNode.getElement()) && !SubgraphBuilder.this.endPoints.contains(nextNode.getElement()) && this.nodesIterator.hasNext()) {
                        nextNode = this.nodesIterator.next();
                    }
                    this.nextNodeIterator = !SubgraphBuilder.this.endPoints.contains(nextNode.getElement()) && SubgraphBuilder.this.set.add(nextNode.getElement()) ? new NodeIterator(nextNode) : Iterators.emptyIterator();
                } else {
                    this.nextNodeIterator = Iterators.emptyIterator();
                }
            }
        }
    }
}

