/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.GroupsPreferencePage;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.ui.SynchronizerDialog;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DifferenceGroupManager;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.Preferences;

public class GroupAction
extends Action {
    private final StructureMergeViewerGrouper structureMergeViewerGrouper;
    private final IDifferenceGroupProvider provider;
    private final IDifferenceGroupProvider.Descriptor descriptorGroupProvider;
    private final boolean isThreeWay;
    private final DifferenceGroupManager groupManager;
    private final Preferences preferences;

    public GroupAction(StructureMergeViewerGrouper structureMergeViewerGrouper, IDifferenceGroupProvider.Descriptor dgp, IDifferenceGroupProvider gp, DifferenceGroupManager groupManager, boolean isThreeWay) {
        super(dgp.getLabel(), 8);
        this.structureMergeViewerGrouper = structureMergeViewerGrouper;
        this.descriptorGroupProvider = dgp;
        this.groupManager = groupManager;
        this.isThreeWay = isThreeWay;
        this.provider = gp;
        this.preferences = EMFCompareRCPUIPlugin.getDefault().getEMFCompareUIPreferences();
    }

    public boolean isEnabled() {
        return this.provider != null;
    }

    public IDifferenceGroupProvider.Descriptor getDescriptorGroupProvider() {
        return this.descriptorGroupProvider;
    }

    public void runWithEvent(Event event) {
        if (this.isChecked()) {
            this.handleSynchronization(event);
            this.structureMergeViewerGrouper.setProvider(this.provider);
        }
    }

    private void handleSynchronization(Event event) {
        Shell shell = event.display.getActiveShell();
        String preferenceValue = this.preferences.get(GroupsPreferencePage.getGroupSynchronizationPreferenceKey(this.isThreeWay), "prompt");
        if ("prompt".equals(preferenceValue)) {
            shell.getDisplay().asyncExec((Runnable)new SynchronizationRunnable(shell));
        } else if ("always".equals(preferenceValue)) {
            this.setSelectedGroupAsDefault();
        }
    }

    private void setSelectedGroupAsDefault() {
        List<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> currentState = this.groupManager.getCurrentGroupRanking(this.isThreeWay);
        IItemDescriptor<IDifferenceGroupProvider.Descriptor> matchingItem = null;
        Iterator<IItemDescriptor<IDifferenceGroupProvider.Descriptor>> itemsIterator = currentState.iterator();
        while (itemsIterator.hasNext() && matchingItem == null) {
            IItemDescriptor<IDifferenceGroupProvider.Descriptor> currentItem = itemsIterator.next();
            if (!((IDifferenceGroupProvider.Descriptor)currentItem.getItem()).equals(this.descriptorGroupProvider)) continue;
            matchingItem = currentItem;
        }
        if (matchingItem != null) {
            currentState.remove(matchingItem);
            currentState.add(0, matchingItem);
            this.groupManager.setCurrentGroupRanking(currentState, this.isThreeWay);
        } else {
            EMFCompareRCPUIPlugin.getDefault().log(2, "Enable to set selected difference group provider as default group provider. The selected group provider is not in the registry anymore");
        }
    }

    private final class SynchronizationRunnable
    implements Runnable {
        private final Shell shell;

        private SynchronizationRunnable(Shell shell) {
            this.shell = shell;
        }

        public void run() {
            SynchronizerDialog dialog = new SynchronizerDialog(this.shell, EMFCompareRCPUIMessages.getString("GroupAction.synchronization.dialog.title"), EMFCompareRCPUIMessages.getString("GroupAction.synchronization.dialog.message"), "org.eclipse.emf.compare.rcp.ui.preferencePage.groups");
            dialog.setPrefKey(GroupsPreferencePage.getGroupSynchronizationPreferenceKey(GroupAction.this.isThreeWay));
            dialog.setPrefStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.emf.compare.rcp.ui"));
            if (dialog.open() == 2) {
                GroupAction.this.setSelectedGroupAsDefault();
            }
        }
    }
}

