/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.resource;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.match.resource.IResourceMatchingStrategy;
import org.eclipse.emf.compare.match.resource.NameMatchingStrategy;
import org.eclipse.emf.compare.match.resource.RootIDMatchingStrategy;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyResourceMatcher
implements IResourceMatcher {
    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<MatchResource> createMappings(Iterator<? extends Resource> leftResources, Iterator<? extends Resource> rightResources, Iterator<? extends Resource> originResources) {
        List<Object> mappings;
        ArrayList leftCopy = Lists.newArrayList(leftResources);
        ArrayList rightCopy = Lists.newArrayList(rightResources);
        ArrayList originCopy = Lists.newArrayList(originResources);
        IResourceMatchingStrategy[] strategies = this.getResourceMatchingStrategies();
        if (strategies.length == 1) {
            mappings = strategies[0].matchResources(leftCopy, rightCopy, originCopy);
            for (MatchResource matchResource : mappings) {
                leftCopy.remove(matchResource.getLeft());
                rightCopy.remove(matchResource.getRight());
                originCopy.remove(matchResource.getOrigin());
            }
        } else {
            void var9_12;
            mappings = Lists.newArrayList();
            boolean bl = false;
            while (var9_12 < strategies.length && !StrategyResourceMatcher.atLeastTwo(leftCopy.isEmpty(), rightCopy.isEmpty(), originCopy.isEmpty())) {
                List<MatchResource> newMappings = strategies[var9_12].matchResources(leftCopy, rightCopy, originCopy);
                for (MatchResource newMapping : newMappings) {
                    leftCopy.remove(newMapping.getLeft());
                    rightCopy.remove(newMapping.getRight());
                    originCopy.remove(newMapping.getOrigin());
                }
                mappings.addAll(newMappings);
                ++var9_12;
            }
        }
        for (Resource resource : leftCopy) {
            mappings.add(StrategyResourceMatcher.createMatchResource(resource, null, null));
        }
        for (Resource resource : rightCopy) {
            mappings.add(StrategyResourceMatcher.createMatchResource(null, resource, null));
        }
        for (Resource resource : originCopy) {
            mappings.add(StrategyResourceMatcher.createMatchResource(null, null, resource));
        }
        return mappings;
    }

    protected static boolean atLeastTwo(boolean condition1, boolean condition2, boolean condition3) {
        return condition1 && (condition2 || condition3) || condition2 && condition3;
    }

    protected IResourceMatchingStrategy[] getResourceMatchingStrategies() {
        RootIDMatchingStrategy idStrategy = new RootIDMatchingStrategy();
        NameMatchingStrategy nameStrategy = new NameMatchingStrategy();
        return new IResourceMatchingStrategy[]{idStrategy, nameStrategy};
    }

    protected static MatchResource createMatchResource(Resource left, Resource right, Resource origin) {
        MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
        match.setLeft(left);
        match.setRight(right);
        match.setOrigin(origin);
        if (left != null && left.getURI() != null) {
            match.setLeftURI(left.getURI().toString());
        }
        if (right != null && right.getURI() != null) {
            match.setRightURI(right.getURI().toString());
        }
        if (origin != null && origin.getURI() != null) {
            match.setOriginURI(origin.getURI().toString());
        }
        return match;
    }
}

