/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.internal.utils.ForwardingXMLDefaultHandler;
import org.eclipse.emf.compare.ide.internal.utils.ForwardingXMLHelper;
import org.eclipse.emf.compare.ide.internal.utils.INamespaceDeclarationListener;
import org.eclipse.emf.compare.ide.internal.utils.IProxyCreationListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLDefaultHandler;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotifyingParserPool
extends XMLParserPoolImpl {
    protected final boolean containmentOnly;
    private ListenerList proxyListeners = new ListenerList();
    private ListenerList namespaceDeclarationListeners = new ListenerList();

    public NotifyingParserPool(boolean containmentOnly) {
        super(true);
        this.containmentOnly = containmentOnly;
    }

    public synchronized XMLDefaultHandler getDefaultHandler(XMLResource resource, XMLLoad xmlLoad, XMLHelper helper, Map<?, ?> options) {
        NotifyingXMLHelper wrapper = new NotifyingXMLHelper(helper, this.containmentOnly);
        Object[] objectArray = this.proxyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            wrapper.addProxyListener((IProxyCreationListener)listener);
            ++n2;
        }
        XMLDefaultHandler handler = this.createDefaultHandler(resource, xmlLoad, wrapper, options);
        NamespaceDeclarationNotifyingXMLDefaultHandler handlerWrapper = new NamespaceDeclarationNotifyingXMLDefaultHandler(handler);
        Object[] objectArray2 = this.namespaceDeclarationListeners.getListeners();
        int n3 = objectArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Object listener = objectArray2[n4];
            handlerWrapper.addNamespaceDeclarationListener((INamespaceDeclarationListener)listener);
            ++n4;
        }
        handlerWrapper.prepare(resource, wrapper, options);
        return handlerWrapper;
    }

    protected XMLDefaultHandler createDefaultHandler(XMLResource resource, XMLLoad xmlLoad, XMLHelper helper, Map<?, ?> options) {
        return super.getDefaultHandler(resource, xmlLoad, helper, options);
    }

    public void addProxyListener(IProxyCreationListener listener) {
        this.proxyListeners.add((Object)listener);
    }

    public void removeProxyListener(IProxyCreationListener listener) {
        this.proxyListeners.remove((Object)listener);
    }

    public void addNamespaceDeclarationListener(INamespaceDeclarationListener listener) {
        this.namespaceDeclarationListeners.add((Object)listener);
    }

    public void removeNamespaceDeclarationListener(INamespaceDeclarationListener listener) {
        this.namespaceDeclarationListeners.remove((Object)listener);
    }

    private static class NamespaceDeclarationNotifyingXMLDefaultHandler
    extends ForwardingXMLDefaultHandler {
        private ListenerList namespaceDeclarationListeners = new ListenerList();
        private boolean isRoot;

        public NamespaceDeclarationNotifyingXMLDefaultHandler(XMLDefaultHandler delegate) {
            super(delegate);
        }

        public void startDocument() throws SAXException {
            this.isRoot = true;
            super.startDocument();
        }

        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            if (this.isRoot) {
                String xsiSchemaLocation = arg3.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                if (xsiSchemaLocation != null) {
                    this.declareSchemaLocation(xsiSchemaLocation);
                }
                this.isRoot = false;
            }
            super.startElement(arg0, arg1, arg2, arg3);
        }

        public void addNamespaceDeclarationListener(INamespaceDeclarationListener listener) {
            this.namespaceDeclarationListeners.add((Object)listener);
        }

        private void declareSchemaLocation(String xsiSchemaLocation) {
            StringTokenizer stringTokenizer = new StringTokenizer(xsiSchemaLocation, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String key = stringTokenizer.nextToken();
                if (!stringTokenizer.hasMoreTokens()) continue;
                String value = stringTokenizer.nextToken();
                URI uri = URI.createURI((String)value);
                Object[] objectArray = this.namespaceDeclarationListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((INamespaceDeclarationListener)listener).schemaLocationDeclared(key, uri);
                    ++n2;
                }
            }
        }
    }

    private static class NotifyingXMLHelper
    extends ForwardingXMLHelper {
        private final ListenerList proxyListeners = new ListenerList();
        private final boolean containmentOnly;

        public NotifyingXMLHelper(XMLHelper delegate, boolean containmentOnly) {
            super(delegate);
            this.containmentOnly = containmentOnly;
        }

        public void setValue(EObject eObject, EStructuralFeature eStructuralFeature, Object value, int position) {
            if (!this.containmentOnly || eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment()) {
                super.setValue(eObject, eStructuralFeature, value, position);
            }
            if (value instanceof EObject && ((EObject)value).eIsProxy()) {
                Object[] objectArray = this.proxyListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IProxyCreationListener)listener).proxyCreated((Resource)this.getResource(), eObject, eStructuralFeature, (EObject)value, position);
                    ++n2;
                }
            }
        }

        public void addProxyListener(IProxyCreationListener listener) {
            this.proxyListeners.add((Object)listener);
        }
    }
}

