/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.util.ResourceUIUtil;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDifferenceGroupImpl
extends AdapterImpl
implements IDifferenceGroup {
    protected static final Function<EObject, Iterator<EObject>> E_ALL_CONTENTS = new Function<EObject, Iterator<EObject>>(){

        public Iterator<EObject> apply(EObject eObject) {
            return eObject.eAllContents();
        }
    };
    protected final Predicate<? super Diff> filter;
    protected final String name;
    protected final Image image;
    protected List<TreeNode> children;
    protected Set<Diff> extensionDiffProcessed;
    private final Comparison comparison;
    private final IDifferenceGroupExtender.Registry registry = EMFCompareRCPUIPlugin.getDefault().getDifferenceGroupExtenderRegistry();
    private final ECrossReferenceAdapter crossReferenceAdapter;
    private static final Function<Diff, ChildrenSide> DIFF_TO_SIDE = new Function<Diff, ChildrenSide>(){

        public ChildrenSide apply(Diff diff) {
            Conflict c;
            ChildrenSide side = diff != null ? ((c = diff.getConflict()) != null && Predicates.or((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}), (Predicate)Predicates.and((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))).apply((Object)diff) ? ChildrenSide.getValueFrom(diff.getSource()) : ChildrenSide.BOTH) : ChildrenSide.BOTH;
            return side;
        }
    };

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, ECrossReferenceAdapter crossReferenceAdapter) {
        this(comparison, filter, EMFCompareRCPUIMessages.getString("BasicDifferenceGroup.name"), EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"), crossReferenceAdapter);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, ECrossReferenceAdapter crossReferenceAdapter) {
        this(comparison, filter, name, EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"), crossReferenceAdapter);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, Image image, ECrossReferenceAdapter crossReferenceAdapter) {
        this.comparison = comparison;
        this.filter = filter;
        this.name = name;
        this.image = image;
        this.crossReferenceAdapter = crossReferenceAdapter;
    }

    protected final Comparison getComparison() {
        return this.comparison;
    }

    public boolean isAdapterForType(Object type) {
        return type == IDifferenceGroup.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStyledString.IComposedStyledString getStyledName() {
        ComposedStyledString ret = new ComposedStyledString();
        Iterator eAllContents = Iterators.concat((Iterator)Iterators.transform(this.getChildren().iterator(), E_ALL_CONTENTS));
        Iterator eAllData = Iterators.transform((Iterator)eAllContents, (Function)TREE_NODE_DATA);
        boolean unresolvedDiffs = Iterators.any((Iterator)Iterators.filter((Iterator)eAllData, Diff.class), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        if (unresolvedDiffs) {
            ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
        }
        ret.append(this.getName());
        return ret;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public List<? extends TreeNode> getChildren() {
        if (this.children == null) {
            this.buildSubTree();
        }
        return this.children;
    }

    protected final void registerCrossReferenceAdapter(List<? extends Notifier> notifiers) {
        for (Notifier notifier : notifiers) {
            notifier.eAdapters().add((Object)this.crossReferenceAdapter);
        }
    }

    protected final void unregisterCrossReferenceAdapter(List<? extends Notifier> notifiers) {
        for (Notifier notifier : notifiers) {
            notifier.eAdapters().remove((Object)this.crossReferenceAdapter);
        }
    }

    protected TreeNode buildSubTree(MatchResource matchResource, Set<ResourceAttachmentChange> attachmentChanges) {
        TreeNode treeNode = this.wrap((EObject)matchResource);
        Collection filteredChanges = Collections2.filter(attachmentChanges, this.filter);
        for (ResourceAttachmentChange attachmentChange : filteredChanges) {
            treeNode.getChildren().add((Object)this.wrap((EObject)attachmentChange));
        }
        return treeNode;
    }

    public List<TreeNode> buildSubTree(Match parentMatch, Match match) {
        return this.buildSubTree(match, false, ChildrenSide.BOTH);
    }

    public List<TreeNode> buildContainmentSubTree(Match match) {
        return this.buildSubTree(match, true, ChildrenSide.BOTH);
    }

    protected List<TreeNode> buildSubTree(Match match, boolean containment, ChildrenSide side) {
        ArrayList ret = Lists.newArrayList();
        LinkedHashSet nodeChildren = Sets.newLinkedHashSet();
        LinkedHashSet matchOfValues = Sets.newLinkedHashSet();
        TreeNode matchTreeNode = this.wrap((EObject)match);
        if (!containment) {
            ret.add(matchTreeNode);
        }
        boolean hasDiff = false;
        for (Diff diff : Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.and(this.filter, BasicDifferenceGroupImpl.compatibleSide(side)))) {
            if (EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE.apply((Object)diff)) {
                TreeNode node;
                hasDiff = true;
                if (containment) {
                    node = this.wrap((EObject)diff);
                    ret.add(node);
                } else {
                    node = this.buildSubTree(diff);
                    nodeChildren.add(node);
                }
                Match matchOfValue = match.getComparison().getMatch(((ReferenceChange)diff).getValue());
                if (matchOfValue != null) {
                    matchOfValues.add(matchOfValue);
                    node.getChildren().addAll(this.buildSubTree(matchOfValue, true, (ChildrenSide)((Object)DIFF_TO_SIDE.apply((Object)diff))));
                }
                if (containment) {
                    ret.addAll(this.manageRefines(diff, side));
                    continue;
                }
                nodeChildren.addAll(this.manageRefines(diff, side));
                continue;
            }
            if (diff instanceof ResourceAttachmentChange || diff.getPrimeRefining() != null && this.extensionDiffProcessed.contains(diff)) continue;
            hasDiff = true;
            if (containment) {
                ret.add(this.wrap((EObject)diff));
                continue;
            }
            nodeChildren.add(this.buildSubTree(diff));
        }
        ArrayList toRemove = Lists.newArrayList();
        for (TreeNode treeNode : ret) {
            boolean hasNonEmptySubMatch = false;
            for (Match subMatch : Sets.difference((Set)Sets.newLinkedHashSet((Iterable)match.getSubmatches()), (Set)matchOfValues)) {
                List<TreeNode> buildSubTree = this.buildSubTree(subMatch, containment, ChildrenSide.BOTH);
                if (buildSubTree.isEmpty()) continue;
                hasNonEmptySubMatch = true;
                treeNode.getChildren().addAll(buildSubTree);
            }
            treeNode.getChildren().addAll((Collection)nodeChildren);
            if (!(containment || hasDiff || hasNonEmptySubMatch || this.filter.equals((Object)Predicates.alwaysTrue()))) {
                toRemove.add(treeNode);
                continue;
            }
            if (!containment && this.isMatchWithOnlyResourceAttachmentChanges(match)) {
                toRemove.add(treeNode);
                continue;
            }
            if (this.isMatchWithProxyData(match)) {
                toRemove.add(treeNode);
                continue;
            }
            for (IDifferenceGroupExtender ext : this.registry.getExtenders()) {
                if (!ext.handle(treeNode)) continue;
                ext.addChildren(treeNode);
            }
        }
        ret.removeAll(toRemove);
        return ret;
    }

    private boolean isMatchWithProxyData(Match match) {
        boolean proxy = false;
        if (match.getLeft() != null) {
            if (match.getLeft().eIsProxy()) {
                proxy = true;
            }
        } else if (match.getRight() != null) {
            if (match.getRight().eIsProxy()) {
                proxy = true;
            }
        } else if (match.getOrigin() != null && match.getOrigin().eIsProxy()) {
            proxy = true;
        }
        return proxy;
    }

    private List<TreeNode> manageRefines(Diff diff, ChildrenSide side) {
        ArrayList ret = Lists.newArrayList();
        EList refines = diff.getRefines();
        for (Diff refine : refines) {
            Diff mainDiff = refine.getPrimeRefining();
            if (mainDiff == null || mainDiff != diff || !Predicates.and(this.filter, BasicDifferenceGroupImpl.compatibleSide(side)).apply((Object)refine)) continue;
            TreeNode refineSubTree = this.buildSubTree(refine);
            ret.add(refineSubTree);
            this.extensionDiffProcessed.add(refine);
        }
        return ret;
    }

    private TreeNode buildSubTree(Diff diff) {
        TreeNode treeNode = this.wrap((EObject)diff);
        for (IDifferenceGroupExtender ext : this.registry.getExtenders()) {
            if (!ext.handle(treeNode)) continue;
            ext.addChildren(treeNode);
        }
        return treeNode;
    }

    protected TreeNode wrap(EObject data) {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData(data);
        treeNode.eAdapters().add((Object)this);
        return treeNode;
    }

    private boolean isMatchWithOnlyResourceAttachmentChanges(Match match) {
        boolean ret = false;
        Iterable allDifferences = match.getAllDifferences();
        if (Iterables.isEmpty((Iterable)allDifferences)) {
            ret = false;
        } else if (Iterables.all((Iterable)allDifferences, (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class)) && (match.getSubmatches() == null || match.getSubmatches().isEmpty())) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            this.unregisterCrossReferenceAdapter(this.children);
            this.children = null;
        }
    }

    private static Predicate<? super Diff> compatibleSide(final ChildrenSide side) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input != null && side != ChildrenSide.BOTH) {
                    return side == ChildrenSide.getValueFrom(input.getSource());
                }
                return side == ChildrenSide.BOTH;
            }
        };
    }

    public void buildSubTree() {
        this.children = Lists.newArrayList();
        this.extensionDiffProcessed = Sets.newLinkedHashSet();
        this.children.addAll(this.buildMatchSubTrees());
        this.children.addAll(this.buildMatchResourceSubTrees());
        this.registerCrossReferenceAdapter(this.children);
    }

    protected List<TreeNode> buildMatchSubTrees() {
        ArrayList<TreeNode> matchSubTrees = new ArrayList<TreeNode>();
        for (Match match : this.comparison.getMatches()) {
            List<TreeNode> buildSubTree = this.buildSubTree(null, match);
            if (buildSubTree == null) continue;
            matchSubTrees.addAll(buildSubTree);
        }
        List<TreeNode> rootNodes = this.addNotLoadedFragmentNodes(matchSubTrees);
        return rootNodes;
    }

    protected List<TreeNode> buildMatchResourceSubTrees() {
        ArrayList<TreeNode> matchResourceSubTrees = new ArrayList<TreeNode>();
        if (this.comparison.getMatchedResources().isEmpty()) {
            return matchResourceSubTrees;
        }
        Iterable attachmentChanges = Iterables.filter((Iterable)this.comparison.getDifferences(), ResourceAttachmentChange.class);
        LinkedHashMultimap uriToRAC = LinkedHashMultimap.create();
        for (ResourceAttachmentChange attachmentChange : attachmentChanges) {
            uriToRAC.put((Object)attachmentChange.getResourceURI(), (Object)attachmentChange);
        }
        for (MatchResource matchResource : this.comparison.getMatchedResources()) {
            Collection leftRAC = uriToRAC.get((Object)matchResource.getLeftURI());
            Collection rightRAC = uriToRAC.get((Object)matchResource.getRightURI());
            Collection originRAC = uriToRAC.get((Object)matchResource.getOriginURI());
            LinkedHashSet racForMatchResource = Sets.newLinkedHashSet();
            racForMatchResource.addAll(leftRAC);
            racForMatchResource.addAll(rightRAC);
            racForMatchResource.addAll(originRAC);
            TreeNode buildSubTree = this.buildSubTree(matchResource, racForMatchResource);
            if (buildSubTree == null) continue;
            matchResourceSubTrees.add(buildSubTree);
        }
        return matchResourceSubTrees;
    }

    private List<TreeNode> addNotLoadedFragmentNodes(List<TreeNode> rootNodes) {
        ArrayList<TreeNode> newRootNodes = new ArrayList<TreeNode>(rootNodes);
        for (TreeNode treeNode : rootNodes) {
            URI uri;
            EObject data = (EObject)TREE_NODE_DATA.apply((Object)treeNode);
            if (!(data instanceof Match) || !ResourceUIUtil.isFragment(uri = ResourceUIUtil.getDataURI((Match)data))) continue;
            newRootNodes.remove(treeNode);
            TreeNode notLoadedFragment = this.addNotLoadedFragment(rootNodes, treeNode, (Match)data, uri);
            if (notLoadedFragment == null) continue;
            newRootNodes.add(notLoadedFragment);
        }
        if (ResourceUIUtil.containsNotLoadedFragmentNodes(newRootNodes)) {
            Collection<TreeNode> nodes = this.encapsulateNotLoadedFragmentNodes(newRootNodes);
            newRootNodes.clear();
            newRootNodes.addAll(nodes);
        }
        return newRootNodes;
    }

    private TreeNode addNotLoadedFragment(List<TreeNode> rootNodes, TreeNode treeNode, Match match, URI uri) {
        TreeNode newRootNode = null;
        TreeNode notLoadedFragmentNode = this.createNotLoadedFragmentMatchNode(treeNode, match);
        if (ResourceUIUtil.isFirstLevelFragment(uri)) {
            URI rootURI = ResourceUIUtil.getRootResourceURI(uri);
            if (rootURI != null) {
                TreeNode realParent = ResourceUIUtil.getTreeNodeFromURI(rootNodes, rootURI);
                if (realParent != null) {
                    realParent.getChildren().add((Object)notLoadedFragmentNode);
                } else {
                    newRootNode = notLoadedFragmentNode;
                }
            }
        } else {
            ResourceSet rs = ResourceUIUtil.getDataResourceSet(match);
            EObject eObject = ResourceUIUtil.getEObjectParent(rs, uri);
            if (eObject != null) {
                Match newParentMatch = this.getComparison().getMatch(eObject);
                TreeNode newParentNode = ResourceUIUtil.getTreeNode(rootNodes, newParentMatch);
                if (newParentNode != null) {
                    EList newParentNodeChildren = newParentNode.getChildren();
                    newParentNodeChildren.add((Object)notLoadedFragmentNode);
                    this.setNotLoadedFragmentNodesName((Collection<TreeNode>)newParentNodeChildren);
                } else {
                    newRootNode = notLoadedFragmentNode;
                }
            } else {
                newRootNode = notLoadedFragmentNode;
            }
        }
        return newRootNode;
    }

    private void setNotLoadedFragmentNodesName(Collection<TreeNode> nodes) {
        if (ResourceUIUtil.containsNotLoadedFragmentNodes(nodes)) {
            for (TreeNode node : nodes) {
                EObject data = (EObject)TREE_NODE_DATA.apply((Object)node);
                if (!(data instanceof NotLoadedFragmentMatch)) continue;
                ((NotLoadedFragmentMatch)data).setName(ResourceUIUtil.getResourceName((NotLoadedFragmentMatch)data));
            }
        }
    }

    private TreeNode createNotLoadedFragmentMatchNode(TreeNode node, Match match) {
        TreeNode notLoadedFragmentNode = TreeFactory.eINSTANCE.createTreeNode();
        NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(match);
        notLoadedFragmentNode.setData((EObject)notLoadedFragmentMatch);
        notLoadedFragmentNode.eAdapters().add((Object)this);
        notLoadedFragmentNode.getChildren().add((Object)node);
        return notLoadedFragmentNode;
    }

    private Collection<TreeNode> encapsulateNotLoadedFragmentNodes(Collection<TreeNode> nodes) {
        ArrayList newNodes = Lists.newArrayList(nodes);
        ArrayList fragmentNodes = Lists.newArrayList();
        TreeNode notLoadedFragmentNode = TreeFactory.eINSTANCE.createTreeNode();
        ArrayList<Match> matches = new ArrayList<Match>();
        for (TreeNode node : nodes) {
            EObject data = (EObject)TREE_NODE_DATA.apply((Object)node);
            if (!(data instanceof NotLoadedFragmentMatch)) continue;
            matches.add((Match)data);
            ((NotLoadedFragmentMatch)data).setName(ResourceUIUtil.getResourceName((NotLoadedFragmentMatch)data));
            newNodes.remove(node);
            fragmentNodes.add(node);
        }
        NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(matches);
        notLoadedFragmentNode.setData((EObject)notLoadedFragmentMatch);
        notLoadedFragmentNode.eAdapters().add((Object)this);
        notLoadedFragmentNode.getChildren().addAll((Collection)fragmentNodes);
        newNodes.add(notLoadedFragmentNode);
        return newNodes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ChildrenSide {
        BOTH,
        LEFT,
        RIGHT;


        public static ChildrenSide getValueFrom(DifferenceSource source) {
            switch (source) {
                case LEFT: {
                    return LEFT;
                }
                case RIGHT: {
                    return RIGHT;
                }
            }
            return BOTH;
        }
    }
}

