/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.conflict;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ConflictSearchFactory;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class MatchBasedConflictDetector
implements IConflictDetector {
    private static final Logger LOGGER = Logger.getLogger(MatchBasedConflictDetector.class);
    private static final Predicate<? super Conflict> IS_REAL_CONTAINMENT_ADD_CONFLICT = new Predicate<Conflict>(){

        public boolean apply(Conflict input) {
            Iterable containmentRefs;
            boolean isRealAddContainmentConflict = false;
            if (input != null && input.getKind() == ConflictKind.REAL && !Iterables.isEmpty((Iterable)(containmentRefs = Iterables.filter(input.getDifferences(), EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE)))) {
                for (Diff diff : containmentRefs) {
                    if (diff.getKind() == DifferenceKind.ADD) continue;
                    return false;
                }
                isRealAddContainmentConflict = true;
            }
            return isRealAddContainmentConflict;
        }
    };

    public void detect(Comparison comparison, Monitor monitor) {
        long start = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"detect conflicts - START");
        }
        EList<Diff> differences = comparison.getDifferences();
        int diffCount = differences.size();
        ConflictSearchFactory conflictSearchFactory = new ConflictSearchFactory(comparison, monitor);
        int i = 0;
        while (i < diffCount) {
            if (i % 100 == 0) {
                monitor.subTask(EMFCompareMessages.getString("DefaultConflictDetector.monitor.detect", i + 1, diffCount));
            }
            if (monitor.isCanceled()) {
                throw new ComparisonCanceledException();
            }
            Diff diff = (Diff)differences.get(i);
            AbstractConflictSearch search = (AbstractConflictSearch)conflictSearchFactory.doSwitch(diff);
            search.detectConflicts();
            ++i;
        }
        this.handlePseudoUnderRealAdd(comparison);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)String.format("detect conflicts - END - Took %d ms", System.currentTimeMillis() - start));
        }
    }

    private void handlePseudoUnderRealAdd(Comparison comparison) {
        for (Conflict realContainmentAdd : Iterables.filter(comparison.getConflicts(), IS_REAL_CONTAINMENT_ADD_CONFLICT)) {
            this.changeKindOfPseudoConflictsUnder(realContainmentAdd);
        }
    }

    private void changeKindOfPseudoConflictsUnder(Conflict conflict) {
        for (Diff diff : conflict.getDifferences()) {
            Match realConflictMatch = diff.getMatch();
            for (Match subMatch : realConflictMatch.getSubmatches()) {
                for (Diff conflictDiffUnder : Iterables.filter(subMatch.getDifferences(), EMFComparePredicates.hasConflict(ConflictKind.PSEUDO))) {
                    Conflict conflictUnder = conflictDiffUnder.getConflict();
                    conflictUnder.setKind(ConflictKind.REAL);
                    this.changeKindOfPseudoConflictsUnder(conflictUnder);
                }
            }
        }
    }
}

