/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.unit;

import java.util.ArrayList;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.tests.unit.AbstractCompareTest;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceChangeTest
extends AbstractCompareTest {
    @Test
    public void testRequires() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Requires();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff requiresValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRequires = new ArrayList<Diff>(1);
        listRequires.add(requiresValue);
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.getRequires().isEmpty());
        referenceChange.getRequires().add((Object)requiresValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRequires().contains((Object)requiresValue));
        Assert.assertSame((Object)referenceChange.getRequires(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRequires(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiresValue.getRequiredBy().contains((Object)referenceChange));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRequires().isEmpty());
        Assert.assertSame((Object)referenceChange.getRequires(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRequires(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)requiresValue.getRequiredBy().contains((Object)referenceChange));
        referenceChange.eSet((EStructuralFeature)feature, listRequires);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRequires().contains((Object)requiresValue));
        Assert.assertSame((Object)referenceChange.getRequires(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRequires(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiresValue.getRequiredBy().contains((Object)referenceChange));
    }

    @Test
    public void testRequiredBy() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_RequiredBy();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff requiredByValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRequiredBy = new ArrayList<Diff>(1);
        listRequiredBy.add(requiredByValue);
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.getRequiredBy().isEmpty());
        referenceChange.getRequiredBy().add((Object)requiredByValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRequiredBy().contains((Object)requiredByValue));
        Assert.assertSame((Object)referenceChange.getRequiredBy(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRequiredBy(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiredByValue.getRequires().contains((Object)referenceChange));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRequiredBy().isEmpty());
        Assert.assertSame((Object)referenceChange.getRequiredBy(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRequiredBy(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)requiredByValue.getRequires().contains((Object)referenceChange));
        referenceChange.eSet((EStructuralFeature)feature, listRequiredBy);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRequiredBy().contains((Object)requiredByValue));
        Assert.assertSame((Object)referenceChange.getRequiredBy(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRequiredBy(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)requiredByValue.getRequires().contains((Object)referenceChange));
    }

    @Test
    public void testRefines() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Refines();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff refinesValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRefines = new ArrayList<Diff>(1);
        listRefines.add(refinesValue);
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.getRefines().isEmpty());
        referenceChange.getRefines().add((Object)refinesValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRefines().contains((Object)refinesValue));
        Assert.assertSame((Object)referenceChange.getRefines(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRefines(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinesValue.getRefinedBy().contains((Object)referenceChange));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRefines().isEmpty());
        Assert.assertSame((Object)referenceChange.getRefines(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRefines(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)refinesValue.getRefinedBy().contains((Object)referenceChange));
        referenceChange.eSet((EStructuralFeature)feature, listRefines);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRefines().contains((Object)refinesValue));
        Assert.assertSame((Object)referenceChange.getRefines(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRefines(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinesValue.getRefinedBy().contains((Object)referenceChange));
    }

    @Test
    public void testRefinedBy() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_RefinedBy();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Diff refinedByValue = CompareFactory.eINSTANCE.createDiff();
        ArrayList<Diff> listRefinedBy = new ArrayList<Diff>(1);
        listRefinedBy.add(refinedByValue);
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.getRefinedBy().isEmpty());
        referenceChange.getRefinedBy().add((Object)refinedByValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRefinedBy().contains((Object)refinedByValue));
        Assert.assertSame((Object)referenceChange.getRefinedBy(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRefinedBy(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinedByValue.getRefines().contains((Object)referenceChange));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRefinedBy().isEmpty());
        Assert.assertSame((Object)referenceChange.getRefinedBy(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRefinedBy(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)refinedByValue.getRefines().contains((Object)referenceChange));
        referenceChange.eSet((EStructuralFeature)feature, listRefinedBy);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertTrue((boolean)referenceChange.getRefinedBy().contains((Object)refinedByValue));
        Assert.assertSame((Object)referenceChange.getRefinedBy(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getRefinedBy(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)refinedByValue.getRefines().contains((Object)referenceChange));
    }

    @Test
    public void testMatch() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Match();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Match matchValue = CompareFactory.eINSTANCE.createMatch();
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)referenceChange.getMatch());
        referenceChange.setMatch(matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)referenceChange.getMatch());
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)referenceChange));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getMatch());
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)matchValue.getDifferences().contains((Object)referenceChange));
        referenceChange.setMatch(matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)referenceChange.getMatch());
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)referenceChange));
        referenceChange.eSet((EStructuralFeature)feature, (Object)matchValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)matchValue, (Object)referenceChange.getMatch());
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)matchValue.getDifferences().contains((Object)referenceChange));
        referenceChange.setMatch(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getMatch());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)referenceChange.getMatch());
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getMatch(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)matchValue.getDifferences().contains((Object)referenceChange));
    }

    @Test
    public void testEquivalence() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Equivalence();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Equivalence equivalenceValue = CompareFactory.eINSTANCE.createEquivalence();
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)referenceChange.getEquivalence());
        referenceChange.setEquivalence(equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)referenceChange.getEquivalence());
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)referenceChange));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getEquivalence());
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)equivalenceValue.getDifferences().contains((Object)referenceChange));
        referenceChange.setEquivalence(equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)referenceChange.getEquivalence());
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)referenceChange));
        referenceChange.eSet((EStructuralFeature)feature, (Object)equivalenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)equivalenceValue, (Object)referenceChange.getEquivalence());
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)equivalenceValue.getDifferences().contains((Object)referenceChange));
        referenceChange.setEquivalence(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getEquivalence());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)referenceChange.getEquivalence());
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getEquivalence(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)equivalenceValue.getDifferences().contains((Object)referenceChange));
    }

    @Test
    public void testConflict() {
        EReference feature = ComparePackage.eINSTANCE.getDiff_Conflict();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        Conflict conflictValue = CompareFactory.eINSTANCE.createConflict();
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)referenceChange.getConflict());
        referenceChange.setConflict(conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)referenceChange.getConflict());
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)referenceChange));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getConflict());
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflictValue.getDifferences().contains((Object)referenceChange));
        referenceChange.setConflict(conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)referenceChange.getConflict());
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)referenceChange));
        referenceChange.eSet((EStructuralFeature)feature, (Object)conflictValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)conflictValue, (Object)referenceChange.getConflict());
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)conflictValue.getDifferences().contains((Object)referenceChange));
        referenceChange.setConflict(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getConflict());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)referenceChange.getConflict());
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getConflict(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)conflictValue.getDifferences().contains((Object)referenceChange));
    }

    @Test
    public void testReference() {
        EReference feature = ComparePackage.eINSTANCE.getReferenceChange_Reference();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        EReference referenceValue = EcoreFactory.eINSTANCE.createEReference();
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)referenceChange.getReference());
        referenceChange.setReference(referenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)referenceValue, (Object)referenceChange.getReference());
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getReference());
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.setReference(referenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)referenceValue, (Object)referenceChange.getReference());
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eSet((EStructuralFeature)feature, (Object)referenceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)referenceValue, (Object)referenceChange.getReference());
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.setReference(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getReference());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)referenceChange.getReference());
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getReference(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testValue() {
        EReference feature = ComparePackage.eINSTANCE.getReferenceChange_Value();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        EObject valueValue = EcoreFactory.eINSTANCE.createEObject();
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertNull((Object)referenceChange.getValue());
        referenceChange.setValue(valueValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)valueValue, (Object)referenceChange.getValue());
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getValue());
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.setValue(valueValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)valueValue, (Object)referenceChange.getValue());
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eSet((EStructuralFeature)feature, (Object)valueValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertSame((Object)valueValue, (Object)referenceChange.getValue());
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.setValue(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertNull((Object)referenceChange.getValue());
        Assert.assertSame((Object)feature.getDefaultValue(), (Object)referenceChange.getValue());
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertSame((Object)referenceChange.getValue(), (Object)referenceChange.eGet((EStructuralFeature)feature, false));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testKind() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_Kind();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceKind kindValue = (DifferenceKind)feature.getDefaultValue();
        for (DifferenceKind aDifferenceKind : DifferenceKind.VALUES) {
            if (kindValue.getValue() == aDifferenceKind.getValue()) continue;
            kindValue = aDifferenceKind;
            break;
        }
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getKind());
        referenceChange.setKind(kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)referenceChange.getKind());
        Assert.assertEquals((Object)referenceChange.getKind(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getKind());
        Assert.assertEquals((Object)referenceChange.getKind(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eSet((EStructuralFeature)feature, (Object)kindValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)kindValue, (Object)referenceChange.getKind());
        Assert.assertEquals((Object)referenceChange.getKind(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.setKind(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getKind());
        Assert.assertEquals((Object)referenceChange.getKind(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testSource() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_Source();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceSource sourceValue = (DifferenceSource)feature.getDefaultValue();
        for (DifferenceSource aDifferenceSource : DifferenceSource.VALUES) {
            if (sourceValue.getValue() == aDifferenceSource.getValue()) continue;
            sourceValue = aDifferenceSource;
            break;
        }
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getSource());
        referenceChange.setSource(sourceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)sourceValue, (Object)referenceChange.getSource());
        Assert.assertEquals((Object)referenceChange.getSource(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getSource());
        Assert.assertEquals((Object)referenceChange.getSource(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eSet((EStructuralFeature)feature, (Object)sourceValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)sourceValue, (Object)referenceChange.getSource());
        Assert.assertEquals((Object)referenceChange.getSource(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.setSource(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getSource());
        Assert.assertEquals((Object)referenceChange.getSource(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
    }

    @Test
    public void testState() {
        EAttribute feature = ComparePackage.eINSTANCE.getDiff_State();
        ReferenceChange referenceChange = CompareFactory.eINSTANCE.createReferenceChange();
        referenceChange.eAdapters().add((Object)new AbstractCompareTest.MockEAdapter());
        DifferenceState stateValue = (DifferenceState)feature.getDefaultValue();
        for (DifferenceState aDifferenceState : DifferenceState.VALUES) {
            if (stateValue.getValue() == aDifferenceState.getValue()) continue;
            stateValue = aDifferenceState;
            break;
        }
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getState());
        referenceChange.setState(stateValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)stateValue, (Object)referenceChange.getState());
        Assert.assertEquals((Object)referenceChange.getState(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eUnset((EStructuralFeature)feature);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getState());
        Assert.assertEquals((Object)referenceChange.getState(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.eSet((EStructuralFeature)feature, (Object)stateValue);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)stateValue, (Object)referenceChange.getState());
        Assert.assertEquals((Object)referenceChange.getState(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertTrue((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
        referenceChange.setState(null);
        Assert.assertTrue((boolean)this.notified);
        this.notified = false;
        Assert.assertEquals((Object)feature.getDefaultValue(), (Object)referenceChange.getState());
        Assert.assertEquals((Object)referenceChange.getState(), (Object)referenceChange.eGet((EStructuralFeature)feature));
        Assert.assertFalse((boolean)referenceChange.eIsSet((EStructuralFeature)feature));
    }
}

