/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.sirius.internal.merge;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.merge.ComputeDiffsToMerge;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.ReferenceChangeMerger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiriusReferenceChangeMerger
extends ReferenceChangeMerger {
    public boolean isMergerFor(Diff target) {
        boolean result = false;
        if (target instanceof ReferenceChange) {
            EObject value = ((ReferenceChange)target).getValue();
            result = !(!(value instanceof DMappingBased) && !(value instanceof RepresentationElementMapping) || target.getImpliedBy().isEmpty() && target.getImplies().isEmpty());
        }
        return result;
    }

    protected void copyDiff(Diff target, Monitor monitor, boolean rightToLeft) {
        super.copyDiff(target, monitor, rightToLeft);
        Set impliedMerges = this.getImpliedMerges(target, rightToLeft);
        HashSet<Diff> impliedMappings = new HashSet<Diff>();
        while (!impliedMerges.isEmpty()) {
            EObject value;
            Diff impliedMerge = (Diff)impliedMerges.iterator().next();
            impliedMerges.addAll(this.getImpliedMerges(impliedMerge, rightToLeft));
            if (impliedMerge instanceof ReferenceChange && ((value = ((ReferenceChange)impliedMerge).getValue()) instanceof DMappingBased || value instanceof RepresentationElementMapping)) {
                impliedMerge.setState(DifferenceState.UNRESOLVED);
                impliedMappings.add(impliedMerge);
            }
            impliedMerges.remove(impliedMerge);
        }
        this.mergeImpliedMappings(impliedMappings, rightToLeft);
    }

    private void mergeImpliedMappings(Set<Diff> impliedMappings, boolean rightToLeft) {
        DiffRelationshipComputer relationshipComputer = new DiffRelationshipComputer(this.getRegistry());
        ComputeDiffsToMerge computer = new ComputeDiffsToMerge(rightToLeft, (IDiffRelationshipComputer)relationshipComputer);
        for (Diff impliedMapping : impliedMappings) {
            for (Diff toMerge : computer.getAllDiffsToMerge(impliedMapping)) {
                if (SiriusReferenceChangeMerger.isInTerminalState((Diff)toMerge)) continue;
                this.mergeDiff(toMerge, rightToLeft, null);
            }
        }
    }
}

