/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.utils.EMFCompareJavaPredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceAttachmentChangeConflictSearch {

    public static class Add
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Add(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Match match = ((ResourceAttachmentChange)this.diff).getMatch();
            EObject value = this.getValue((ResourceAttachmentChange)this.diff);
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            Iterable candidates = refChanges.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff))::iterator;
            for (ReferenceChange candidate : candidates) {
                if (candidate.getReference().isContainment()) {
                    if (candidate.getValue().eContainer() != null) continue;
                    this.conflict(candidate, ConflictKind.REAL);
                    continue;
                }
                if (value.eContainer() != null || candidate.getKind() == DifferenceKind.DELETE) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
            EList<Diff> diffsInSameMatch = ((ResourceAttachmentChange)this.diff).getMatch().getDifferences();
            Iterable racCandidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ResourceAttachmentChange.class::isInstance))::iterator;
            for (Diff candidate : racCandidates) {
                ConflictKind kind = ConflictKind.REAL;
                if (candidate.getKind() == DifferenceKind.ADD) {
                    Resource candidateRes;
                    Resource diffRes;
                    if (((ResourceAttachmentChange)this.diff).getSource() == DifferenceSource.LEFT) {
                        diffRes = match.getLeft().eResource();
                        candidateRes = match.getRight().eResource();
                    } else {
                        diffRes = match.getRight().eResource();
                        candidateRes = match.getLeft().eResource();
                    }
                    if (this.getMatchResource(diffRes) == this.getMatchResource(candidateRes)) {
                        kind = ConflictKind.PSEUDO;
                    }
                }
                this.conflict(candidate, kind);
            }
        }
    }

    public static class Change
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Change(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            throw new IllegalStateException("ResourceAttachmentChanges of type CHANGE should not exist.");
        }
    }

    public static class Delete
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Delete(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Match match = ((ResourceAttachmentChange)this.diff).getMatch();
            EObject value = this.getRelatedModelElement((ResourceAttachmentChange)this.diff);
            if (value != null) {
                Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
                Iterable candidates = refChanges.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff))::iterator;
                for (ReferenceChange candidate2 : candidates) {
                    if (candidate2.getReference().isContainment()) {
                        this.conflict(candidate2, ConflictKind.REAL);
                        continue;
                    }
                    if (value.eContainer() != null || candidate2.getKind() == DifferenceKind.DELETE) continue;
                    this.conflict(candidate2, ConflictKind.REAL);
                }
            }
            EList<Diff> diffsInSameMatch = ((ResourceAttachmentChange)this.diff).getMatch().getDifferences();
            Iterable racCandidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ResourceAttachmentChange.class::isInstance))::iterator;
            for (Diff candidate3 : racCandidates) {
                ConflictKind kind = ConflictKind.REAL;
                if (candidate3.getKind() == DifferenceKind.DELETE) {
                    Resource diffRes = match.getOrigin().eResource();
                    Resource candidateRes = match.getOrigin().eResource();
                    if (this.getMatchResource(diffRes) == this.getMatchResource(candidateRes)) {
                        kind = ConflictKind.PSEUDO;
                    }
                }
                this.conflict(candidate3, kind);
            }
            if (this.isDanglingRootDeletion() && (((ResourceAttachmentChange)this.diff).getConflict() == null || ((ResourceAttachmentChange)this.diff).getConflict().getKind() != ConflictKind.PSEUDO)) {
                match.getDifferences().stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff)).filter(d -> !ComparisonUtil.isDeleteOrUnsetDiff(d)).forEach(candidate -> this.conflict((Diff)candidate, ConflictKind.REAL));
            }
        }

        protected boolean isDanglingRootDeletion() {
            EObject o = this.getRelatedModelElement((ResourceAttachmentChange)this.diff);
            if (o != null) {
                return false;
            }
            EObject ancestorRoot = ((ResourceAttachmentChange)this.diff).getMatch().getOrigin();
            return ancestorRoot.eContainer() == null;
        }
    }

    public static class Move
    extends AbstractConflictSearch<ResourceAttachmentChange> {
        public Move(ResourceAttachmentChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EObject value = this.getRelatedModelElement((ResourceAttachmentChange)this.diff);
            Collection<ReferenceChange> refChanges = this.index.getReferenceChangesByValue(value);
            refChanges.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff)).filter(candidate -> candidate.getReference().isContainment()).forEach(candidate -> this.conflict((Diff)candidate, ConflictKind.REAL));
            EList<Diff> diffsInSameMatch = ((ResourceAttachmentChange)this.diff).getMatch().getDifferences();
            Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(ResourceAttachmentChange.class::isInstance))::iterator;
            for (Diff candidate2 : candidates) {
                String rhsURI;
                String lhsURI;
                ConflictKind kind = ConflictKind.REAL;
                if (candidate2.getKind() == DifferenceKind.MOVE && (lhsURI = ((ResourceAttachmentChange)this.diff).getResourceURI()).equals(rhsURI = ((ResourceAttachmentChange)candidate2).getResourceURI())) {
                    kind = ConflictKind.PSEUDO;
                }
                this.conflict(candidate2, kind);
            }
        }
    }
}

