/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.filters;

import com.google.common.base.Predicates;
import java.io.IOException;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchResourceNode;
import org.eclipse.emf.compare.rcp.ui.tests.structuremergeviewer.groups.provider.AbstractTestTreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.tests.edit.data.ResourceScopeProvider;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreePackage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CascadingDiffFilterTest {
    private Comparison comp;
    private CascadingDifferencesFilter filter;
    private TestECrossReferenceAdapter crossReferenceAdapter;

    @Test
    public void testWithoutRefiningDiffs() {
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(this.comp, Predicates.alwaysTrue(), (ECrossReferenceAdapter)this.crossReferenceAdapter);
        group.buildSubTree();
        Assert.assertEquals((long)2L, (long)group.getChildren().size());
        MatchNode rootNode = (MatchNode)group.getChildren().get(0);
        Assert.assertTrue((boolean)(group.getChildren().get(1) instanceof MatchResourceNode));
        Assert.assertEquals((long)1L, (long)rootNode.getChildren().size());
        MatchNode cNode = (MatchNode)rootNode.getChildren().get(0);
        Assert.assertEquals((long)2L, (long)cNode.getChildren().size());
        DiffNode addClassNode = (DiffNode)cNode.getChildren().get(0);
        Assert.assertFalse((boolean)this.filter.getPredicateWhenSelected().apply((Object)addClassNode));
        Assert.assertFalse((boolean)this.filter.getPredicateWhenUnselected().apply((Object)addClassNode));
        MatchNode attNode = (MatchNode)cNode.getChildren().get(1);
        Assert.assertEquals((long)1L, (long)attNode.getChildren().size());
        DiffNode addAttNode = (DiffNode)attNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.filter.getPredicateWhenSelected().apply((Object)addAttNode));
        Assert.assertFalse((boolean)this.filter.getPredicateWhenUnselected().apply((Object)addAttNode));
    }

    @Test
    public void testWithRealConflictRefiningDiffs() {
        Match rootMatch = (Match)this.comp.getMatches().get(0);
        Match cMatch = (Match)rootMatch.getSubmatches().get(0);
        Match attMatch = (Match)cMatch.getSubmatches().get(0);
        Diff attAddition = (Diff)cMatch.getDifferences().get(0);
        this.createRefinedDiff(attMatch, attAddition);
        this.createConflict(attAddition, ConflictKind.REAL);
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(this.comp, Predicates.alwaysTrue(), (ECrossReferenceAdapter)this.crossReferenceAdapter);
        group.buildSubTree();
        Assert.assertEquals((long)2L, (long)group.getChildren().size());
        MatchNode rootNode = (MatchNode)group.getChildren().get(0);
        Assert.assertTrue((boolean)(group.getChildren().get(1) instanceof MatchResourceNode));
        Assert.assertEquals((long)1L, (long)rootNode.getChildren().size());
        MatchNode cNode = (MatchNode)rootNode.getChildren().get(0);
        Assert.assertEquals((long)2L, (long)cNode.getChildren().size());
        DiffNode addClassNode = (DiffNode)cNode.getChildren().get(0);
        Assert.assertFalse((boolean)this.filter.getPredicateWhenSelected().apply((Object)addClassNode));
        Assert.assertFalse((boolean)this.filter.getPredicateWhenUnselected().apply((Object)addClassNode));
        MatchNode attNode = (MatchNode)cNode.getChildren().get(1);
        Assert.assertEquals((long)1L, (long)attNode.getChildren().size());
        DiffNode refinedDiffNode = (DiffNode)attNode.getChildren().get(0);
        Assert.assertFalse((boolean)this.filter.getPredicateWhenSelected().apply((Object)refinedDiffNode));
        Assert.assertFalse((boolean)this.filter.getPredicateWhenUnselected().apply((Object)refinedDiffNode));
        Assert.assertEquals((long)1L, (long)refinedDiffNode.getChildren().size());
    }

    @Test
    public void testWithPseudoConflictRefiningDiffs() {
        Match rootMatch = (Match)this.comp.getMatches().get(0);
        Match cMatch = (Match)rootMatch.getSubmatches().get(0);
        Match attMatch = (Match)cMatch.getSubmatches().get(0);
        Diff attAddition = (Diff)cMatch.getDifferences().get(0);
        this.createRefinedDiff(attMatch, attAddition);
        this.createConflict(attAddition, ConflictKind.PSEUDO);
        BasicDifferenceGroupImpl group = new BasicDifferenceGroupImpl(this.comp, Predicates.alwaysTrue(), (ECrossReferenceAdapter)this.crossReferenceAdapter);
        group.buildSubTree();
        Assert.assertEquals((long)2L, (long)group.getChildren().size());
        MatchNode rootNode = (MatchNode)group.getChildren().get(0);
        Assert.assertTrue((boolean)(group.getChildren().get(1) instanceof MatchResourceNode));
        Assert.assertEquals((long)1L, (long)rootNode.getChildren().size());
        MatchNode cNode = (MatchNode)rootNode.getChildren().get(0);
        Assert.assertEquals((long)2L, (long)cNode.getChildren().size());
        DiffNode addClassNode = (DiffNode)cNode.getChildren().get(0);
        Assert.assertFalse((boolean)this.filter.getPredicateWhenSelected().apply((Object)addClassNode));
        Assert.assertFalse((boolean)this.filter.getPredicateWhenUnselected().apply((Object)addClassNode));
        MatchNode attNode = (MatchNode)cNode.getChildren().get(1);
        Assert.assertEquals((long)1L, (long)attNode.getChildren().size());
        DiffNode refinedDiffNode = (DiffNode)attNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.filter.getPredicateWhenSelected().apply((Object)refinedDiffNode));
        Assert.assertFalse((boolean)this.filter.getPredicateWhenUnselected().apply((Object)refinedDiffNode));
        Assert.assertEquals((long)1L, (long)refinedDiffNode.getChildren().size());
    }

    protected void createConflict(Diff attAddition, ConflictKind kind) {
        Conflict conflict = CompareFactory.eINSTANCE.createConflict();
        conflict.setKind(kind);
        conflict.getDifferences().add((Object)attAddition);
        this.comp.getConflicts().add((Object)conflict);
    }

    protected void createRefinedDiff(Match attMatch, Diff attAddition) {
        Diff refinedDiff = CompareFactory.eINSTANCE.createDiff();
        refinedDiff.getRefinedBy().add((Object)attAddition);
        attMatch.getDifferences().add((Object)refinedDiff);
    }

    @Before
    public void setUp() throws Exception {
        this.comp = AbstractTestTreeNodeItemProviderAdapter.getComparison(new CascadingScope());
        this.crossReferenceAdapter = new TestECrossReferenceAdapter();
        this.filter = new CascadingDifferencesFilter();
    }

    public class CascadingScope
    extends AbstractInputData
    implements ResourceScopeProvider {
        public Resource getOrigin() throws IOException {
            return this.loadFromClassLoader("data/cascading/ancestor.ecore");
        }

        public Resource getLeft() throws IOException {
            return this.loadFromClassLoader("data/cascading/left.ecore");
        }

        public Resource getRight() throws IOException {
            return this.loadFromClassLoader("data/cascading/right.ecore");
        }
    }

    private class TestECrossReferenceAdapter
    extends ECrossReferenceAdapter {
        private TestECrossReferenceAdapter() {
        }

        protected boolean isIncluded(EReference eReference) {
            return eReference == TreePackage.Literals.TREE_NODE__DATA;
        }
    }
}

