/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.diff.data.nonuniquemultivaluedattribute.NonUniqueMultiValuedAttributeInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class NonUniqueMultiValuedAttributeTest {
    private NonUniqueMultiValuedAttributeInputData input = new NonUniqueMultiValuedAttributeInputData();

    @Test
    public void testNonUniqueMultiValuedAttributeCaseA3WayDiff() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseALeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseARight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseAOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff1 = (Diff)differences.get(0);
        Diff diff2 = (Diff)differences.get(1);
        Diff diff3 = (Diff)differences.get(2);
        Diff diff4 = (Diff)differences.get(3);
        Assert.assertTrue((boolean)(diff1 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff2 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff3 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff4 instanceof AttributeChange));
        Assert.assertEquals((Object)"3.03030303E-4", (Object)((AttributeChange)diff1).getValue());
        Assert.assertEquals((Object)"0.0", (Object)((AttributeChange)diff2).getValue());
        Assert.assertEquals((Object)"1.69714", (Object)((AttributeChange)diff3).getValue());
        Assert.assertEquals((Object)"5.985E-4", (Object)((AttributeChange)diff4).getValue());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff1.getKind());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff2.getKind());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)diff3.getKind());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)diff4.getKind());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff1.getSource());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff2.getSource());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff3.getSource());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff4.getSource());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseA2WayDiff() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseALeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseARight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff1 = (Diff)differences.get(0);
        Diff diff2 = (Diff)differences.get(1);
        Diff diff3 = (Diff)differences.get(2);
        Diff diff4 = (Diff)differences.get(3);
        Assert.assertTrue((boolean)(diff1 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff2 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff3 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff4 instanceof AttributeChange));
        Assert.assertEquals((Object)"1.69714", (Object)((AttributeChange)diff1).getValue());
        Assert.assertEquals((Object)"5.985E-4", (Object)((AttributeChange)diff2).getValue());
        Assert.assertEquals((Object)"3.03030303E-4", (Object)((AttributeChange)diff3).getValue());
        Assert.assertEquals((Object)"0.0", (Object)((AttributeChange)diff4).getValue());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff1.getKind());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff2.getKind());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)diff3.getKind());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)diff4.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff1.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff2.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff3.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff4.getSource());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseA3WayMergeRtL() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseALeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseARight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseAOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)8L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)4L, (long)comparison.getConflicts().size());
        for (Conflict c : comparison.getConflicts()) {
            Assert.assertEquals((long)2L, (long)c.getDifferences().size());
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)c.getKind());
        }
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseA2WayMergeRtL() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseALeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseARight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseA3WayMergeLtR() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseALeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseARight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseAOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseA2WayMergeLtR() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseALeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseARight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseB3WayDiff() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseBLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseBRight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseBOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff diff1 = (Diff)differences.get(0);
        Diff diff2 = (Diff)differences.get(1);
        Diff diff3 = (Diff)differences.get(2);
        Assert.assertTrue((boolean)(diff1 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff2 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff3 instanceof AttributeChange));
        Assert.assertEquals((Object)"a", (Object)((AttributeChange)diff1).getValue());
        Assert.assertEquals((Object)"a", (Object)((AttributeChange)diff2).getValue());
        Assert.assertEquals((Object)"b", (Object)((AttributeChange)diff3).getValue());
        Assert.assertEquals((Object)DifferenceKind.MOVE, (Object)diff1.getKind());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff2.getKind());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)diff3.getKind());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff1.getSource());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff2.getSource());
        Assert.assertEquals((Object)DifferenceSource.RIGHT, (Object)diff3.getSource());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseB2WayDiff() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseBLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseBRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Diff diff1 = (Diff)differences.get(0);
        Diff diff2 = (Diff)differences.get(1);
        Diff diff3 = (Diff)differences.get(2);
        Assert.assertTrue((boolean)(diff1 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff2 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff3 instanceof AttributeChange));
        Assert.assertEquals((Object)"b", (Object)((AttributeChange)diff1).getValue());
        Assert.assertEquals((Object)"d", (Object)((AttributeChange)diff2).getValue());
        Assert.assertEquals((Object)"a", (Object)((AttributeChange)diff3).getValue());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff1.getKind());
        Assert.assertEquals((Object)DifferenceKind.MOVE, (Object)diff2.getKind());
        Assert.assertEquals((Object)DifferenceKind.DELETE, (Object)diff3.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff1.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff2.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff3.getSource());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseB3WayMergeRtL() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseBLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseBRight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseBOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)6L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)3L, (long)comparison.getConflicts().size());
        for (Conflict c : comparison.getConflicts()) {
            Assert.assertEquals((long)2L, (long)c.getDifferences().size());
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)c.getKind());
        }
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseB2WayMergeRtL() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseBLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseBRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseB3WayMergeLtR() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseBLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseBRight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseBOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseB2WayMergeLtR() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseBLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseBRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseC3WayDiff() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseCLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseCRight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseCOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff1 = (Diff)differences.get(0);
        Diff diff2 = (Diff)differences.get(1);
        Diff diff3 = (Diff)differences.get(2);
        Diff diff4 = (Diff)differences.get(3);
        Assert.assertTrue((boolean)(diff1 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff2 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff3 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff4 instanceof AttributeChange));
        Assert.assertEquals((Object)"c", (Object)((AttributeChange)diff1).getValue());
        Assert.assertEquals((Object)"b", (Object)((AttributeChange)diff2).getValue());
        Assert.assertEquals((Object)"b", (Object)((AttributeChange)diff3).getValue());
        Assert.assertEquals((Object)"d", (Object)((AttributeChange)diff4).getValue());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff1.getKind());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff2.getKind());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff3.getKind());
        Assert.assertEquals((Object)DifferenceKind.MOVE, (Object)diff4.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff1.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff2.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff3.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff4.getSource());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseC2WayDiff() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseCLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseCRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        Diff diff1 = (Diff)differences.get(0);
        Diff diff2 = (Diff)differences.get(1);
        Diff diff3 = (Diff)differences.get(2);
        Diff diff4 = (Diff)differences.get(3);
        Assert.assertTrue((boolean)(diff1 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff2 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff3 instanceof AttributeChange));
        Assert.assertTrue((boolean)(diff4 instanceof AttributeChange));
        Assert.assertEquals((Object)"c", (Object)((AttributeChange)diff1).getValue());
        Assert.assertEquals((Object)"b", (Object)((AttributeChange)diff2).getValue());
        Assert.assertEquals((Object)"b", (Object)((AttributeChange)diff3).getValue());
        Assert.assertEquals((Object)"d", (Object)((AttributeChange)diff4).getValue());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff1.getKind());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff2.getKind());
        Assert.assertEquals((Object)DifferenceKind.ADD, (Object)diff3.getKind());
        Assert.assertEquals((Object)DifferenceKind.MOVE, (Object)diff4.getKind());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff1.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff2.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff3.getSource());
        Assert.assertEquals((Object)DifferenceSource.LEFT, (Object)diff4.getSource());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseC3WayMergeRtL() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseCLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseCRight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseCOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getDifferences().isEmpty());
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseC2WayMergeRtL() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseCLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseCRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyRightToLeft(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseC3WayMergeLtR() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseCLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseCRight();
        Resource origin = this.input.getNonUniqueMultiValuedAttributeCaseCOrigin();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)8L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)4L, (long)comparison.getConflicts().size());
        for (Conflict c : comparison.getConflicts()) {
            Assert.assertEquals((long)2L, (long)c.getDifferences().size());
            Assert.assertEquals((Object)ConflictKind.PSEUDO, (Object)c.getKind());
        }
    }

    @Test
    public void testNonUniqueMultiValuedAttributeCaseC2WayMergeLtR() throws IOException {
        Resource left = this.input.getNonUniqueMultiValuedAttributeCaseCLeft();
        Resource right = this.input.getNonUniqueMultiValuedAttributeCaseCRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertTrue((boolean)comparison.getConflicts().isEmpty());
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)4L, (long)differences.size());
        IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
        for (Diff diff : differences) {
            mergerRegistry.getHighestRankingMerger(diff).copyLeftToRight(diff, BasicMonitor.toMonitor((IProgressMonitor)new NullProgressMonitor()));
        }
        comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((long)0L, (long)comparison.getDifferences().size());
        Assert.assertEquals((long)0L, (long)comparison.getConflicts().size());
    }
}

