/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.egit.internal.merge.TreeWalkResourceVariantTreeProvider;
import org.eclipse.emf.compare.ide.ui.tests.merge.VariantsTestCase;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.team.core.variants.IResourceVariant;
import org.junit.Assert;
import org.junit.Test;

public class TreeWalkResourceVariantTreeProviderTest
extends VariantsTestCase {
    @Test
    public void testTreeWalkTrees() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1");
        File file2 = this.repository.createFile(this.iProject, "file2");
        this.repository.appendContentAndCommit(this.iProject, file1, "some content for the first file", "first file - initial commit");
        RevCommit baseCommit = this.repository.appendContentAndCommit(this.iProject, file2, "some content for the second file", "second file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        this.repository.createAndCheckoutBranch("refs/heads/master", "refs/heads/branch");
        String branchChanges = "branch changes\n";
        this.setContentsAndCommit(this.repository, iFile2, "branch changes\nsome content for the second file", "branch commit");
        this.repository.checkoutBranch("refs/heads/master");
        String masterChanges = "\nsome changes";
        this.setContentsAndCommit(this.repository, iFile1, "some content for the first file\nsome changes", "master commit");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        try (RevWalk walk = new RevWalk(this.repo);){
            RevTree baseTree = walk.parseTree((AnyObjectId)baseCommit.getId());
            RevTree sourceTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/master"));
            RevTree remoteTree = walk.parseTree((AnyObjectId)this.repo.resolve("refs/heads/branch"));
            NameConflictTreeWalk treeWalk = new NameConflictTreeWalk(this.repo);
            treeWalk.addTree((AnyObjectId)baseTree);
            treeWalk.addTree((AnyObjectId)sourceTree);
            treeWalk.addTree((AnyObjectId)remoteTree);
            TreeWalkResourceVariantTreeProvider treeProvider = new TreeWalkResourceVariantTreeProvider(this.repo, (TreeWalk)treeWalk, 0, 1, 2);
            Assert.assertEquals((long)1L, (long)treeProvider.getRoots().size());
            Assert.assertTrue((boolean)treeProvider.getRoots().contains(this.iProject));
            Assert.assertTrue((boolean)treeProvider.getKnownResources().contains(iFile1));
            Assert.assertTrue((boolean)treeProvider.getKnownResources().contains(iFile2));
            IResourceVariant file1BaseVariant = treeProvider.getBaseTree().getResourceVariant((IResource)iFile1);
            IResourceVariant file2BaseVariant = treeProvider.getBaseTree().getResourceVariant((IResource)iFile2);
            this.assertContentEquals(file1BaseVariant, "some content for the first file");
            this.assertContentEquals(file2BaseVariant, "some content for the second file");
            IResourceVariant file1TheirsVariant = treeProvider.getRemoteTree().getResourceVariant((IResource)iFile1);
            IResourceVariant file2TheirsVariant = treeProvider.getRemoteTree().getResourceVariant((IResource)iFile2);
            this.assertContentEquals(file1TheirsVariant, "some content for the first file");
            this.assertContentEquals(file2TheirsVariant, "branch changes\nsome content for the second file");
            IResourceVariant file1OursVariant = treeProvider.getSourceTree().getResourceVariant((IResource)iFile1);
            IResourceVariant file2OursVariant = treeProvider.getSourceTree().getResourceVariant((IResource)iFile2);
            this.assertContentEquals(file1OursVariant, "some content for the first file\nsome changes");
            this.assertContentEquals(file2OursVariant, "some content for the second file");
        }
    }
}

