/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.TreeNodeCompareInput;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class Navigatable
implements INavigatable {
    public static final int NEXT_UNRESOLVED_CHANGE = 80;
    private final WrappableTreeViewer viewer;
    private final EMFCompareStructureMergeViewerContentProvider contentProvider;
    protected EMFCompareStructureMergeViewerContentProvider.CallbackType uiSyncCallbackType = EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC;
    private Object cachedParent;
    private Object[] cachedChildren;

    public Navigatable(WrappableTreeViewer viewer, EMFCompareStructureMergeViewerContentProvider contentProvider) {
        this.viewer = viewer;
        this.contentProvider = contentProvider;
    }

    public boolean selectChange(final int flag) {
        this.contentProvider.runWhenReady(this.uiSyncCallbackType, new Runnable(){

            @Override
            public void run() {
                Object firstSelectedElement = Navigatable.this.getFirstSelectedItem();
                Object newSelection = Navigatable.this.calculateNextSelection(firstSelectedElement, flag);
                if (newSelection != null) {
                    Navigatable.this.fireOpen(newSelection);
                }
            }
        });
        return false;
    }

    private Object getFirstSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection.getFirstElement();
    }

    private Object calculateNextSelection(Object currentSelection, int flag) {
        switch (flag) {
            case 1: {
                return this.getNextDiff(this.thisOrFirstItem(currentSelection));
            }
            case 2: {
                return this.getPreviousDiff(this.thisOrFirstItem(currentSelection));
            }
            case 3: {
                return this.getNextDiff(this.getFirstItem());
            }
            case 4: {
                return this.getPreviousDiff(this.getFirstItem());
            }
            case 80: {
                return this.getNextUnresolvedDiff(this.thisOrFirstItem(currentSelection));
            }
        }
        throw new IllegalStateException();
    }

    private Object thisOrFirstItem(Object object) {
        if (object != null) {
            return object;
        }
        return this.getFirstItem();
    }

    public void fireOpen(Object element) {
        StructuredSelection newSelection = new StructuredSelection(element);
        this.viewer.setSelection((ISelection)newSelection);
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, (ISelection)newSelection));
    }

    public WrappableTreeViewer getViewer() {
        return this.viewer;
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    public boolean openSelectedChange() {
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        this.viewer.fireOpen(new OpenEvent((Viewer)this.viewer, selection));
        return true;
    }

    public boolean hasChange(int changeFlag) {
        Object firstSelectedItem = this.getFirstSelectedItem();
        switch (changeFlag) {
            case 1: {
                return this.getNextDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 2: {
                return this.getPreviousDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 80: {
                return this.getNextUnresolvedDiff(this.thisOrFirstItem(firstSelectedItem)) != null;
            }
            case 3: {
                Object firstItemInTree = this.getFirstItem();
                return firstItemInTree != null && this.getNextDiff(firstItemInTree) != null;
            }
        }
        throw new IllegalStateException();
    }

    private Object getNextDiff(Object start) {
        return this.getNextItemWithDiff(start, false);
    }

    private Object getPreviousDiff(Object start) {
        return this.getPreviousItemWithDiff(start);
    }

    private Object getNextUnresolvedDiff(Object start) {
        Object nextUnresolvedDiff = this.getNextItemWithDiff(start, true);
        if (nextUnresolvedDiff == null) {
            nextUnresolvedDiff = this.getNextItemWithDiff(this.getFirstItem(), true);
        }
        return nextUnresolvedDiff;
    }

    private Object getNextItemWithDiff(Object start, boolean onlyUnresolvedDiff) {
        Object item = this.getNextItem(start);
        while (item != null) {
            if (this.hasDiff(item, onlyUnresolvedDiff)) {
                return item;
            }
            item = this.getNextItem(item);
        }
        return null;
    }

    private Object getPreviousItemWithDiff(Object start) {
        Object item = this.getPreviousItem(start);
        while (item != null) {
            if (this.hasDiff(item, false)) {
                return item;
            }
            item = this.getPreviousItem(item);
        }
        return null;
    }

    private boolean hasDiff(Object item, boolean onlyUnresolved) {
        EObject data = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(item);
        if (data instanceof Diff) {
            Diff diff = (Diff)data;
            return !onlyUnresolved || diff.getState() == DifferenceState.UNRESOLVED;
        }
        return false;
    }

    private Object getFirstItem() {
        return this.viewer.getInput();
    }

    protected Object getNextItem(Object start) {
        Object[] children = this.getChildren(start);
        if (children.length > 0) {
            return children[0];
        }
        Object nextSibling = this.getNextSibling(start);
        if (nextSibling != null) {
            return nextSibling;
        }
        return this.getNextAncestor(start);
    }

    private Object getNextAncestor(Object item) {
        Object nextAncestor = null;
        Object ancestor = this.getAncestor(item);
        while (ancestor != null && nextAncestor == null) {
            nextAncestor = this.getNextSibling(ancestor);
            ancestor = this.getAncestor(ancestor);
        }
        return nextAncestor;
    }

    private Object getAncestor(Object item) {
        Object ancestor = this.viewer.getParentElement(item);
        if (ancestor != null) {
            return ancestor;
        }
        return Navigatable.getDifferenceGroup(item);
    }

    protected Object getPreviousItem(Object start) {
        Object previousSibling = this.getPreviousSibling(start);
        if (previousSibling != null) {
            return this.getLastDescendant(previousSibling);
        }
        Object parent = this.getAncestor(start);
        if (parent != null) {
            return parent;
        }
        return null;
    }

    private Object getLastDescendant(Object parent) {
        Object[] children = this.getChildren(parent);
        Object deepestChild = parent;
        while (children.length > 0) {
            deepestChild = children[children.length - 1];
            children = this.getChildren(deepestChild);
        }
        return deepestChild;
    }

    private Object[] getChildren(Object input) {
        if (input == this.cachedParent) {
            return this.cachedChildren;
        }
        this.cachedParent = input;
        this.cachedChildren = input instanceof IDifferenceGroup ? Navigatable.getChildren((IDifferenceGroup)input) : this.viewer.getFilteredChildren(input);
        return this.cachedChildren;
    }

    private Object getPreviousSibling(Object item) {
        Object[] siblings = this.getSiblings(item);
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == item) {
                if (--i >= 0) {
                    return siblings[i];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private Object getNextSibling(Object item) {
        Object[] siblings = this.getSiblings(item);
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == item) {
                if (++i < siblings.length) {
                    return siblings[i];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    private Object[] getSiblings(Object item) {
        Object parent = this.getAncestor(item);
        if (parent == null) {
            return new Object[]{item};
        }
        return this.getChildren(parent);
    }

    private static IDifferenceGroup getDifferenceGroup(Object item) {
        if (item instanceof TreeNodeCompareInput) {
            TreeNodeCompareInput treeNodeCompareInput = (TreeNodeCompareInput)((Object)item);
            Notifier target = treeNodeCompareInput.getTarget();
            IDifferenceGroup differenceGroup = (IDifferenceGroup)EcoreUtil.getExistingAdapter((Notifier)target, IDifferenceGroup.class);
            return differenceGroup;
        }
        return null;
    }

    private static Object[] getChildren(IDifferenceGroup differenceGroup) {
        if (differenceGroup == null) {
            return new Object[0];
        }
        ArrayList children = Lists.newArrayList();
        for (TreeNode child : differenceGroup.getChildren()) {
            for (Adapter adapter : child.eAdapters()) {
                if (!(adapter instanceof TreeNodeCompareInput)) continue;
                children.add(adapter);
            }
        }
        return children.toArray();
    }
}

