/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.logical.resolver;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CachingImplicitDependencies;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IImplicitDependencies;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class CachingImplicitDependenciesTest {
    @Test
    public void testCaching() {
        final URI uri1 = URI.createURI((String)"NoProject/File1.file");
        final HashSet uri1dependencies = Sets.newHashSet((Object[])new URI[]{URI.createURI((String)"NoProject/File1_Dependency1.file"), URI.createURI((String)"NoProject/File1_Dependency2.file"), URI.createURI((String)"NoProject/File1_Dependency3.file")});
        final URI uri2 = URI.createURI((String)"NoProject/File2.file");
        final HashSet uri2dependencies = Sets.newHashSet((Object[])new URI[]{URI.createURI((String)"NoProject/File2_Dependency1.file"), URI.createURI((String)"NoProject/File2_Dependency2.file")});
        IImplicitDependencies delegate = (IImplicitDependencies)Mockito.mock(IImplicitDependencies.class);
        Mockito.when((Object)delegate.of((URI)ArgumentMatchers.any(URI.class), (URIConverter)ArgumentMatchers.nullable(URIConverter.class))).then((Answer)new Answer<Set<URI>>(){

            public Set<URI> answer(InvocationOnMock invocation) throws Throwable {
                System.out.println("hey!");
                Object uriArgument = invocation.getArguments()[0];
                if (uriArgument.equals(uri1)) {
                    return Sets.newHashSet((Iterable)uri1dependencies);
                }
                if (uriArgument.equals(uri2)) {
                    return Sets.newHashSet((Iterable)uri2dependencies);
                }
                throw new IllegalArgumentException("This cannot happen.");
            }
        });
        CachingImplicitDependencies cachingDependencies = new CachingImplicitDependencies(delegate);
        Assert.assertEquals((Object)uri1dependencies, (Object)cachingDependencies.of(uri1, null));
        Assert.assertEquals((Object)uri2dependencies, (Object)cachingDependencies.of(uri2, null));
        ((IImplicitDependencies)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).of((URI)ArgumentMatchers.eq((Object)uri1), (URIConverter)ArgumentMatchers.nullable(URIConverter.class));
        ((IImplicitDependencies)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).of((URI)ArgumentMatchers.eq((Object)uri2), (URIConverter)ArgumentMatchers.nullable(URIConverter.class));
        Assert.assertEquals((Object)uri1dependencies, (Object)cachingDependencies.of(uri1, null));
        Assert.assertEquals((Object)uri2dependencies, (Object)cachingDependencies.of(uri2, null));
        Assert.assertEquals((Object)uri1dependencies, (Object)cachingDependencies.of(uri1, null));
        Assert.assertEquals((Object)uri2dependencies, (Object)cachingDependencies.of(uri2, null));
        Assert.assertEquals((Object)uri1dependencies, (Object)cachingDependencies.of(uri1, null));
        Assert.assertEquals((Object)uri2dependencies, (Object)cachingDependencies.of(uri2, null));
        Assert.assertEquals((Object)uri1dependencies, (Object)cachingDependencies.of(uri1, null));
        Assert.assertEquals((Object)uri2dependencies, (Object)cachingDependencies.of(uri2, null));
        ((IImplicitDependencies)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).of((URI)ArgumentMatchers.eq((Object)uri1), (URIConverter)ArgumentMatchers.nullable(URIConverter.class));
        ((IImplicitDependencies)Mockito.verify((Object)delegate, (VerificationMode)Mockito.times((int)1))).of((URI)ArgumentMatchers.eq((Object)uri2), (URIConverter)ArgumentMatchers.nullable(URIConverter.class));
    }
}

