/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.fallback.TextFallbackCompareInputData;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.team.internal.ui.mapping.AbstractCompareInput;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;

public final class TextFallbackCompareInput
extends AbstractCompareInput {
    private final TextFallbackCompareInputData textInputData;
    private final CompareInputChangeNotifier compareInputChangeNotifier = new CompareInputChangeNotifier(){

        protected IResource[] getResources(ICompareInput input) {
            return this.getResources();
        }

        public IResource[] getResources() {
            ArrayList resources = Lists.newArrayList();
            if (TextFallbackCompareInput.this.textInputData.getOriginStorage() instanceof IResource) {
                resources.add((IResource)TextFallbackCompareInput.this.textInputData.getOriginStorage());
            }
            if (TextFallbackCompareInput.this.textInputData.getLeftStorage() instanceof IResource) {
                resources.add((IResource)TextFallbackCompareInput.this.textInputData.getLeftStorage());
            }
            if (TextFallbackCompareInput.this.textInputData.getRightStorage() instanceof IResource) {
                resources.add((IResource)TextFallbackCompareInput.this.textInputData.getRightStorage());
            }
            return resources.toArray(new IResource[resources.size()]);
        }
    };

    public TextFallbackCompareInput(int kind, TextFallbackCompareInputData textInputData, boolean showPreview) {
        super(kind, TextFallbackCompareInput.getElement(textInputData.getOriginTypedElement(), textInputData.getOriginResource(), showPreview), TextFallbackCompareInput.getElement(textInputData.getLeftTypedElement(), textInputData.getLeftResource(), showPreview), TextFallbackCompareInput.getElement(textInputData.getRightTypedElement(), textInputData.getRightResource(), showPreview));
        this.textInputData = textInputData;
    }

    private static ITypedElement getElement(ITypedElement typedElement, Resource resource, boolean showPreview) {
        if (showPreview && typedElement instanceof LocalResourceTypedElement && resource instanceof XMLResource) {
            LocalResourceTypedElement localResourceTypedElement = (LocalResourceTypedElement)typedElement;
            IResource localResource = localResourceTypedElement.getResource();
            XMLResource xmlResource = (XMLResource)resource;
            EncodedStorage storage = new EncodedStorage(localResource, xmlResource);
            return new StorageTypedElement((IStorage)storage, localResource.getFullPath().toString());
        }
        return typedElement;
    }

    public void update() {
    }

    public boolean needsUpdate() {
        return false;
    }

    protected CompareInputChangeNotifier getChangeNotifier() {
        return this.compareInputChangeNotifier;
    }

    public TextFallbackCompareInputData getTextInputData() {
        return this.textInputData;
    }

    private static final class EncodedStorage
    implements IEncodedStorage {
        private final IResource localResource;
        private final XMLResource xmlResource;

        private EncodedStorage(IResource localResource, XMLResource xmlResource) {
            this.localResource = localResource;
            this.xmlResource = xmlResource;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public boolean isReadOnly() {
            return true;
        }

        public String getName() {
            return this.localResource.getName();
        }

        public IPath getFullPath() {
            return this.localResource.getFullPath();
        }

        public InputStream getContents() throws CoreException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this.xmlResource.save((OutputStream)byteArrayOutputStream, new LinkedHashMap());
            }
            catch (IOException e) {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }

        public String getCharset() throws CoreException {
            return this.xmlResource.getEncoding();
        }
    }
}

