/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;

class RemoteMappingStorageProvider
implements IStorageProvider {
    private final RemoteResourceMappingContext context;
    private final IStorageProviderAccessor.DiffSide side;
    private final IFile file;

    public RemoteMappingStorageProvider(RemoteResourceMappingContext context, IStorageProviderAccessor.DiffSide side, IFile file) {
        this.context = context;
        this.side = side;
        this.file = file;
    }

    @Override
    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        IFile storage;
        switch (this.side) {
            case SOURCE: {
                storage = this.file;
                break;
            }
            case REMOTE: {
                storage = this.context.fetchRemoteContents(this.file, monitor);
                break;
            }
            case ORIGIN: {
                storage = this.context.fetchBaseContents(this.file, monitor);
                break;
            }
            default: {
                storage = null;
            }
        }
        return storage;
    }
}

