/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.command;

import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.command.impl.CompareCommandStack;
import org.eclipse.emf.compare.tests.command.MockCompareCommand;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCompareSideCommandStack {
    private MockCompareCommand leftToRight1;
    private MockCompareCommand leftToRight2;
    private CompareCommandStack.CompareSideCommandStack commandStack;
    private MockCompareCommand leftToRight3;

    @Before
    public void before() {
        this.commandStack = new CompareCommandStack.CompareSideCommandStack();
        this.leftToRight1 = new MockCompareCommand(true);
        this.leftToRight2 = new MockCompareCommand(true);
        this.leftToRight3 = new MockCompareCommand(true);
    }

    @Test
    public void testInitState() {
        Assert.assertEquals(null, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedOnce() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedOnceUndo() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.undone();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.isSaveNeeded());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testExecutedOnceUndoTwice() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.undone();
        this.commandStack.undone();
    }

    @Test
    public void testExecutedOnceUndoRedo() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.undone();
        this.commandStack.redone();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedTwice() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedTwiceUndo() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.undone();
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedTwiceUndoTwice() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.undone();
        this.commandStack.undone();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getUndoCommand());
        Assert.assertFalse((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedTwiceUndoTwiceRedo() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.undone();
        this.commandStack.undone();
        this.commandStack.redone();
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedTwiceUndoTwiceRedoTwice() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.undone();
        this.commandStack.undone();
        this.commandStack.redone();
        this.commandStack.redone();
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight2, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }

    @Test
    public void testExecutedTwiceUndoExecuted() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.undone();
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight3);
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals(null, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testExecutedTwiceUndoExecutedRedo() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.undone();
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight3);
        this.commandStack.redone();
    }

    @Test
    public void testExecutedTwiceUndoExecutedUndo() {
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight1);
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight2);
        this.commandStack.undone();
        this.commandStack.executed((ICompareCopyCommand)this.leftToRight3);
        this.commandStack.undone();
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getMostRecentCommand());
        Assert.assertEquals((Object)this.leftToRight3, (Object)this.commandStack.getRedoCommand());
        Assert.assertEquals((Object)this.leftToRight1, (Object)this.commandStack.getUndoCommand());
        Assert.assertTrue((boolean)this.commandStack.isSaveNeeded());
    }
}

