/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.emf.compare.ide.ui.tests.models.ModelTestCase;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StrategyRecursiveModelTest
extends ModelTestCase {
    protected static final String MASTER = "refs/heads/master";
    protected static final String BRANCH = "refs/heads/branch";
    protected static final String INITIAL_CONTENT_FILE1 = "some content for the first file";
    protected static final String INITIAL_CONTENT_FILE2 = "some content for the second file";
    protected static final String SYSTEM_EOL = System.getProperty("line.separator");
    protected static final String BRANCH_CHANGE = "branch changes" + SYSTEM_EOL;
    protected static final String MASTER_CHANGE = "master changes" + SYSTEM_EOL;
    protected Repository repo;
    protected IProject iProject;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.iProject = this.project.getProject();
        this.repo = RepositoryMapping.getMapping((IProject)this.iProject).getRepository();
        try (Git git = new Git(this.repo);){
            git.commit().setAuthor("JUnit", "junit@jgit.org").setMessage("Initial commit").call();
        }
        InstanceScope.INSTANCE.getNode(Activator.getPluginId()).put("core_preferredMergeStrategy", "model recursive");
    }

    @After
    public void clearGitResources() throws Exception {
        this.repository.disconnect(this.iProject);
        this.repo = null;
        super.tearDown();
    }

    @Test
    public void mergeModelWithPseudoConflictDeletion() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        iFile2.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.repository.addAndCommit(this.iProject, "branch commit - deleted file2.sample", file2);
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, INITIAL_CONTENT_FILE1 + MASTER_CHANGE, "master commit");
        iFile2.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.repository.addAndCommit(this.iProject, "master commit - deleted file2.sample", file2);
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.assertContentEquals(iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1 + MASTER_CHANGE);
        Assert.assertFalse((boolean)iFile2.exists());
    }

    @Test
    public void mergeModelWithDeletedRemoteModelConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        String repoRelativePath1 = this.repository.getRepoRelativePath(iFile1.getLocation().toPortableString());
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        iFile2.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.repository.addAndCommit(this.iProject, "branch commit - deleted file2.sample", file2);
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1, "master commit");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertFalse((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath1));
        Assert.assertTrue((boolean)status.getRemoved().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1);
        Assert.assertFalse((boolean)iFile2.exists());
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.BOTH_MODIFIED, map.get(repoRelativePath1));
    }

    @Test
    public void mergeModelWithDeletedLocalModelConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        String repoRelativePath1 = this.repository.getRepoRelativePath(iFile1.getLocation().toPortableString());
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1, "master commit");
        iFile2.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.repository.addAndCommit(this.iProject, "master commit - deleted file2.sample", file2);
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertFalse((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath1));
        Assert.assertFalse((boolean)status.getConflicting().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1);
        Assert.assertFalse((boolean)iFile2.exists());
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.BOTH_MODIFIED, map.get(repoRelativePath1));
    }

    @Test
    public void mergeModelWithDeletedRemoteFileConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        String repoRelativePath1 = this.repository.getRepoRelativePath(iFile1.getLocation().toPortableString());
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        iFile2.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.repository.addAndCommit(this.iProject, "branch commit - deleted file2.sample", file2);
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, INITIAL_CONTENT_FILE1 + MASTER_CHANGE, "master commit - file1");
        this.setContentsAndCommit(this.repository, iFile2, INITIAL_CONTENT_FILE2 + MASTER_CHANGE, "master commit - file2");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getChanged().contains(repoRelativePath1));
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1 + MASTER_CHANGE);
        this.assertContentEquals(iFile2, INITIAL_CONTENT_FILE2 + MASTER_CHANGE);
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.DELETED_BY_THEM, map.get(repoRelativePath2));
    }

    @Test
    public void mergeModelWithDeletedLocalFileConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        String repoRelativePath1 = this.repository.getRepoRelativePath(iFile1.getLocation().toPortableString());
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        this.setContentsAndCommit(this.repository, iFile2, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE2, "branch commit");
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, INITIAL_CONTENT_FILE1 + MASTER_CHANGE, "master commit");
        iFile2.delete(true, (IProgressMonitor)new NullProgressMonitor());
        this.repository.addAndCommit(this.iProject, "master commit - deleted file2.sample", file2);
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertFalse((boolean)status.getConflicting().contains(repoRelativePath1));
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1 + MASTER_CHANGE);
        this.assertContentEquals(iFile2, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE2);
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.DELETED_BY_US, map.get(repoRelativePath2));
    }

    @Test
    public void mergeModelWithAddedRemoteNoConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit on branch");
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, INITIAL_CONTENT_FILE1 + MASTER_CHANGE, "master commit");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.assertContentEquals(iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1 + MASTER_CHANGE);
        this.assertContentEquals(iFile2, INITIAL_CONTENT_FILE2);
    }

    @Test
    public void mergeModelWithAddedLocalNoConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, INITIAL_CONTENT_FILE1 + MASTER_CHANGE, "master commit");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit on master");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().isEmpty());
        this.assertContentEquals(iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1 + MASTER_CHANGE);
        this.assertContentEquals(iFile2, INITIAL_CONTENT_FILE2);
    }

    @Test
    public void mergeModelWithPseudoConflictAddition() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit on branch");
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, INITIAL_CONTENT_FILE1 + MASTER_CHANGE, "master commit");
        file2 = this.repository.createFile(this.iProject, "file2.sample");
        iFile2 = this.repository.getIFile(this.iProject, file2);
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit on master");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1 + MASTER_CHANGE);
        this.assertContentEquals(iFile2, INITIAL_CONTENT_FILE2);
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.BOTH_ADDED, map.get(repoRelativePath2));
    }

    @Test
    public void mergeModelWithAddedRemoteModelConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        String repoRelativePath1 = this.repository.getRepoRelativePath(iFile1.getLocation().toPortableString());
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit - branch");
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1, "master commit");
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertFalse((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath1));
        Assert.assertTrue((boolean)status.getAdded().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1);
        this.assertContentEquals(iFile2, INITIAL_CONTENT_FILE2);
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.BOTH_MODIFIED, map.get(repoRelativePath1));
    }

    @Test
    public void mergeModelWithAddedLocalModelConflict() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        String repoRelativePath1 = this.repository.getRepoRelativePath(iFile1.getLocation().toPortableString());
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1, "master commit");
        this.repository.appendContentAndCommit(this.iProject, file2, INITIAL_CONTENT_FILE2, "second file - initial commit");
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertFalse((boolean)status.getConflicting().isEmpty());
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath1));
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(MASTER_CHANGE) + INITIAL_CONTENT_FILE1);
        this.assertContentEquals(iFile2, INITIAL_CONTENT_FILE2);
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.BOTH_MODIFIED, map.get(repoRelativePath1));
        Assert.assertEquals((Object)IndexDiff.StageState.ADDED_BY_US, map.get(repoRelativePath2));
    }

    @Test
    public void mergeModelWithConflictAddition() throws Exception {
        File file1 = this.repository.createFile(this.iProject, "file1.sample");
        File file2 = this.repository.createFile(this.iProject, "file2.sample");
        this.repository.appendContentAndCommit(this.iProject, file1, INITIAL_CONTENT_FILE1, "first file - initial commit");
        IFile iFile1 = this.repository.getIFile(this.iProject, file1);
        String repoRelativePath1 = this.repository.getRepoRelativePath(iFile1.getLocation().toPortableString());
        this.repository.createAndCheckoutBranch(MASTER, BRANCH);
        this.setContentsAndCommit(this.repository, iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1, "branch commit");
        this.repository.appendContentAndCommit(this.iProject, file2, "some content for the second filebranch", "second file - initial commit - branch");
        this.repository.checkoutBranch(MASTER);
        this.setContentsAndCommit(this.repository, iFile1, INITIAL_CONTENT_FILE1 + MASTER_CHANGE, "master commit - file1");
        this.repository.appendContentAndCommit(this.iProject, file2, "some content for the second filemaster", "second file - initial commit - master");
        IFile iFile2 = this.repository.getIFile(this.iProject, file2);
        String repoRelativePath2 = this.repository.getRepoRelativePath(iFile2.getLocation().toPortableString());
        this.iProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.merge(this.repo, BRANCH);
        Status status = this.status(this.repo);
        Assert.assertTrue((boolean)status.hasUncommittedChanges());
        Assert.assertTrue((boolean)status.getChanged().contains(repoRelativePath1));
        Assert.assertTrue((boolean)status.getConflicting().contains(repoRelativePath2));
        this.assertContentEquals(iFile1, String.valueOf(BRANCH_CHANGE) + INITIAL_CONTENT_FILE1 + MASTER_CHANGE);
        this.assertContentEquals(iFile2, "some content for the second filemaster");
        Map map = status.getConflictingStageState();
        Assert.assertEquals((Object)IndexDiff.StageState.BOTH_ADDED, map.get(repoRelativePath2));
    }
}

