/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.ILogicalModelViewHandler;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.registry.LogicalModelViewHandlerDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public final class LogicalModelViewHandlerRegistry {
    private final Map<String, LogicalModelViewHandlerDescriptor> registeredDescriptors = new LinkedHashMap<String, LogicalModelViewHandlerDescriptor>();

    public List<LogicalModelViewHandlerDescriptor> getRegisteredDescriptors() {
        return new ArrayList<LogicalModelViewHandlerDescriptor>(this.registeredDescriptors.values());
    }

    public ILogicalModelViewHandler getBestHandlerFor(IWorkbenchPart part, ISelection selection) {
        LogicalModelViewHandlerDescriptor handler = null;
        for (LogicalModelViewHandlerDescriptor candidate : this.registeredDescriptors.values()) {
            if (handler != null && handler.getRanking() >= candidate.getRanking() || !candidate.getHandler().canHandle(part, selection)) continue;
            handler = candidate;
        }
        if (handler != null) {
            return handler.getHandler();
        }
        return null;
    }

    void addHandler(String key, LogicalModelViewHandlerDescriptor descriptor) {
        this.registeredDescriptors.put(key, descriptor);
    }

    LogicalModelViewHandlerDescriptor removeHandler(String key) {
        return this.registeredDescriptors.remove(key);
    }

    public void clear() {
        Iterator<LogicalModelViewHandlerDescriptor> descriptors = this.registeredDescriptors.values().iterator();
        while (descriptors.hasNext()) {
            descriptors.next();
            descriptors.remove();
        }
    }
}

