/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.engine.GenericDiffEngine;
import org.eclipse.emf.compare.diff.engine.IDiffEngine;
import org.eclipse.emf.compare.diff.service.DiffEngineDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffEngineRegistry
extends HashMap<String, List<Object>> {
    public static final DiffEngineRegistry INSTANCE = new DiffEngineRegistry();
    private static final String ALL_EXTENSIONS = "*";
    private static final String DIFF_ENGINES_EXTENSION_POINT = "org.eclipse.emf.compare.diff.engine";
    private static final long serialVersionUID = 2237008034183610765L;
    private static final String TAG_ENGINE = "diffengine";

    private DiffEngineRegistry() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.parseExtensionMetadata();
        } else {
            this.putValue(ALL_EXTENSIONS, new GenericDiffEngine());
        }
    }

    public List<DiffEngineDescriptor> getDescriptors(String fileExtension) {
        List specific = (List)this.get(fileExtension);
        ArrayList candidates = new ArrayList((Collection)this.get(ALL_EXTENSIONS));
        if (specific != null) {
            candidates.addAll(0, specific);
        }
        ArrayList<DiffEngineDescriptor> engines = new ArrayList<DiffEngineDescriptor>(candidates.size());
        for (Object value : candidates) {
            if (!(value instanceof DiffEngineDescriptor)) continue;
            engines.add((DiffEngineDescriptor)value);
        }
        return engines;
    }

    public IDiffEngine getHighestEngine(String fileExtension) {
        DiffEngineDescriptor desc;
        List engines = (List)this.get(fileExtension);
        int highestPriority = -1;
        IDiffEngine highest = null;
        if (engines != null) {
            for (Object engine : engines) {
                if (engine instanceof DiffEngineDescriptor) {
                    desc = (DiffEngineDescriptor)engine;
                    if (desc.getPriorityValue() <= highestPriority) continue;
                    highest = desc.getEngineInstance();
                    highestPriority = desc.getPriorityValue();
                    continue;
                }
                if (!(engine instanceof IDiffEngine)) continue;
                highest = (IDiffEngine)engine;
                break;
            }
        }
        if (highest == null) {
            for (Object engine : (List)this.get(ALL_EXTENSIONS)) {
                if (engine instanceof DiffEngineDescriptor) {
                    desc = (DiffEngineDescriptor)engine;
                    if (desc.getPriorityValue() <= highestPriority) continue;
                    highest = desc.getEngineInstance();
                    highestPriority = desc.getPriorityValue();
                    continue;
                }
                if (!(engine instanceof IDiffEngine)) continue;
                highest = (IDiffEngine)engine;
                break;
            }
        }
        return highest;
    }

    public void putValue(String key, Object value) {
        if (value instanceof IDiffEngine || value instanceof DiffEngineDescriptor) {
            ArrayList<Object> values = (ArrayList<Object>)this.get(key);
            if (values != null) {
                values.add(value);
            } else {
                values = new ArrayList<Object>();
                values.add(value);
                super.put(key, values);
            }
        } else {
            throw new IllegalArgumentException(EMFCompareDiffMessages.getString("DiffEngineRegistry.IllegalEngine", value.getClass().getName()));
        }
    }

    private DiffEngineDescriptor parseEngine(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_ENGINE)) {
            return null;
        }
        DiffEngineDescriptor desc = new DiffEngineDescriptor(configElement);
        return desc;
    }

    private void parseExtensionMetadata() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(DIFF_ENGINES_EXTENSION_POINT).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                String[] fileExtensions;
                DiffEngineDescriptor desc = this.parseEngine(configElements[j]);
                String[] stringArray = fileExtensions = desc.getFileExtension().split(",");
                int n = fileExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    this.putValue(ext, desc);
                    ++n2;
                }
                ++j;
            }
            ++i;
        }
    }
}

