/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipse.genxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.teneo.eclipse.Messages;
import org.eclipse.emf.teneo.eclipse.StoreEclipseUtil;
import org.eclipse.emf.teneo.eclipse.genxml.RunGenerateJob;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenerateMappingAction
implements IObjectActionDelegate {
    private static Log log = LogFactory.getLog(GenerateMappingAction.class);
    private ArrayList<IFile> ecoreFiles = new ArrayList();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public abstract void run(IAction var1);

    public void run(IAction action, String targetFileName, String resultTitle1, HashMap<String, String> options, String mainClass) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.ecoreFiles.size()) {
            result.append(this.ecoreFiles.get(i).getLocation().toOSString());
            ++i;
        }
        if (this.ecoreFiles.size() == 0) {
            Shell shell = new Shell();
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString("teneo.create.or.mapping"), (String)Messages.getString("teneo.select.ecore.file"));
            return;
        }
        log.debug((Object)("Generating or descriptor file based on ecores in: " + result.toString()));
        try {
            IContainer container = this.ecoreFiles.get(0).getParent();
            String[] ecoreLocations = new String[this.ecoreFiles.size()];
            ArrayList<IJavaProject> jprojects = new ArrayList<IJavaProject>();
            ArrayList<IProject> projects = new ArrayList<IProject>();
            int i2 = 0;
            while (i2 < this.ecoreFiles.size()) {
                IFile ecoreFile = this.ecoreFiles.get(i2);
                ecoreLocations[i2] = ecoreFile.getLocation().toOSString();
                IProject project = ecoreFile.getProject();
                if (project != null && !projects.contains(project)) {
                    projects.add(project);
                    jprojects.add(JavaCore.create((IProject)project));
                }
                ++i2;
            }
            RunGenerateJob rgj = new RunGenerateJob(jprojects, ecoreLocations, targetFileName, mainClass, options);
            rgj.schedule();
            Shell shell = new Shell();
            MessageDialog.openInformation((Shell)shell, (String)resultTitle1, (String)(String.valueOf(Messages.getString("teneo.file.created")) + container.getName()));
            container.refreshLocal(2, null);
        }
        catch (Throwable t) {
            StoreEclipseUtil.handleError(t, log);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator it = structuredSelection.iterator();
        this.ecoreFiles = new ArrayList();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof IFile)) continue;
            this.ecoreFiles.add((IFile)obj);
        }
    }
}

