/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public abstract class CDOSingleValueFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOFeatureDelta {
    private int index;
    private Object newValue;

    public CDOSingleValueFeatureDeltaImpl(EStructuralFeature feature, int index, Object value) {
        super(feature);
        this.index = index;
        this.newValue = value;
    }

    public CDOSingleValueFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        this.index = in.readInt();
        EStructuralFeature feature = this.getFeature();
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            int featureID = in.readInt();
            feature = eClass.getEStructuralFeature(featureID);
            Object innerValue = in.readCDOFeatureValue(feature);
            this.newValue = CDORevisionUtil.createFeatureMapEntry(feature, innerValue);
        } else {
            this.newValue = in.readCDOFeatureValue(feature);
        }
    }

    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeInt(this.index);
        Object valueToWrite = this.newValue;
        EStructuralFeature feature = this.getFeature();
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            FeatureMap.Entry entry = (FeatureMap.Entry)valueToWrite;
            feature = entry.getEStructuralFeature();
            valueToWrite = entry.getValue();
            int featureID = eClass.getFeatureID(feature);
            out.writeInt(featureID);
        }
        if (valueToWrite != null && feature instanceof EReference) {
            valueToWrite = out.getIDProvider().provideCDOID(this.newValue);
        }
        out.writeCDOFeatureValue(feature, valueToWrite);
    }

    public int getIndex() {
        return this.index;
    }

    public Object getValue() {
        return this.newValue;
    }

    protected void setValue(Object value) {
        this.newValue = value;
    }

    public void adjustReferences(CDOReferenceAdjuster referenceAdjuster) {
        this.newValue = referenceAdjuster.adjustReference(this.newValue);
    }

    public void clear() {
        this.setValue(CDOID.NULL);
    }
}

