/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.analyzer.CDOFetchRule;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDObjectFactory;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadRevisionIndication
extends CDOReadIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadRevisionIndication.class);
    protected CDOID[] ids;
    protected int referenceChunk;
    protected Map<CDOClass, CDOFetchRule> fetchRules = new HashMap<CDOClass, CDOFetchRule>();
    protected CDOID contextID = CDOID.NULL;
    protected int loadRevisionCollectionChunkSize;

    protected short getSignalID() {
        return 7;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        this.referenceChunk = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read referenceChunk: {0}", new Object[]{this.referenceChunk});
        }
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Reading {0} IDs", new Object[]{size});
        }
        CDOIDObjectFactory factory = this.getStore().getCDOIDObjectFactory();
        this.ids = new CDOID[size];
        int i = 0;
        while (i < size) {
            CDOID id = CDOIDUtil.read((ExtendedDataInput)in, (CDOIDObjectFactory)factory);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Read ID: {0}", new Object[]{id});
            }
            this.ids[i] = id;
            ++i;
        }
        int fetchSize = in.readInt();
        if (fetchSize > 0) {
            this.loadRevisionCollectionChunkSize = in.readInt();
            if (this.loadRevisionCollectionChunkSize < 1) {
                this.loadRevisionCollectionChunkSize = 1;
            }
            this.contextID = CDOIDUtil.read((ExtendedDataInput)in, (CDOIDObjectFactory)factory);
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Reading fetch rules for context {0}", new Object[]{this.contextID});
            }
            int i2 = 0;
            while (i2 < fetchSize) {
                CDOFetchRule fetchRule = new CDOFetchRule((ExtendedDataInput)in, (CDOPackageManager)this.getPackageManager());
                this.fetchRules.put(fetchRule.getCDOClass(), fetchRule);
                ++i2;
            }
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        Session session = this.getSession();
        ArrayList<InternalCDORevision> additionalRevisions = new ArrayList<InternalCDORevision>();
        HashSet<CDOID> revisionIDs = new HashSet<CDOID>();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} revisions", new Object[]{this.ids.length});
        }
        CDOID[] cDOIDArray = this.ids;
        int n = this.ids.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID id = cDOIDArray[n2];
            revisionIDs.add(id);
            ++n2;
        }
        HashSet<CDOFetchRule> visitedFetchRules = new HashSet<CDOFetchRule>();
        if (!this.contextID.isNull() && this.fetchRules.size() > 0) {
            if (PROTOCOL.isEnabled()) {
                PROTOCOL.format("Collecting more revisions based on rules", new Object[0]);
            }
            InternalCDORevision revisionContext = this.getRevision(this.contextID);
            this.collectRevisions(revisionContext, revisionIDs, additionalRevisions, visitedFetchRules);
        }
        CDOID[] cDOIDArray2 = this.ids;
        int n3 = this.ids.length;
        n = 0;
        while (n < n3) {
            CDOID id = cDOIDArray2[n];
            InternalCDORevision revision = this.getRevision(id);
            revision.write((ExtendedDataOutput)out, (CDOIDProvider)session, this.referenceChunk);
            if (this.loadRevisionCollectionChunkSize > 0) {
                this.collectRevisions(revision, revisionIDs, additionalRevisions, visitedFetchRules);
            }
            ++n;
        }
        int additionalSize = additionalRevisions.size();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing {0} additional revisions", new Object[]{additionalSize});
        }
        out.writeInt(additionalSize);
        for (InternalCDORevision revision : additionalRevisions) {
            revision.write((ExtendedDataOutput)out, (CDOIDProvider)session, this.referenceChunk);
        }
    }

    protected InternalCDORevision getRevision(CDOID id) {
        RevisionManager revisionManager = this.getRevisionManager();
        return revisionManager.getRevision(id, this.referenceChunk);
    }

    private void collectRevisions(InternalCDORevision revision, Set<CDOID> revisions, List<InternalCDORevision> additionalRevisions, Set<CDOFetchRule> visitedFetchRules) {
        this.getSession().collectContainedRevisions(revision, this.referenceChunk, revisions, additionalRevisions);
        CDOFetchRule fetchRule = this.fetchRules.get(revision.getCDOClass());
        if (fetchRule == null || visitedFetchRules.contains(fetchRule)) {
            return;
        }
        visitedFetchRules.add(fetchRule);
        RevisionManager revisionManager = this.getSessionManager().getRepository().getRevisionManager();
        for (CDOFeature feature : fetchRule.getFeatures()) {
            CDOID id;
            if (feature.isMany()) {
                MoveableList list = revision.getList(feature);
                int toIndex = Math.min(this.loadRevisionCollectionChunkSize, list.size()) - 1;
                int i = 0;
                while (i <= toIndex) {
                    CDOID id2;
                    Object value = list.get(i);
                    if (value instanceof CDOID && !(id2 = (CDOID)value).isNull() && !revisions.contains(id2)) {
                        InternalCDORevision containedRevision = revisionManager.getRevision(id2, this.referenceChunk);
                        revisions.add(containedRevision.getID());
                        additionalRevisions.add(containedRevision);
                        this.collectRevisions(containedRevision, revisions, additionalRevisions, visitedFetchRules);
                    }
                    ++i;
                }
                continue;
            }
            Object value = revision.getValue(feature);
            if (!(value instanceof CDOID) || (id = (CDOID)value).isNull() || revisions.contains(id)) continue;
            InternalCDORevision containedRevision = revisionManager.getRevision(id, this.referenceChunk);
            revisions.add(containedRevision.getID());
            additionalRevisions.add(containedRevision);
            this.collectRevisions(containedRevision, revisions, additionalRevisions, visitedFetchRules);
        }
        visitedFetchRules.remove(fetchRule);
    }
}

