/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import org.eclipse.emf.cdo.CDOSession;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.dialogs.OpenSessionDialog;
import org.eclipse.emf.cdo.internal.ui.views.CDOSessionsView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public final class OpenSessionAction
extends LongRunningAction {
    private static final String TITLE = "Open Session";
    private static final String TOOL_TIP = "Open a new CDO session";
    private String description;

    public OpenSessionAction(IWorkbenchPage page) {
        super(page, "Open Session...", TOOL_TIP, CDOSessionsView.getAddImageDescriptor());
    }

    protected void preRun() throws Exception {
        OpenSessionDialog dialog = new OpenSessionDialog(this.getPage());
        if (dialog.open() == 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(dialog.getServerDescription());
            builder.append("?repositoryName=");
            builder.append(dialog.getRepositoryName());
            if (dialog.isAutomaticPackageRegistry()) {
                builder.append("&automaticPackageRegistry=true");
            }
            if (dialog.isLegacyModelSupport()) {
                builder.append("&legacySupportEnabled=true");
            }
            this.description = builder.toString();
        } else {
            this.cancel();
        }
    }

    protected void doRun() throws Exception {
        CDOSession session = null;
        try {
            String productGroup = "org.eclipse.emf.cdo.sessions";
            String type = "cdo";
            session = (CDOSession)IPluginContainer.INSTANCE.getElement(productGroup, type, this.description);
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
        }
        if (session == null) {
            try {
                this.getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            MessageDialog.openError((Shell)OpenSessionAction.this.getShell(), (String)OpenSessionAction.this.getText(), (String)("Unable to open a session on the specified repository.\n" + OpenSessionAction.this.description));
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                });
            }
            catch (RuntimeException runtimeException) {}
        }
    }
}

