/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.content.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.match.metamodel.UnmatchElement;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.ICompareEditorPartListener;
import org.eclipse.emf.compare.ui.ModelCompareInput;
import org.eclipse.emf.compare.ui.util.EMFCompareEObjectUtils;
import org.eclipse.emf.compare.ui.viewer.content.ModelContentMergeViewer;
import org.eclipse.emf.compare.ui.viewer.content.part.IModelContentMergeViewerTab;
import org.eclipse.emf.compare.ui.viewer.content.part.ModelContentMergeTabItem;
import org.eclipse.emf.compare.ui.viewer.content.part.diff.ModelContentMergeDiffTab;
import org.eclipse.emf.compare.ui.viewer.content.part.property.ModelContentMergePropertyTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelContentMergeTabFolder {
    protected final ModelContentMergeViewer parentViewer;
    protected final int partSide;
    protected IModelContentMergeViewerTab properties;
    protected CTabFolder tabFolder;
    protected final List<IModelContentMergeViewerTab> tabs = new ArrayList<IModelContentMergeViewerTab>();
    protected IModelContentMergeViewerTab tree;
    private final List<ICompareEditorPartListener> editorPartListeners = new ArrayList<ICompareEditorPartListener>();

    public ModelContentMergeTabFolder(ModelContentMergeViewer viewer, Composite composite, int side) {
        if (side != 2 && side != 1 && side != 3) {
            throw new IllegalArgumentException(EMFCompareUIMessages.getString("IllegalSide", side));
        }
        this.parentViewer = viewer;
        this.partSide = side;
        this.createContents(composite);
    }

    public void addCompareEditorPartListener(ICompareEditorPartListener listener) {
        this.editorPartListeners.add(listener);
    }

    public void dispose() {
        this.properties.dispose();
        this.tree.dispose();
        this.tabs.clear();
        this.tabFolder.dispose();
        this.editorPartListeners.clear();
    }

    public List<DiffElement> getDiffAsList() {
        if (this.parentViewer.getInput() != null) {
            return ((ModelCompareInput)this.parentViewer.getInput()).getDiffAsList();
        }
        return new ArrayList<DiffElement>();
    }

    public IModelContentMergeViewerTab getPropertyPart() {
        return this.properties;
    }

    public IModelContentMergeViewerTab getTreePart() {
        return this.tree;
    }

    public ModelContentMergeTabItem getUIItem(DiffElement element) {
        EObject data = this.partSide == 3 && element instanceof ConflictingDiffElement ? ((ConflictingDiffElement)element).getOriginElement() : (this.partSide == 1 ? EMFCompareEObjectUtils.getLeftElement((EObject)element) : EMFCompareEObjectUtils.getRightElement((EObject)element));
        Object featureData = element instanceof AttributeChange ? ((AttributeChange)element).getAttribute() : (element instanceof ReferenceChange ? ((ReferenceChange)element).getReference() : null);
        ModelContentMergeTabItem result = null;
        if (data != null) {
            result = this.tabs.get(this.tabFolder.getSelectionIndex()).getUIItem(data);
        }
        if (result == null && featureData != null) {
            result = this.tabs.get(this.tabFolder.getSelectionIndex()).getUIItem((EObject)featureData);
        }
        return result;
    }

    public List<ModelContentMergeTabItem> getVisibleElements() {
        return this.tabs.get(this.tabFolder.getSelectionIndex()).getVisibleElements();
    }

    public void layout() {
        this.tabs.get(this.tabFolder.getSelectionIndex()).redraw();
    }

    public void navigateToDiff(DiffElement diff) {
        ArrayList<DiffElement> diffs = new ArrayList<DiffElement>();
        diffs.add(diff);
        this.navigateToDiff(diffs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void navigateToDiff(List<DiffElement> diffs) {
        EObject target = null;
        if (this.partSide == 1) {
            target = EMFCompareEObjectUtils.getLeftElement((EObject)diffs.get(0));
        } else if (this.partSide == 2) {
            if (diffs.get(0) instanceof DiffGroup && EMFCompareEObjectUtils.getLeftElement((EObject)diffs.get(0)) != null) {
                target = EMFCompareEObjectUtils.getRightElement(this.findMatchFromElement(EMFCompareEObjectUtils.getLeftElement((EObject)diffs.get(0))));
            } else {
                if (diffs.get(0) instanceof DiffGroup) return;
                target = EMFCompareEObjectUtils.getRightElement((EObject)diffs.get(0));
            }
        } else {
            target = EMFCompareEObjectUtils.getAncestorElement(this.findMatchFromElement(EMFCompareEObjectUtils.getLeftElement((EObject)diffs.get(0))));
        }
        this.tabs.get(this.tabFolder.getSelectionIndex()).showItems(diffs);
        this.properties.setReflectiveInput(this.findMatchFromElement(target));
        this.parentViewer.getConfiguration().setProperty("content.selection.changed", (Object)diffs.get(0));
        this.parentViewer.updateCenter();
    }

    public void removeCompareEditorPartListener(ICompareEditorPartListener listener) {
        this.editorPartListeners.remove(listener);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Rectangle(x, y, width, height));
    }

    public void setBounds(Rectangle bounds) {
        this.tabFolder.setBounds(bounds);
        this.resizeBounds();
    }

    public void setInput(Object input) {
        IModelContentMergeViewerTab currentTab = this.tabs.get(this.tabFolder.getSelectionIndex());
        if (currentTab == this.properties && input instanceof EObject) {
            currentTab.setReflectiveInput(this.findMatchFromElement((EObject)input));
        } else {
            this.tabs.get(this.tabFolder.getSelectionIndex()).setReflectiveInput(input);
        }
    }

    public void setSelectedTab(int index) {
        this.tabFolder.setSelection(index);
        this.resizeBounds();
    }

    protected void createContents(Composite composite) {
        this.tabFolder = new CTabFolder(composite, 1024);
        CTabItem treeTab = new CTabItem(this.tabFolder, 0);
        treeTab.setText(EMFCompareUIMessages.getString("ModelContentMergeViewerTabFolder.tab1.name"));
        CTabItem propertiesTab = new CTabItem(this.tabFolder, 0);
        propertiesTab.setText(EMFCompareUIMessages.getString("ModelContentMergeViewerTabFolder.tab2.name"));
        Composite treePanel = new Composite((Composite)this.tabFolder, 0);
        treePanel.setLayout((Layout)new GridLayout());
        treePanel.setLayoutData((Object)new GridData(1808));
        treePanel.setFont(composite.getFont());
        this.tree = this.createTreePart(treePanel);
        treeTab.setControl((Control)treePanel);
        Composite propertyPanel = new Composite((Composite)this.tabFolder, 0);
        propertyPanel.setLayout((Layout)new GridLayout());
        propertyPanel.setLayoutData((Object)new GridData(1808));
        propertyPanel.setFont(composite.getFont());
        this.properties = this.createPropertiesPart(propertyPanel);
        propertiesTab.setControl((Control)propertyPanel);
        this.tabs.add(this.tree);
        this.tabs.add(this.properties);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ModelContentMergeTabFolder.this.setSelectedTab(ModelContentMergeTabFolder.this.tabFolder.getSelectionIndex());
                ModelContentMergeTabFolder.this.fireSelectedtabChanged();
            }
        });
        this.tabFolder.setSelection(treeTab);
    }

    protected EObject findMatchFromElement(EObject element) {
        Match3Elements theElement = null;
        EObject match = (EObject)((ModelCompareInput)this.parentViewer.getInput()).getMatch();
        TreeIterator iterator = match.eAllContents();
        while (iterator.hasNext()) {
            UnmatchElement unmatchElement;
            Match3Elements matchElement;
            Object object = iterator.next();
            if (object instanceof Match3Elements) {
                matchElement = (Match3Elements)object;
                if (!matchElement.getLeftElement().equals(element) && !matchElement.getRightElement().equals(element) && !matchElement.getOriginElement().equals(element)) continue;
                theElement = matchElement;
                continue;
            }
            if (object instanceof Match2Elements) {
                matchElement = (Match2Elements)object;
                if (!matchElement.getLeftElement().equals(element) && !matchElement.getRightElement().equals(element)) continue;
                theElement = matchElement;
                continue;
            }
            if (!(object instanceof UnmatchElement) || !(unmatchElement = (UnmatchElement)object).getElement().equals(element)) continue;
            theElement = unmatchElement;
        }
        return theElement;
    }

    protected void fireSelectedtabChanged() {
        for (ICompareEditorPartListener listener : this.editorPartListeners) {
            listener.selectedTabChanged(this.tabFolder.getSelectionIndex());
        }
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        for (ICompareEditorPartListener listener : this.editorPartListeners) {
            listener.selectionChanged(event);
        }
    }

    protected void fireUpdateCenter() {
        for (ICompareEditorPartListener listener : this.editorPartListeners) {
            listener.updateCenter();
        }
    }

    protected void resizeBounds() {
        this.tabs.get(this.tabFolder.getSelectionIndex()).getControl().setBounds(this.tabFolder.getClientArea());
    }

    private IModelContentMergeViewerTab createPropertiesPart(Composite composite) {
        ModelContentMergePropertyTab propertiesPart = new ModelContentMergePropertyTab(composite, this.partSide, this);
        ((Scrollable)propertiesPart.getControl()).getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ModelContentMergeTabFolder.this.parentViewer.updateCenter();
            }
        });
        propertiesPart.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelContentMergeTabFolder.this.fireSelectionChanged(event);
            }
        });
        return propertiesPart;
    }

    private IModelContentMergeViewerTab createTreePart(Composite composite) {
        ModelContentMergeDiffTab treePart = new ModelContentMergeDiffTab(composite, this.partSide, this);
        ((Scrollable)treePart.getControl()).getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ModelContentMergeTabFolder.this.fireUpdateCenter();
            }
        });
        ((Tree)treePart.getControl()).addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(false);
                e.doit = false;
                ModelContentMergeTabFolder.this.parentViewer.update();
            }

            public void treeExpanded(TreeEvent e) {
                ((TreeItem)e.item).setExpanded(true);
                e.doit = false;
                ModelContentMergeTabFolder.this.parentViewer.update();
            }
        });
        treePart.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelContentMergeTabFolder.this.fireSelectionChanged(event);
            }
        });
        ((Tree)treePart.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ModelContentMergeTabFolder.this.tree.getSelectedElements().size() > 0) {
                    Item selected = ModelContentMergeTabFolder.this.tree.getSelectedElements().get(0);
                    for (DiffElement diff : ((ModelCompareInput)ModelContentMergeTabFolder.this.parentViewer.getInput()).getDiffAsList()) {
                        if (!(diff instanceof DiffGroup) && ModelContentMergeTabFolder.this.partSide == 1) {
                            if (!selected.getData().equals(EMFCompareEObjectUtils.getLeftElement((EObject)diff))) continue;
                            ModelContentMergeTabFolder.this.parentViewer.setSelection(diff);
                            continue;
                        }
                        if (diff instanceof DiffGroup || ModelContentMergeTabFolder.this.partSide != 2 || !selected.getData().equals(EMFCompareEObjectUtils.getRightElement((EObject)diff))) continue;
                        ModelContentMergeTabFolder.this.parentViewer.setSelection(diff);
                    }
                    if (!selected.isDisposed() && selected.getData() instanceof EObject) {
                        ModelContentMergeTabFolder.this.properties.setReflectiveInput(ModelContentMergeTabFolder.this.findMatchFromElement((EObject)selected.getData()));
                    }
                }
            }
        });
        return treePart;
    }
}

