/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.archive.ArchiveURLConnection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIMappingRegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIConverterImpl
implements URIConverter {
    protected static IWorkspaceRoot workspaceRoot = EcorePlugin.getWorkspaceRoot();
    private static Map<String, Boolean> efsScheme;
    private static final Method EFS_GET_FILE_SYSTEM_METHOD;
    private static final Method EFS_GET_STORE_METHOD;
    private static final Method FILE_STORE_OPEN_INPUT_STREAM_METHOD;
    private static final Method FILE_STORE_OPEN_OUTPUT_STREAM_METHOD;
    protected URIMap uriMap;

    static {
        Method efsGetStoreMethod = null;
        Method efsGetFileSystemMethod = null;
        Method fileStoreOpenInputStreamMethod = null;
        Method fileStoreOpenOutputStreamMethod = null;
        try {
            Class efsClass = CommonPlugin.loadClass((String)"org.eclipse.core.filesystem", (String)"org.eclipse.core.filesystem.EFS");
            efsGetStoreMethod = efsClass.getMethod("getStore", java.net.URI.class);
            efsGetFileSystemMethod = efsClass.getMethod("getFileSystem", String.class);
            Class<?> fileStoreClass = efsGetStoreMethod.getReturnType();
            fileStoreOpenInputStreamMethod = fileStoreClass.getMethod("openInputStream", Integer.TYPE, IProgressMonitor.class);
            fileStoreOpenOutputStreamMethod = fileStoreClass.getMethod("openOutputStream", Integer.TYPE, IProgressMonitor.class);
        }
        catch (Throwable throwable) {}
        EFS_GET_STORE_METHOD = efsGetStoreMethod;
        EFS_GET_FILE_SYSTEM_METHOD = efsGetFileSystemMethod;
        FILE_STORE_OPEN_INPUT_STREAM_METHOD = fileStoreOpenInputStreamMethod;
        FILE_STORE_OPEN_OUTPUT_STREAM_METHOD = fileStoreOpenOutputStreamMethod;
    }

    protected boolean isArchiveScheme(String scheme) {
        return "archive".equals(scheme);
    }

    protected boolean isEFSScheme(String scheme) {
        Boolean result;
        if (EFS_GET_FILE_SYSTEM_METHOD == null) {
            return false;
        }
        Boolean bl = result = efsScheme == null ? null : efsScheme.get(scheme);
        if (result == null) {
            try {
                result = EFS_GET_FILE_SYSTEM_METHOD.invoke(null, scheme) != null;
            }
            catch (Throwable throwable) {
                result = Boolean.FALSE;
            }
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            if (efsScheme != null) {
                map.putAll(efsScheme);
            }
            map.put(scheme, result);
            efsScheme = map;
        }
        return result == Boolean.TRUE;
    }

    @Override
    public OutputStream createOutputStream(URI uri) throws IOException {
        URI converted = this.normalize(uri);
        if (converted.isFile()) {
            String filePath = converted.toFileString();
            return this.createFileOutputStream(filePath);
        }
        String scheme = converted.scheme();
        if (this.isArchiveScheme(scheme)) {
            return this.createArchiveOutputStream(converted);
        }
        if (converted.isPlatformResource()) {
            return this.createPlatformResourceOutputStream(converted.toPlatformString(true));
        }
        if (this.isEFSScheme(scheme)) {
            return this.createEFSOutputStream(converted);
        }
        return this.createURLOutputStream(converted);
    }

    protected OutputStream createFileOutputStream(String filePath) throws IOException {
        File file = new File(filePath);
        String parent = file.getParent();
        if (parent != null) {
            new File(parent).mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        return outputStream;
    }

    protected OutputStream createArchiveOutputStream(URI archiveURI) throws IOException {
        return this.createArchive(archiveURI).getOutputStream();
    }

    protected OutputStream createPlatformResourceOutputStream(String platformResourcePath) throws IOException {
        if (workspaceRoot != null) {
            return WorkbenchHelper.createPlatformResourceOutputStream(platformResourcePath);
        }
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        if (resolvedLocation != null) {
            return this.createOutputStream(resolvedLocation);
        }
        throw new IOException("The path '" + platformResourcePath + "' is unmapped");
    }

    protected OutputStream createEFSOutputStream(URI uri) throws IOException {
        if (EFS_GET_STORE_METHOD != null) {
            try {
                Object store = EFS_GET_STORE_METHOD.invoke(null, new java.net.URI(uri.toString()));
                if (store != null) {
                    return (OutputStream)FILE_STORE_OPEN_OUTPUT_STREAM_METHOD.invoke(store, 0, null);
                }
            }
            catch (Exception exception) {
                throw new Resource.IOWrappedException(exception);
            }
        }
        throw new IOException("EFS unavailable");
    }

    protected OutputStream createURLOutputStream(URI uri) throws IOException {
        try {
            URL url = new URL(uri.toString());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            return urlConnection.getOutputStream();
        }
        catch (RuntimeException exception) {
            throw new Resource.IOWrappedException(exception);
        }
    }

    @Override
    public InputStream createInputStream(URI uri) throws IOException {
        URI converted = this.normalize(uri);
        if (converted.isFile()) {
            String filePath = converted.toFileString();
            return this.createFileInputStream(filePath);
        }
        String scheme = converted.scheme();
        if (this.isArchiveScheme(scheme)) {
            return this.createArchiveInputStream(converted);
        }
        if (converted.isPlatformResource()) {
            return this.createPlatformResourceInputStream(converted.toPlatformString(true));
        }
        if (this.isEFSScheme(scheme)) {
            return this.createEFSInputStream(converted);
        }
        return this.createURLInputStream(converted);
    }

    protected InputStream createFileInputStream(String filePath) throws IOException {
        File file = new File(filePath);
        FileInputStream inputStream = new FileInputStream(file);
        return inputStream;
    }

    protected Archive createArchive(URI uri) {
        return new Archive(uri);
    }

    protected InputStream createArchiveInputStream(URI archiveURI) throws IOException {
        return this.createArchive(archiveURI).getInputStream();
    }

    protected InputStream createPlatformResourceInputStream(String platformResourcePath) throws IOException {
        if (workspaceRoot != null) {
            return WorkbenchHelper.createPlatformResourceInputStream(platformResourcePath);
        }
        URI resolvedLocation = EcorePlugin.resolvePlatformResourcePath(platformResourcePath);
        if (resolvedLocation != null) {
            return this.createInputStream(resolvedLocation);
        }
        throw new IOException("The path '" + platformResourcePath + "' is unmapped");
    }

    protected InputStream createEFSInputStream(URI uri) throws IOException {
        if (EFS_GET_STORE_METHOD != null) {
            try {
                Object store = EFS_GET_STORE_METHOD.invoke(null, new java.net.URI(uri.toString()));
                if (store != null) {
                    return (InputStream)FILE_STORE_OPEN_INPUT_STREAM_METHOD.invoke(store, 0, null);
                }
            }
            catch (Exception exception) {
                throw new Resource.IOWrappedException(exception);
            }
        }
        throw new IOException("EFS unavailable");
    }

    protected InputStream createURLInputStream(URI uri) throws IOException {
        try {
            URL url = new URL(uri.toString());
            URLConnection urlConnection = url.openConnection();
            return urlConnection.getInputStream();
        }
        catch (RuntimeException exception) {
            throw new Resource.IOWrappedException(exception);
        }
    }

    @Override
    public URI normalize(URI uri) {
        String fragment = uri.fragment();
        URI result = fragment == null ? this.getInternalURIMap().getURI(uri) : this.getInternalURIMap().getURI(uri.trimFragment()).appendFragment(fragment);
        String scheme = result.scheme();
        if (scheme == null) {
            if (workspaceRoot != null) {
                if (result.hasAbsolutePath()) {
                    result = URI.createPlatformResourceURI((String)result.trimFragment().toString(), (boolean)false);
                    if (fragment != null) {
                        result = result.appendFragment(fragment);
                    }
                }
            } else if (result.hasAbsolutePath()) {
                result = URI.createURI((String)("file:" + result));
            } else {
                result = URI.createFileURI((String)new File(result.trimFragment().toString()).getAbsolutePath());
                if (fragment != null) {
                    result = result.appendFragment(fragment);
                }
            }
        }
        if (result.equals((Object)uri)) {
            return uri;
        }
        return this.normalize(result);
    }

    @Override
    public Map<URI, URI> getURIMap() {
        return this.getInternalURIMap();
    }

    protected URIMap getInternalURIMap() {
        if (this.uriMap == null) {
            URIMappingRegistryImpl mappingRegistryImpl = new URIMappingRegistryImpl(){
                private static final long serialVersionUID = 1L;

                protected URI delegatedGetURI(URI uri) {
                    return URIMappingRegistryImpl.INSTANCE.getURI(uri);
                }
            };
            this.uriMap = (URIMap)mappingRegistryImpl.map();
        }
        return this.uriMap;
    }

    protected class Archive
    extends ArchiveURLConnection {
        public Archive(URI uri) {
            super(uri.toString());
        }

        protected boolean emulateArchiveScheme() {
            return false;
        }

        protected boolean useZipFile() {
            return true;
        }

        protected InputStream createInputStream(String nestedURL) throws IOException {
            return URIConverterImpl.this.createInputStream(URI.createURI((String)nestedURL));
        }

        protected OutputStream createOutputStream(String nestedURL) throws IOException {
            return URIConverterImpl.this.createOutputStream(URI.createURI((String)nestedURL));
        }
    }

    public static class PlatformResourceOutputStream
    extends ByteArrayOutputStream {
        protected IFile file;
        protected boolean force;
        protected boolean keepHistory;
        protected IProgressMonitor progressMonitor;
        protected boolean previouslyFlushed;

        public PlatformResourceOutputStream(IFile file, boolean force, boolean keepHistory, IProgressMonitor progressMonitor) {
            this.file = file;
            this.force = force;
            this.keepHistory = keepHistory;
            this.progressMonitor = progressMonitor;
        }

        protected void createContainer(IContainer container) throws IOException {
            if (!container.exists() && container.getType() == 2) {
                this.createContainer(container.getParent());
                try {
                    ((IFolder)container).create(this.force, this.keepHistory, this.progressMonitor);
                }
                catch (CoreException exception) {
                    throw new Resource.IOWrappedException((Exception)((Object)exception));
                }
            }
        }

        public void close() throws IOException {
            this.flush();
            super.close();
        }

        public void flush() throws IOException {
            super.flush();
            if (this.previouslyFlushed) {
                if (this.count == 0) {
                    return;
                }
            } else {
                this.createContainer(this.file.getParent());
            }
            byte[] contents = this.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(contents, 0, contents.length);
            try {
                if (this.previouslyFlushed) {
                    this.file.appendContents((InputStream)inputStream, this.force, false, this.progressMonitor);
                } else if (!this.file.exists()) {
                    this.file.create((InputStream)inputStream, false, null);
                    this.previouslyFlushed = true;
                } else {
                    if (!this.file.isSynchronized(1)) {
                        this.file.refreshLocal(1, this.progressMonitor);
                    }
                    this.file.setContents((InputStream)inputStream, this.force, this.keepHistory, this.progressMonitor);
                    this.previouslyFlushed = true;
                }
                this.reset();
            }
            catch (CoreException exception) {
                throw new Resource.IOWrappedException((Exception)((Object)exception));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface URIMap
    extends Map<URI, URI> {
        public URI getURI(URI var1);
    }

    public static class WorkbenchHelper {
        public static OutputStream createPlatformResourceOutputStream(String platformResourcePath) throws IOException {
            IFile file = workspaceRoot.getFile((IPath)new Path(platformResourcePath));
            return new PlatformResourceOutputStream(file, false, true, null);
        }

        public static InputStream createPlatformResourceInputStream(String platformResourcePath) throws IOException {
            IFile file = workspaceRoot.getFile((IPath)new Path(platformResourcePath));
            try {
                if (!file.isSynchronized(1)) {
                    file.refreshLocal(1, null);
                }
                return file.getContents();
            }
            catch (CoreException exception) {
                throw new Resource.IOWrappedException((Exception)((Object)exception));
            }
        }
    }
}

