/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buddies.internal.ui.dnd;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.internal.ui.bundle.OM;
import org.eclipse.net4j.internal.buddies.SessionManager;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.ui.dnd.DNDTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddiesTransfer
extends DNDTransfer<IBuddy[]> {
    public static final String TYPE_NAME = "buddies-transfer-format";
    public static final BuddiesTransfer INSTANCE = new BuddiesTransfer();

    public BuddiesTransfer() {
        super(TYPE_NAME);
    }

    protected void writeObject(ExtendedDataOutputStream out, IBuddy[] buddies) throws IOException {
        out.writeInt(buddies.length);
        IBuddy[] iBuddyArray = buddies;
        int n = buddies.length;
        int n2 = 0;
        while (n2 < n) {
            IBuddy buddy = iBuddyArray[n2];
            out.writeString(buddy.getUserID());
            ++n2;
        }
    }

    protected IBuddy[] readObject(ExtendedDataInputStream in) throws IOException {
        IBuddySession session = SessionManager.INSTANCE.getSession();
        if (session == null) {
            OM.LOG.warn("Buddy session is not available");
            return null;
        }
        ArrayList<IBuddy> buddies = new ArrayList<IBuddy>();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String userID = in.readString();
            IBuddy buddy = session.getBuddy(userID);
            if (buddy != null) {
                buddies.add(buddy);
            } else {
                OM.LOG.warn("Buddy is not available: " + userID);
            }
            ++i;
        }
        return buddies.toArray(new IBuddy[buddies.size()]);
    }
}

