/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.buddies;

import java.util.ArrayList;
import org.eclipse.net4j.buddies.IBuddyCollaboration;
import org.eclipse.net4j.buddies.IBuddySession;
import org.eclipse.net4j.buddies.common.IBuddy;
import org.eclipse.net4j.buddies.common.ICollaboration;
import org.eclipse.net4j.buddies.common.IFacility;
import org.eclipse.net4j.buddies.common.IMessage;
import org.eclipse.net4j.buddies.internal.common.Collaboration;
import org.eclipse.net4j.buddies.internal.common.protocol.CollaborationLeftNotification;
import org.eclipse.net4j.buddies.internal.common.protocol.MessageNotification;
import org.eclipse.net4j.buddies.spi.common.Message;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.internal.buddies.protocol.InstallFacilityRequest;
import org.eclipse.net4j.internal.buddies.protocol.InviteBuddiesNotification;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.IPluginContainer;

public class BuddyCollaboration
extends Collaboration
implements IBuddyCollaboration {
    private static final String FACILITY_GROUP = "org.eclipse.net4j.buddies.clientFacilities";
    private IBuddySession session;

    public BuddyCollaboration(IBuddySession session, long id) {
        super(id);
        this.session = session;
    }

    public IBuddySession getSession() {
        return this.session;
    }

    public IFacility installFacility(String type) {
        return this.installFacility(type, true);
    }

    public IFacility installFacility(String type, boolean request) {
        IFacility facility = this.createFacility(type);
        if (request) {
            try {
                IChannel channel = this.session.getChannel();
                boolean success = (Boolean)new InstallFacilityRequest(channel, this.getID(), type).send(5000L);
                if (!success) {
                    return null;
                }
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        this.addFacility(facility, !request);
        return facility;
    }

    public IFacility createFacility(String type) {
        IFacility facility = (IFacility)this.getContainer().getElement(FACILITY_GROUP, type, String.valueOf(this.getID()));
        facility.setCollaboration((ICollaboration)this);
        return facility;
    }

    public void sendMessage(long collaborationID, String facilityType, IMessage message) {
        if (message instanceof Message) {
            ((Message)message).setSenderID(this.session.getSelf().getUserID());
        }
        try {
            IChannel channel = this.session.getChannel();
            new MessageNotification(channel, collaborationID, facilityType, message).send();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public IBuddy[] invite(String ... userIDs) {
        ArrayList<IBuddy> buddies = new ArrayList<IBuddy>();
        String[] stringArray = userIDs;
        int n = userIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String userID = stringArray[n2];
            IBuddy buddy = this.session.getBuddy(userID);
            buddies.add(buddy);
            ++n2;
        }
        IBuddy[] array = buddies.toArray(new IBuddy[buddies.size()]);
        this.invite(array);
        return array;
    }

    public void invite(IBuddy ... buddies) {
        ArrayList<IBuddy> invitations = new ArrayList<IBuddy>();
        IBuddy[] iBuddyArray = buddies;
        int n = buddies.length;
        int n2 = 0;
        while (n2 < n) {
            IBuddy buddy = iBuddyArray[n2];
            if (this.getMembership(buddy) == null) {
                invitations.add(buddy);
            }
            ++n2;
        }
        if (!invitations.isEmpty()) {
            try {
                IChannel channel = this.session.getChannel();
                new InviteBuddiesNotification(channel, this.getID(), invitations).send();
            }
            catch (Exception ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
    }

    public void leave() {
        try {
            IChannel channel = this.session.getChannel();
            new CollaborationLeftNotification(channel, this.getID(), this.session.getSelf().getUserID()).send();
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        this.deactivate();
    }

    protected IPluginContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }
}

