/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.lifecycle;

import java.util.concurrent.Semaphore;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.lifecycle.ILifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleEvent;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class Lifecycle
extends Notifier
implements ILifecycle.Introspection {
    public static boolean USE_LABEL = true;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_LIFECYCLE, Lifecycle.class);
    private static final ContextTracer DUMPER = new ContextTracer(OM.DEBUG_LIFECYCLE_DUMP, Lifecycle.class);
    private static final boolean TRACE_IGNORING = false;
    private static final boolean LOCKING = true;
    private ILifecycleState lifecycleState = ILifecycleState.INACTIVE;
    @ReflectUtil.ExcludeFromDump
    private Semaphore lifecycleSemaphore = new Semaphore(1);

    public final void activate() throws LifecycleException {
        try {
            if (this.lifecycleState == ILifecycleState.INACTIVE) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Activating " + this);
                }
                this.lock();
                this.lifecycleState = ILifecycleState.ACTIVATING;
                this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ABOUT_TO_ACTIVATE));
                this.doBeforeActivate();
                this.doActivate();
                if (!this.isDeferredActivation()) {
                    this.deferredActivate(true);
                }
                this.dump();
            }
        }
        catch (RuntimeException ex) {
            this.deferredActivate(false);
            throw ex;
        }
        catch (Exception ex) {
            this.deferredActivate(false);
            throw new LifecycleException(ex);
        }
    }

    public final Exception deactivate() {
        try {
            if (this.lifecycleState == ILifecycleState.ACTIVE) {
                if (TRACER.isEnabled()) {
                    TRACER.trace("Deactivating " + this);
                }
                this.lock();
                this.lifecycleState = ILifecycleState.DEACTIVATING;
                this.doBeforeDeactivate();
                this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ABOUT_TO_DEACTIVATE));
                this.doDeactivate();
                this.lifecycleState = ILifecycleState.INACTIVE;
                this.unlock();
                this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.DEACTIVATED));
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            this.lifecycleState = ILifecycleState.INACTIVE;
            this.unlock();
            return ex;
        }
    }

    public final ILifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public final boolean isActive() {
        return this.lifecycleState == ILifecycleState.ACTIVE;
    }

    public String toString() {
        if (USE_LABEL) {
            return ReflectUtil.getLabel(this);
        }
        return super.toString();
    }

    protected final void dump() {
        if (DUMPER.isEnabled()) {
            DUMPER.trace("DUMP" + ReflectUtil.toString(this));
        }
    }

    protected final void checkActive() {
        LifecycleUtil.checkActive(this);
    }

    protected final void checkInactive() {
        LifecycleUtil.checkInactive(this);
    }

    protected final void checkNull(Object handle, String msg) throws NullPointerException {
        CheckUtil.checkNull(handle, msg);
    }

    protected final void checkArg(boolean expr, String msg) throws IllegalArgumentException {
        CheckUtil.checkArg(expr, msg);
    }

    protected final void checkArg(Object handle, String handleName) throws IllegalArgumentException {
        CheckUtil.checkState(handle, handleName);
    }

    protected final void checkState(boolean expr, String msg) throws IllegalStateException {
        CheckUtil.checkState(expr, msg);
    }

    protected final void checkState(Object handle, String handleName) throws IllegalStateException {
        CheckUtil.checkState(handle, handleName);
    }

    protected final void deferredActivate(boolean successful) {
        if (successful) {
            this.lifecycleState = ILifecycleState.ACTIVE;
            this.unlock();
            this.fireEvent(new LifecycleEvent(this, ILifecycleEvent.Kind.ACTIVATED));
        } else {
            this.lifecycleState = ILifecycleState.INACTIVE;
            this.unlock();
        }
    }

    protected boolean isDeferredActivation() {
        return false;
    }

    protected void doBeforeActivate() throws Exception {
    }

    protected void doActivate() throws Exception {
    }

    protected void doBeforeDeactivate() throws Exception {
    }

    protected void doDeactivate() throws Exception {
    }

    private void lock() throws InterruptedException {
        this.lifecycleSemaphore.acquire();
    }

    private void unlock() {
        this.lifecycleSemaphore.release();
    }
}

