/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.drda.DRDAStatement;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.jdbc.EmbedConnection;

class Database {
    protected String dbName;
    protected String shortDbName;
    String attrString = "";
    protected int securityMechanism;
    protected String userId;
    protected String password;
    protected String decryptedUserId;
    protected String decryptedPassword;
    protected boolean rdbAllowUpdates = true;
    protected int accessCount;
    protected byte[] publicKeyIn;
    protected byte[] publicKeyOut;
    protected byte[] crrtkn;
    protected String typDefNam;
    protected int byteOrder;
    protected int ccsidSBC;
    protected int ccsidDBC;
    protected int ccsidMBC;
    protected String ccsidSBCEncoding;
    protected String ccsidDBCEncoding;
    protected String ccsidMBCEncoding;
    protected boolean RDBUPDRM_sent = false;
    protected boolean sendTRGDFTRT = false;
    private Connection conn;
    DRDAStatement defaultStatement;
    private DRDAStatement currentStatement;
    Hashtable stmtTable;
    boolean forXA = false;

    protected Database(String string) {
        if (string != null) {
            int n = string.indexOf(59);
            if (n != -1) {
                this.attrString = string.substring(n, string.length());
                this.shortDbName = string.substring(0, n);
            } else {
                this.shortDbName = string;
            }
        }
        this.dbName = string;
        this.stmtTable = new Hashtable();
        this.initializeDefaultStatement();
    }

    private void initializeDefaultStatement() {
        this.defaultStatement = new DRDAStatement(this);
    }

    protected void setConnection(Connection connection) throws SQLException {
        this.conn = connection;
        if (connection != null) {
            this.defaultStatement.setStatement(connection);
        }
    }

    protected Connection getConnection() {
        return this.conn;
    }

    protected DRDAStatement getCurrentStatement() {
        return this.currentStatement;
    }

    protected DRDAStatement getDefaultStatement() {
        this.currentStatement = this.defaultStatement;
        return this.defaultStatement;
    }

    protected DRDAStatement getDefaultStatement(String string) {
        this.currentStatement = this.defaultStatement;
        this.currentStatement.setPkgnamcsn(string);
        return this.currentStatement;
    }

    protected PreparedStatement getPreparedStatement(String string) throws SQLException {
        this.currentStatement = this.getDRDAStatement(string);
        if (this.currentStatement == null) {
            return null;
        }
        return this.currentStatement.getPreparedStatement();
    }

    protected DRDAStatement newDRDAStatement(String string) throws SQLException {
        DRDAStatement dRDAStatement = this.getDRDAStatement(string);
        if (dRDAStatement != null) {
            dRDAStatement.close();
        } else {
            dRDAStatement = new DRDAStatement(this);
            dRDAStatement.setPkgnamcsn(string);
            this.storeStatement(dRDAStatement);
        }
        return dRDAStatement;
    }

    protected DRDAStatement getDRDAStatement(String string) throws SQLException {
        String string2 = this.getStmtKey(string);
        DRDAStatement dRDAStatement = null;
        if (this.currentStatement == null || !string2.equals(this.getStmtKey(this.currentStatement.getPkgnamcsn()))) {
            // empty if block
        }
        if ((dRDAStatement = (DRDAStatement)this.stmtTable.get(string2)) == null) {
            return null;
        }
        this.currentStatement = dRDAStatement;
        this.currentStatement.setCurrentDrdaResultSet(string);
        return this.currentStatement;
    }

    protected Connection makeConnection(Properties properties) throws SQLException {
        Connection connection;
        properties.put("user", this.userId);
        if (this.password != null) {
            properties.put("password", this.password);
        }
        if ((connection = NetworkServerControlImpl.getDriver().connect("jdbc:derby:" + this.shortDbName + this.attrString, properties)) != null) {
            connection.setAutoCommit(false);
        }
        this.setConnection(connection);
        return connection;
    }

    String appendAttrString(Properties properties) {
        if (properties == null) {
            return null;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.attrString = this.attrString + ";" + string + "=" + properties.getProperty(string);
        }
        return this.attrString;
    }

    protected ResultSet getResultSet(String string) throws SQLException {
        return this.getDRDAStatement(string).getResultSet();
    }

    protected void setResultSet(ResultSet resultSet) throws SQLException {
        this.currentStatement.setResultSet(resultSet);
    }

    protected void storeStatement(DRDAStatement dRDAStatement) throws SQLException {
        this.stmtTable.put(this.getStmtKey(dRDAStatement.getPkgnamcsn()), dRDAStatement);
    }

    protected void removeStatement(DRDAStatement dRDAStatement) throws SQLException {
        this.stmtTable.remove(dRDAStatement.getPkgnamcsn());
        dRDAStatement.close();
    }

    protected void setCurrentStatement(DRDAStatement dRDAStatement) {
        this.currentStatement = dRDAStatement;
    }

    protected void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    protected void rollback() throws SQLException {
        if (this.conn != null) {
            this.conn.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws SQLException {
        try {
            if (this.stmtTable != null) {
                Enumeration enumeration = this.stmtTable.elements();
                while (enumeration.hasMoreElements()) {
                    ((DRDAStatement)enumeration.nextElement()).close();
                }
            }
            if (this.defaultStatement != null) {
                this.defaultStatement.close();
            }
            if (this.conn != null && !this.conn.isClosed()) {
                if (!this.forXA) {
                    this.conn.rollback();
                }
                this.conn.close();
            }
            Object var3_2 = null;
            this.conn = null;
            this.currentStatement = null;
            this.defaultStatement = null;
            this.stmtTable = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.conn = null;
            this.currentStatement = null;
            this.defaultStatement = null;
            this.stmtTable = null;
            throw throwable;
        }
    }

    protected void setDrdaID(String string) {
        if (this.conn != null) {
            ((EmbedConnection)this.conn).setDrdaID(string);
        }
    }

    protected void setPrepareIsolation(int n) throws SQLException {
        ((EmbedConnection)this.conn).setPrepareIsolation(n);
    }

    protected int getPrepareIsolation() throws SQLException {
        return ((EmbedConnection)this.conn).getPrepareIsolation();
    }

    protected String buildRuntimeInfo(String string, LocalizedResource localizedResource) {
        String string2 = string + localizedResource.getTextMessage("DRDA_RuntimeInfoDatabase.I") + this.dbName + "\n" + localizedResource.getTextMessage("DRDA_RuntimeInfoUser.I") + this.userId + "\n" + localizedResource.getTextMessage("DRDA_RuntimeInfoNumStatements.I") + this.stmtTable.size() + "\n";
        string2 = string2 + localizedResource.getTextMessage("DRDA_RuntimeInfoPreparedStatementHeader.I");
        Enumeration enumeration = this.stmtTable.elements();
        while (enumeration.hasMoreElements()) {
            string2 = string2 + ((DRDAStatement)enumeration.nextElement()).toDebugString(string + "\t") + "\n";
        }
        return string2;
    }

    private String getStmtKey(String string) {
        if (string == null) {
            return null;
        }
        return string.substring(0, string.length() - 8);
    }
}

