/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListIndexAffecting;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORemoveFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDORemoveFeatureDelta,
IListIndexAffecting {
    private int index;

    public CDORemoveFeatureDeltaImpl(CDOFeature feature, int index) {
        super(feature);
        this.index = index;
    }

    public CDORemoveFeatureDeltaImpl(ExtendedDataInput in, CDOClass cdoClass) throws IOException {
        super(in, cdoClass);
        this.index = in.readInt();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.REMOVE;
    }

    @Override
    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).getList(this.getFeature()).remove(this.index);
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(ExtendedDataOutput out, CDOClass cdoClass, CDOIDProvider idProvider) throws IOException {
        super.write(out, cdoClass, idProvider);
        out.writeInt(this.index);
    }

    @Override
    public void affectIndices(int[] indices) {
        int index = this.getIndex();
        int i = 1;
        while (i <= indices[0]) {
            if (indices[i] > index) {
                int n = i;
                indices[n] = indices[n] - 1;
            } else if (indices[i] == index) {
                int n = indices[0];
                indices[0] = n - 1;
                int rest = n - i;
                if (rest > 0) {
                    System.arraycopy(indices, i + 1, indices, i, rest);
                    --i;
                }
            }
            ++i;
        }
    }

    @Override
    public void adjustReferences(Map<CDOIDTemp, CDOID> idMappings) {
    }
}

