/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IPreparedStatementCache;
import org.eclipse.emf.cdo.server.db.mapping.IListMapping;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractListTableMapping;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.util.ImplementationError;

public class NonAuditListTableMapping
extends AbstractListTableMapping
implements IListMapping,
IListMappingDeltaSupport {
    private static final AbstractListTableMapping.FieldInfo[] KEY_FIELDS = new AbstractListTableMapping.FieldInfo[]{new AbstractListTableMapping.FieldInfo("cdo_source", DBType.BIGINT)};
    private static final int TEMP_INDEX = -1;
    private static final int UNBOUNDED_MOVE = -1;
    private String sqlClear;
    private String sqlUpdateValue;
    private String sqlUpdateIndex;
    private String sqlInsertValue;
    private String sqlDeleteItem;
    private String sqlMoveDownWithLimit;
    private String sqlMoveDown;
    private String sqlMoveUpWithLimit;
    private String sqlMoveUp;

    public NonAuditListTableMapping(IMappingStrategy mappingStrategy, EClass eClass, EStructuralFeature feature) {
        super(mappingStrategy, eClass, feature);
        this.initSqlStrings();
    }

    private void initSqlStrings() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE FROM ");
        builder.append(this.getTable().getName());
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append(" = ? ");
        this.sqlClear = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append(" = ? ");
        this.sqlDeleteItem = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable().getName());
        builder.append(" SET ");
        builder.append("cdo_value");
        builder.append(" = ? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append(" = ? AND ");
        builder.append("cdo_idx");
        builder.append(" = ? ");
        this.sqlUpdateValue = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable().getName());
        builder.append(" VALUES(?, ?, ?) ");
        this.sqlInsertValue = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable().getName());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append(" = ? ");
        builder.append(" WHERE ");
        builder.append("cdo_source");
        builder.append(" = ? AND ");
        builder.append("cdo_idx");
        builder.append(" = ? ");
        this.sqlUpdateIndex = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable().getName());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append(" = ");
        builder.append("cdo_idx");
        builder.append("-1 WHERE ");
        builder.append("cdo_source");
        builder.append("= ? AND ");
        builder.append("cdo_idx");
        builder.append(" > ? ");
        this.sqlMoveDown = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append(" <= ?");
        this.sqlMoveDownWithLimit = builder.toString();
        builder = new StringBuilder();
        builder.append("UPDATE ");
        builder.append(this.getTable().getName());
        builder.append(" SET ");
        builder.append("cdo_idx");
        builder.append(" = ");
        builder.append("cdo_idx");
        builder.append("+1 WHERE ");
        builder.append("cdo_source");
        builder.append("= ? AND ");
        builder.append("cdo_idx");
        builder.append(" >= ? ");
        this.sqlMoveUp = builder.toString();
        builder.append(" AND ");
        builder.append("cdo_idx");
        builder.append(" < ?");
        this.sqlMoveUpWithLimit = builder.toString();
    }

    protected AbstractListTableMapping.FieldInfo[] getKeyFields() {
        return KEY_FIELDS;
    }

    protected void setKeyFields(PreparedStatement stmt, CDORevision revision) throws SQLException {
        stmt.setLong(1, CDOIDUtil.getLong((CDOID)revision.getID()));
    }

    public void objectRevised(IDBStoreAccessor accessor, CDOID id, long revised) {
        this.clearList(accessor, id);
    }

    public void clearList(IDBStoreAccessor accessor, CDOID id) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlClear, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                CDODBUtil.sqlUpdate(stmt, false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public void insertListItem(IDBStoreAccessor accessor, CDOID id, int index, Object value) {
        this.move1up(accessor, id, index, -1);
        this.insertValue(accessor, id, index, value);
    }

    private void insertValue(IDBStoreAccessor accessor, CDOID id, int index, Object value) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlInsertValue, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(2, index);
                this.getTypeMapping().setValue(stmt, 3, value);
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public void moveListItem(IDBStoreAccessor accessor, CDOID id, int oldPosition, int newPosition) {
        if (oldPosition == newPosition) {
            return;
        }
        this.updateOneIndex(accessor, id, oldPosition, -1);
        if (oldPosition < newPosition) {
            this.move1down(accessor, id, oldPosition, newPosition);
        } else {
            this.move1up(accessor, id, newPosition, oldPosition);
        }
        this.updateOneIndex(accessor, id, -1, newPosition);
    }

    private void updateOneIndex(IDBStoreAccessor accessor, CDOID id, int oldIndex, int newIndex) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlUpdateIndex, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setInt(1, newIndex);
                stmt.setLong(2, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(3, oldIndex);
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public void removeListItem(IDBStoreAccessor accessor, CDOID id, int index) {
        this.deleteItem(accessor, id, index);
        this.move1down(accessor, id, index, -1);
    }

    private void move1down(IDBStoreAccessor accessor, CDOID id, int index, int upperIndex) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(upperIndex == -1 ? this.sqlMoveDown : this.sqlMoveDownWithLimit, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(2, index);
                if (upperIndex != -1) {
                    stmt.setInt(3, upperIndex);
                }
                CDODBUtil.sqlUpdate(stmt, false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    private void move1up(IDBStoreAccessor accessor, CDOID id, int index, int upperIndex) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(upperIndex == -1 ? this.sqlMoveUp : this.sqlMoveUpWithLimit, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(2, index);
                if (upperIndex != -1) {
                    stmt.setInt(3, upperIndex);
                }
                CDODBUtil.sqlUpdate(stmt, false);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    private void deleteItem(IDBStoreAccessor accessor, CDOID id, int index) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlDeleteItem, IPreparedStatementCache.ReuseProbability.HIGH);
                stmt.setLong(1, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(2, index);
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public void setListItem(IDBStoreAccessor accessor, CDOID id, int index, Object value) {
        PreparedStatement stmt = null;
        try {
            try {
                stmt = accessor.getStatementCache().getPreparedStatement(this.sqlUpdateValue, IPreparedStatementCache.ReuseProbability.HIGH);
                this.getTypeMapping().setValue(stmt, 1, value);
                stmt.setLong(2, CDOIDUtil.getLong((CDOID)id));
                stmt.setInt(3, index);
                CDODBUtil.sqlUpdate(stmt, true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            accessor.getStatementCache().releasePreparedStatement(stmt);
            throw throwable;
        }
        accessor.getStatementCache().releasePreparedStatement(stmt);
    }

    public void processDelta(final IDBStoreAccessor accessor, final CDOID id, int oldVersion, int newVersion, long created, CDOListFeatureDelta listDelta) {
        CDOFeatureDeltaVisitor visitor = new CDOFeatureDeltaVisitor(){

            public void visit(CDOMoveFeatureDelta delta) {
                NonAuditListTableMapping.this.moveListItem(accessor, id, delta.getOldPosition(), delta.getNewPosition());
            }

            public void visit(CDOAddFeatureDelta delta) {
                NonAuditListTableMapping.this.insertListItem(accessor, id, delta.getIndex(), delta.getValue());
            }

            public void visit(CDORemoveFeatureDelta delta) {
                NonAuditListTableMapping.this.removeListItem(accessor, id, delta.getIndex());
            }

            public void visit(CDOSetFeatureDelta delta) {
                NonAuditListTableMapping.this.setListItem(accessor, id, delta.getIndex(), delta.getValue());
            }

            public void visit(CDOUnsetFeatureDelta delta) {
                throw new ImplementationError("Should not be called");
            }

            public void visit(CDOListFeatureDelta delta) {
                throw new ImplementationError("Should not be called");
            }

            public void visit(CDOClearFeatureDelta delta) {
                NonAuditListTableMapping.this.clearList(accessor, id);
            }

            public void visit(CDOContainerFeatureDelta delta) {
                throw new ImplementationError("Should not be called");
            }
        };
        for (CDOFeatureDelta delta : listDelta.getListChanges()) {
            delta.accept(visitor);
        }
    }
}

